//*****************************************************************************

                // Pascal Import Unit for TinyPort

//****************************************************************************

unit tpinface;

interface

uses Windows;

Function OpenTinyPort (var Handle: THandle): DWORD; stdcall;
Function CloseTinyPort (Handle: THandle): DWORD; stdcall;
Function WriteByte
    (Handle: THandle; Address: DWORD; Data: Byte): DWORD; stdcall;
Function WriteWord
    (Handle: THandle; Address: DWORD; Data: Word): DWORD; stdcall;
Function WriteDWORD
    (Handle: THandle; Address: DWORD; Data: DWORD): DWORD;  stdcall;
Function ReadByte
    (Handle: THandle; Address: DWORD; var Data: Byte): DWORD;  stdcall;
Function ReadWord
    (Handle: THandle; Address: DWORD; var Data: Word): DWORD;  stdcall;
Function ReadDWORD
    (Handle: THandle; Address: DWORD; var Data: DWORD): DWORD;  stdcall;
Function GetTinyPortVersion
    (Handle: THandle; var Version: DWORD): DWORD;  stdcall;

{*****************************************************************************}

implementation

Function OpenTinyPort (var Handle: THandle): DWORD; stdcall;
                external 'tinypio.dll' index 1;
Function CloseTinyPort (Handle: THandle): DWORD; stdcall;
                external 'tinypio.dll' index 2;
Function WriteByte (Handle: THandle; Address: DWORD; Data: Byte): DWORD;
    stdcall; external 'tinypio.dll' index 3;
Function WriteWord (Handle: THandle; Address: DWORD; Data: Word): DWORD;
    stdcall; external 'tinypio.dll' index 4;
Function WriteDWORD (Handle: THandle; Address: DWORD; Data: DWORD): DWORD;
    stdcall; external 'tinypio.dll' index 5;
Function ReadByte (Handle: THandle; Address: DWORD; var Data: Byte): DWORD;
    stdcall; external 'tinypio.dll' index 6;
Function ReadWord (Handle: THandle; Address: DWORD; var Data: Word): DWORD;
    stdcall; external 'tinypio.dll' index 7;
Function ReadDWORD (Handle: THandle; Address: DWORD; var Data: DWORD): DWORD;
    stdcall; external 'tinypio.dll' index 8;
Function GetTinyPortVersion (Handle: THandle; var Version: DWORD): DWORD;
    stdcall; external 'tinypio.dll' index 9;

{*****************************************************************************}

end.


{ Example: A snippet of Pascal code to read port 3e0h:

       // try to get access to the port driver; stop if error
      Result := OpenTinyPort (hTPort);
      if (Result <> ERROR_SUCCESS) then
        begin
        writeln (SysErrorMessage (Result));
        exit;
        end;
      .
      .
      // read a byte
      Result := ReadByte (hTPort, $3e0, AByte);
        if (Result <> ERROR_SUCCESS) then
              writeln (SysErrorMessage (Result));
      .
      .
      // release TinyPort
      CloseTinyPort (hTPort);
}
