typedef	long	time_t;

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>

extern	int err;
extern	in_name fhost;

/* network debugger for tcp */
/* simulates packets coming in off of the network */
/* WILL NOT START UNTIL A TCP PACKET IS WRITTEN TO THE NET */
struct tcp *stp;
task	*dbgtask;
int	tcp_demon(),rnum();
char	buf[10];

tcp_demon()
{	int num;
	NDEBUG |= TPTRACE;
	tk_block();
	while(1) {
		printf("\n1. Send packet\n2. Fire ack timer\n");
		printf("3. Fire dally timer\n4. Yield process");
		fgets(buf,sizeof(buf),stdin);
		switch(buf[0]) {
		case '1': 
			psend(); 
			break;
		case '2': 
			printf("Enter connection number (%d %d %d) to wakeup > ",conlist[0],conlist[1],conlist[2]);
			num = rnum();
			if (OutOfBounds(num,1,connects))
				printf("Out of bounds");
			else tmhnd(conlist[num-1]);
			break;
		case '3': 
			printf("Enter connection number (%d %d %d) to wakeup > ",conlist[0],conlist[1],conlist[2]);
			num = rnum();
			if (OutOfBounds(num,1,connects))
				printf("Out of bounds");
			else tcp_ack(conlist[num-1]); 
			break;
		case '4': 
			tk_yield();
		}
	}
}

psend()	/* sends a simulated packet */
{	
	char c;int input;

	tcp_dpack(stp,TRUE);	/* print state of packet in full */
	while(1) {
		printf("edit packet (a,b,..z->send pkt,y->display pkt,x->exit)");
		fgets(buf,sizeof(buf),stdin);
		c = buf[0];
		if (c < 'x') {
			printf(" to value : ");
			input = rnum();
		}
		switch(c) {
		case 'a':
			stp->tc_srcp = input;
			break;
		case 'b':
			stp->tc_dstp = input;
			break;
		case 'c':
			stp->tc_seq  = input;
			break;
		case 'd':
			stp->tc_ack = input;
			break;
		case 'e':
			stp->tc_thl = input;
			break;
		case 'f':
			stp->tc_fin = input;
			break;
		case 'g':
			stp->tc_syn = input;
			break;
		case 'h':
			stp->tc_rst = input;
			break;
		case 'i':
			stp->tc_psh = input;
			break;
		case 'j':
			stp->tc_fack = input;
			break;
		case 'k':
			stp->tc_furg = input;
			break;
		case 'l':
			stp->tc_win = input;
			break;
		case 'm':
			printf("Checksum will be computed for you\n");
			break;
		case 'n':
			stp->tc_urg = input;
			break;
		case 'y':
			tcp_dpack(stp,TRUE);
			break;
		case 'z':
			sendpkt();
		case 'x':
			return;
		}
	}
}

#define	EOL	'\012'
#define	RUB	'\0177'
int rnum() /* returns a number from keyborad */
{	
	char *c; 
	int num;
	fgets(buf,sizeof(buf),stdin);
	for (c = buf, num = 0; *c != EOL ; c++)
	if (*c == RUB) num = num / 10;
	else num = num * 10 + *c -'0';
	return(num);
}

In_write(key,what,size,where)
IPCONN key;
PACKET what;
int size;
in_name where;
{	tk_wake(dbgtask);	/* wake debugger */
	return;
}

In_init()
{	char *j; int i;
	if ((stp = (struct tcp *) in_alloc(INETLEN, 0))==0)
		printf("Internet (debug) init: couldnt init packet");
	for(j = (char *) stp,i = sizeof(struct tcp); i--; *(j++) = 0);
	stp->tc_syn = 1;
	stp->tc_thl = 5;
	stp->tc_srcp= stp->tc_dstp = 79;
	stp->tc_win = 1000;
	dbgtask = tk_fork(tk_cur,tcp_demon,TCPSTACK,"InDebug",0);
	tk_yield();
}

sendpkt()
{	int idlen,len;	long *tp;
	/* compute incoming tcp checksum here... */
	printf("Type data for packet:");
	gets((char *) stp + sizeof(struct tcp));
	idlen = strlen((char *) stp + sizeof(struct tcp));
	len = idlen + 20;
	iphp.tp_len = len;
	iphp.tp_len = swab(iphp.tp_len);
	iphp.tp_dst = in_mymach(99);
	iphp.tp_src = fhost;
	tp = (long *) &iphp;
	printf("PSEUDO HEADER:\n%X\n%X\n%X\n",tp[0],tp[1],tp[2]);
	tcp_swab(stp);
	stp->tc_cksum = cksum(&iphp, sizeof(struct tcpph) >> 1, 0);
	stp->tc_cksum = ~cksum(stp,((idlen + 1) >> 1) + (stp->tc_thl << 1),0);
	tcp_rcv((PACKET) stp, len, fhost);
}

tcp_dpack(p,pshd)
struct tcp *p;	/* pointer to tcp header */
struct tcpph *pshd;	
{	
	long *ptr;
	ptr = (long *) pshd;
	printf("srcp(a)\tdstp(b)\tseq(c)\tack#(d)\tlth(e)\tfin(f)\tsyn(g)\tPSEUDOHDR\n");
	printf("%d\t%d\t%U\t%U\t%d\t%d\t%d\t%X\n",p->tc_srcp,p->tc_dstp,
	p->tc_seq,p->tc_ack,p->tc_thl,p->tc_fin,p->tc_syn,*ptr++);
	printf("rst(h)\tpsh(i)\tfack(j)\tfurg(k)\twin(l)\tcksm(m)\turg(n)\t%X\n",*ptr++);
	printf("%d\t%d\t%d\t%d\t%u\t%u\t%u\t%X\n",p->tc_rst,p->tc_psh,
	p->tc_fack,p->tc_furg,p->tc_win,p->tc_cksum,p->tc_urg,*ptr++);
}

