/*  Copyright 1986 by Carnegie Mellon  */
/*  See permission and disclaimer notice in file "cmu-note.h"  */
#include	<cmu-note.h>
/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

#include <stdio.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include "slip.h"
#include "sl.h"

extern long cticks;
extern int MaxLnh;

/* Some internals... */
char sl_busy = FALSE;	/* Are we inputting a packet? */
PACKET sl_buff = NULL;	/* The buffer */
char *sl_cp = NULL;	/* Current position in buffer */
int sl_len = 0;		/* Current sl_length of packet */

/* Statistics counters */
unsigned badtx = 0, serint = 0;	/* Counts of bad serial port events. */
unsigned slrcv = 0;		/* number of packets received */
unsigned slbrcv = 0;		/* number of bytes received */
unsigned slresc = 0;		/* number of slip ESCs received */
unsigned sldrop = 0;		/* number of packets dropped */
unsigned slref  = 0;		/* number of failed packets allocations */


/*
 * sl_bin() reads a packet from the serial port from the gateway into
 *	the buffer pointed to by RBUF. It sets the global variable Rsl_len
 *	to the sl_length of the packet.
 */
sl_bin(rdchr)
	register char rdchr;
{
	static char escflag = FALSE;

	sl_busy = TRUE;
	slbrcv++;
	if(!sl_buff) {
		if((sl_buff = getfree()) == nullbuf) {
			slref++;
			return;
		}
		sl_cp = sl_buff->nb_prot;	/* Find buffer */
		sl_len = 0;
	}

	if(escflag) {
		escflag = FALSE;
		if(rdchr == TRANS_FRAME_ESC)
			rdchr = FRAME_ESC;
		else if(rdchr == TRANS_FRAME_END)
			rdchr = FRAME_END;
		else {
			sldrop++;
			sl_cp = sl_buff->nb_prot;	/* Find buffer */
			sl_len = 0;
			return;
		}
	}
	else {
		/*
		 * If chr = END then an entire packet has been received.
		 * Timestamp it, enqueue it and wake up the handler task.
		 */

		if(rdchr == FRAME_END) {	/* All done */
			if (sl_len == 0)	/* Ignore */
				return;
			sl_buff->nb_len = sl_len;
			sl_buff->nb_tstamp = cticks;
			q_addt(sl_net->n_inputq, (q_elt)sl_buff);
			sl_busy = FALSE;
			tk_wake(SlDemux);	/* Wake the demux task */
			slrcv++;
			if((sl_buff = getfree()) == nullbuf) {
				sl_cp = NULL;
				sl_len = 0;
				slref++;
				return;
			}
			sl_cp = sl_buff->nb_prot; /* Find buffer */
			sl_len = 0;
			return;
		}
		else if(rdchr == FRAME_ESC) {	/* Deal with the ESC char */
			escflag = TRUE;
			slresc++;
			return;
		}
	}

	if(++sl_len > LBUF - MaxLnh) {
		sldrop++;
		sl_cp = sl_buff->nb_prot;	/* Find buffer */
		sl_len = 0;
	}
	*sl_cp++ = rdchr;

	return;
}
