;      @(#)pktd.asm.u	8.1	3/15/89
;
; Copyright (c) 1989  Sun Microsystems, Inc.
;

;
;macros
status macro state,err,rc
	ifidn	<state>,<done>
	or	es:word ptr srh_sta_fld[bx],0100h
	endif
	ifidn	<state>,<busy>
	or	es:word ptr srh_sta_fld[bx],0200h
	endif
	ifidn	<err>,<error>
	or	es:word ptr srh_sta_fld[bx],8000h
	endif
	ifnb	<rc>
	or	es:word ptr srh_sta_fld[bx],rc
	endif
	endm

; parameter block offsets

srh	equ	0		;static request header start
srh_len 	equ	13	;  "      "       "    length
srh_len_fld	equ	srh	;  "      "       "      "    field
srh_ucd_fld	equ	srh+1	;  "      "       "    unit code field
srh_ccd_fld	equ	srh+2	;  "      "       "    command code field
srh_sta_fld	equ	srh+3	;  "      "       "    status field
srh_res_fld	equ	srh+5	;  "      "       "    reserved area field


;
; ioctl i/o structure
;

ioc_req struc

ioc_res 	db	13 dup (?)	; srh area
ioc_media_b	db	?
ioc_addr	dd	?
ioc_count	dw	?
ioc_sector	dw	?

ioc_req ends


; init

units		equ	srh+srh_len
units_len	equ	1
br_addr_0	equ	units+units_len
br_addr_1	equ	br_addr_0+2
br_addr_len	equ	4
bpb_ptr_off	equ	br_addr_0+br_addr_len
bpb_ptr_seg	equ	bpb_ptr_off+2


end_addr_off	equ 14
end_addr_seg	equ 16

pktd_driver	proc	far
begin:
start	equ	$

; device header
next_dev	dd	-1	; pointer to next device
attribute	dw	0c000h	; character device with ioctl
strategy	dw	dev_strategy ; ptr to dev strategy
interrupt	dw	dev_int ; ptr to dev interrupt
dev_name	db	'NFSLINK1'      ;  ethernet device driver

public ethinit_offset

ethinit_offset	dw	offset ethinit
ethinit_segment dw	0
ethsend_offset	dw	offset ethsend
ethsend_segment dw	0

rh_off		dw	?	; request header offset
rh_seg		dw	?	; request header segment

matchtable	db	'i'             ;interrupt number
		db	'm'             ;shared memory offset base (32K)

matchnum	equ	$-matchtable	;maximum number of entries

routinetable	dw	intnumchange	;change default int num
		dw	memoffchange	;change default shared memory base



; function table
funtab		label	byte
	dw	init		;initialization
	dw	media_check
	dw	build_bpb
	dw	ioctl_in
	dw	input		; read
	dw	nd_input
	dw	in_stat 	; input status
	dw	in_flush
	dw	output		; write
	dw	out_verify	; write w verify
	dw	out_stat
	dw	out_flush
	dw	ioctl_out

init_msg	db 10,13,'Sun Microsystems PC-NFS Packet Driver Interface'
		db 10,13
		db 'Version 3.0.2'
		db 10,13
		db 'Copyright (c) 1989 Sun Microsystems, Inc.'
		db 10,13
		db 'This driver may be freely copied, but not resold.'
		db 10,13
		db 'It is designed to work with drivers conforming to'
		db 10,13
		db 'Version 1.08 of the Packet Driver Specification.'
		db 10,13
		db 10,13,'$'
page

; device strategy
dev_strategy:
	mov rh_seg, es		; save segment of request header
	mov rh_off, bx		; save offset of rh
	ret


; device interrupt handler
dev_int:
; preserve machine state on entry

	cld
	push ds
	push es
	push ax
	push bx
	push cx
	push dx
	push di
	push si

; do the branch according to the function passed
	mov	es,cs:rh_seg		;get request header
	mov	bx,cs:rh_off
	mov al, es:[bx]+2		; get function byte

	shl al, 1			; get offset into table
	lea di, funtab			; get address of function table
	xor ah, ah
	add di, ax
	jmp word ptr [di]

init:
	push cs
	pop dx
	mov ethinit_segment, dx ; save segment for long pointer
	mov ethsend_segment, dx

extrn last_statement:near

	mov ax, offset last_statement
	mov cl, 4
	shr ax, cl
	add ax, dx
	inc ax
	xor dx, dx
	mov es:[bx][end_addr_off], dx
	mov es:[bx][end_addr_seg], ax
	call	parsecmdline
	status done,noerror,0		; set status word (done, noerror)
	push dx
	push ax
	mov dx, offset init_msg
	mov ah, 9
	int 21h

	pop	ax
	pop	dx
	jmp exit


; the following are not supported
output:
media_check:
build_bpb:
nd_input:
in_stat:
in_flush:
out_stat:
out_flush:
out_verify:
input:

	status done, error, 02h 	; device not ready
	jmp exit

;common exit
exit:
	pop si
	pop di
	pop dx
	pop cx
	pop bx
	pop ax
	pop es
	pop ds
	ret

parsecmdline	proc	near

;	this proc is called at init time to parse the command line
;	initially only the number of files is passed
;	on entry	es:bx point to the request header

	push	es
	push	bx			;save pointers to request header
	les	di,es:dword ptr bpb_ptr_off[bx] ;point to char after 'device =' in config.sys
	cld
getnextitem:
	mov	cx,-1		;max
	mov	al,'/'          ;look for /
s_loop:
	scasb		;look for one
	jz	foundslash
	cmp	es:byte ptr [di-1],0dh	;cr ends the line
	jz	noslash
	cmp	es:byte ptr [di-1],0ah	;line feed also ends it
	jz	noslash
	loop	s_loop
	jmp	short noslash
foundslash:
	call	getcharacter		;get next non blank character
	jnc	gotchar 		;if carry set then eol reached
	jmp	noslash
gotchar:
	cmp	al,'A'                  ;see if upper case
	jb	lower			;must be digit or trash
	cmp	al,'Z'
	ja	lower
	or	al,20h			;convert to lower
lower:
	push	es
	push	di			;save pointer
	push	cs
	pop	es			;look for match
	mov	di,offset matchtable
	mov	cx,matchnum		;get number of entries
	repne	scasb			;try to find a match
	pop	di
	pop	es			;get pointer back
	jnz	getnextitem		;nothing so try again
	sub	cx,matchnum		;find the right one
	neg	cx
	dec	cx
	mov	bx,cx
	shl	bx,1
	call	cs:routinetable[bx]	;call routine
	jnc	getnextitem
noslash:
	pop	bx			;get header ptr back
	pop	es
	ret				;return if eol

parsecmdline endp
;


getcharacter	proc	 near

;	this procedure will get a character from ES:DI and inc di
;	if the character is a terminator carry will be set
;	and the pointer will point at the terminator character
;	if the character is a non blank the character is returned
;	in al with carry clear.  Pointer will point to next character
;	Blanks and tabs are skipped

	jcxz	term
	mov	al,es:[di]		;get the character
	cmp	al,9			;tab
	je	blank
	cmp	al,' '                  ;space
	je	blank
	cmp	al,0dh			;cr
	je	term
	cmp	al,0ah			;lf
	je	term
	cmp	al,1ah			;end of file
	je	term
	inc	di			;point to next character
	dec	cx
	clc
	ret				;and return to caller
blank:
	inc	di			;point to next
	dec	cx
	jmp	getcharacter		;and get another

term:
	stc
	ret				;got a terminator

getcharacter endp

getnumber	proc	near

;	this procedure will obtain a number from the input buffer
;	pointed to by ES:DI
;	value is returned in BX

	sub	bx,bx
	mov	cx,-1			;max characters in num
gn0:
	call	getcharacter		;get a character
	jnc	gn1			;got one
	ret				;terminator reached
gn1:
	cmp	al,'/'                  ; if slash, we are done
	je	end_gn
	cmp	al,'0'                  ;must be digit
	jb	numerror
	cmp	al,'9'
	ja	numerror
	push	ax
	mov	al,10
	mul	bl			;bump up bl
	mov	bx,ax
	pop	ax
	sub	al,'0'                  ;convert to binary
	add	bl,al
	jmp	gn0			;try for more

numerror:
	ret				;return with carry set

end_gn:
	dec	di			;set di to point to '/' for main loop
	ret

getnumber endp

intnumchange	proc	near

	clc
	ret

intnumchange	endp



memoffchange	proc	near

	clc
	ret
memoffchange	 endp


gethnumber	 proc	 near

;	this procedure will obtain a number from the input buffer
;	pointed to by ES:DI
;	value is returned in BX

	sub	bx,bx
	mov	cx,-1			;max characters in num
ghn0:
	call	getcharacter		;get a character
	jnc	ghn1			;got one
	ret				;terminator reached
ghn1:
	cmp	al,'/'                  ; if slash, we are done
	je	end_ghn
	cmp	al,'0'                  ;must be digit
	jb	numbererr
	cmp	al,'9'
	jb	ok_num
	or	al,20H			; should be a character, toupper it
	cmp	al,'a'
	jb	numbererr
	cmp	al,'f'                 ; 'f' is max legal hex char
	ja	numbererr
	sub	al,57H		       ; subtract enough so 'a' becomes 0x0a
	jmp	ok_letter

ok_num:
	sub	al,'0'

ok_letter:
	shl    bx,1		       ; move a nibble
	shl    bx,1
	shl    bx,1
	shl    bx,1
	or     bl,al		       ; or in al, the new char
	jmp	ghn0			;try for more

numbererr:
	mov	bx,0			; make sure return with illegal number
	ret				;return with carry set

end_ghn:
	dec	di			;set di to point to '/' for main loop
	ret

gethnumber endp





; i/o control
;

;
; to use i/o control:
;
;	1. write an ioctl string to this device  containing
;	   one (1) byte; this byte is a function code.
;
;	2. read the ioctl string returned - it is four bytes, and
;	   is the double word pointer selected by the function code
;	   you just wrote in #1.
;


ioctl_out:

	status	done, noerror, 0
	jmp	exit


ioctl_in:
	status	done, noerror, 0
	jmp	exit




pktd_driver	endp

