;	@(#)log.inc.u	8.1	3/15/89
;
; Copyright (c) 1986 by Sun Microsystems, Inc.
; All rights reserved.
;
;
;	@(#)log.inc	1.1
;
;	The following definitions and macros are used for the 'syslog'
;	facility. It works like this:
;
;	In every driver (here, in pci and led) there must exist a module
;	which contains two variable declarations - for 'log_seg' and
;	'log_base' - and an instance of the procedure 'logger', which may
;	be created by invoking the 'logproc' macro. Other modules within
;	the driver may include invocations of the 'log' macro. The latter
;	increments a tally associated with a particular event. It may be
;	called as:
;			log	_LOG_XXX
;	where _LOG_XXX is one of the constants defined below, or as:
;			log	register
;	(e.g. 'log bx'), where the register contains the event number.
;
;	The "nfsinit" module creates the log buffer 
;	using the 'logbuffer' macro, and should propagate the values of
;	'log_seg' and 'log_base' to other drivers using the facility.
;
;	An ioctl is available in order that user-mode utilities
;	may access the log buffer for reporting purposes.
;
logbuffer	macro
log_buffer	dd	_LOG_MAX dup (0)
	endm


;
logproc 	macro
public		log_proc
log_proc	proc	near
		pushf

		push	bx		; save base register
		push	es		; used to address log buffer
		mov	bx, cs:log_seg	; for ie6: code & data now separate
		mov	es, bx
		mov	bx, ax		; stupid 808x architecture
		shl	bx,1		; scale to ...
		shl	bx,1		; ... doublewords
		add	bx, cs:log_base	; now es:ax points at the tally
		mov	ax, es:[bx]	; get low order word
		add	ax, 1		; bump it
		mov	es:[bx], ax	; store it
		mov	ax, es:[bx+2]	; now the high-order word
		adc	ax, 0		; add in any carry-out
		mov	es:[bx+2], ax	; store it
		pop	es		; restore
		pop	bx		;	and

		popf
		ret			;		exit
log_proc	endp
		endm
;
log		macro	n
	IFNDEF	log_proc
extrn log_proc : near
	ENDIF
		push	ax		; used to pass argument
	IFDIF	<n>,<ax>
		mov	ax, n		; pick up argument
	ENDIF
		call	log_proc	; log it
		pop	ax
		endm
;
;	The following are the entries currently defined. This table should
;	be updated in parallel with 'log.h', the C-language version.
;
; Remote file service routines
_LOG_NULL		equ	0
_LOG_GETATTR		equ	1
_LOG_SETATTR		equ	2
_LOG_ROOT		equ	3
_LOG_LOOKUP		equ	4
_LOG_READLINK		equ	5
_LOG_READ		equ	6
_LOG_WRITECACHE 	equ	7
_LOG_WRITE		equ	8
_LOG_CREATE		equ	9
_LOG_REMOVE		equ	10
_LOG_RENAME		equ	11
_LOG_LINK		equ	12
_LOG_SYMLINK		equ	13
_LOG_MKDIR		equ	14
_LOG_RMDIR		equ	15
_LOG_READDIR		equ	16
_LOG_STATFS		equ	17
;
; RPC events
_LOG_RPC_CALL		equ	18
_LOG_RPC_XMIT		equ	19
_LOG_RPC_REPLY		equ	20
_LOG_RPC_ACCEPTED	equ	21
_LOG_RPC_DENIED 	equ	22
_LOG_RPC_SUCCESS	equ	23
_LOG_PROG_UNAVAIL	equ	24
_LOG_PROG_MISMATCH	equ	25
_LOG_PROC_UNAVAIL	equ	26
_LOG_GARABAGE_ARGS	equ	27
_LOG_SYSTEM_ERR 	equ	28
_LOG_RPC_MISMATCH	equ	29
_LOG_AUTH_ERR		equ	30
;
; ARP events
_LOG_ARP_GOT_REQ	equ	31
_LOG_ARP_SENT_REPLY	equ	32
_LOG_ARP_SENT_REQ	equ	33
_LOG_ARP_GOT_REPLY	equ	34
_LOG_ARP_REQUESTS	equ	35
_LOG_ARP_SUCCESS	equ	36
;
; Ethernet events
_LOG_ETH_XMIT		equ	37
_LOG_ETH_RCV		equ	38
_LOG_ETH_RCV_FOR_ME	equ	39
_LOG_ETH_ARP		equ	40
_LOG_ETH_ICMP		equ	41
_LOG_ETH_UDP		equ	42
_LOG_ETH_TCP_CHKSM_ERR	equ	42
_LOG_ETH_UDP_NFS	equ	44
_LOG_ETH_TCP		equ	45
_LOG_ETH_MISC		equ	46
_LOG_ETH_DROPPED	equ	47
_LOG_ETH_XMIT_ERR	equ	48
_LOG_ETH_RCV_ERR	equ	49
_LOG_ETH_COLLISIONS	equ	50
_LOG_ETH_IP_CHKSM_ERR	equ	51
; Buffer cache events
_LOG_BCACHE_HITS	equ	52
_LOG_BCACHE_MISSES	equ	53
_LOG_BCACHE_WR_INVAL	equ	54
_LOG_BCACHE_STEALS	equ	55
; Name mapping events
_LOG_NAME_MAPS		equ	56
_LOG_NAME_BACKMAPS	equ	57
_LOG_NAME_STALE 	equ	58
; ICMP stuff
_LOG_ICMP_NETUNREACH	equ	59
_LOG_ICMP_SPARE1	equ	60
; IP fragment stuff
_LOG_IP_FRAG_DISCARD	equ	61
_LOG_IP_FRAG_REASS_OK	equ	62
_LOG_IP_FRAG_REASS_TRY	equ	63
_LOG_IP_DUPFRAG		equ	64
_LOG_IP_FRAGS		equ	65
;
_LOG_ETH_INT		equ	66
_LOG_ETH_SINT		equ	67
_LOG_ETH_RINT		equ	68
_LOG_ETH_SPUR		equ	69
_LOG_ETH_XMIT_TMOUT	equ	70
;
_LOG_SHARE_REQUEST	equ	71
_LOG_SHARE_DENIED	equ	72
_LOG_SHARE_ERROR	equ	73
_LOG_UNSHARE_REQUEST	equ	74
_LOG_UNSHARE_ERROR	equ	75
;
_LOG_LOCK_REQUEST	equ	76
_LOG_LOCK_FAILED	equ	77
_LOG_LOCK_ERROR		equ	78
_LOG_UNLOCK_REQUEST	equ	79
_LOG_UNLOCK_ERROR	equ	80

; This should always be updated correctly::::
_LOG_MAX	equ	81
;============================================================================



