/*
 
 *  netd.c -- 
 
 *      Net daemon for PC NFS file server.  It sets up and
 
 *      arbitrates the port mapper daemon, mount daemon and
 
 *      the NFS server.
 
 *
 
 *  Author:
 
 *      See-Mong Tan, 6/11/88
 
 */
 

 
#include "common.h"
 

 
bool_t NFS_VERBOSE = FALSE;	/* flag for nfs verbose mode */
 
bool_t NFS_READONLYFS = FALSE;	/* true if started as a read only filesystem */
 

 
main(argc, argv)
 
	int argc;
 
	char *argv[];
 
{
 
	netd_init(argc, argv);		/* initialize netd */
 

 
	(void) printf("Starting net services...\n\n");
 

 
	/* initialize and register services */
 
	if (! pmap_init())
 
		netd_Punt("cannot create portmapper");
 
	(void) printf("netd: port mapper created\n");
 

 
	if (! mountd_init())
 
		netd_Punt("cannot create mount daemon");
 
	(void) printf("netd: mount daemon created\n");
 

 
	if (! nfs_init())
 
		netd_Punt("cannot create nfs server");
 
	(void) printf("netd: nfs server created\n");
 

 
	if (! inode_init())
 
		netd_Punt("cannot initialize inode interface");
 

 
	if (! dtime_init())
 
		netd_Punt("cannot initialize dos time interface\n");
 

 
	(void) printf("netd: port mapper, mountd and nfs server running\n\n");
 
	(void) svc_run();       /* wait for and service net requests */
 
	netd_Punt("net daemon returned unexpectedly\n");
 
}
 

 
/*
 
 *  void netd_Punt(char *s) --
 
 *      Prints net daemon error message and exits.
 
 *      For irrecoverable errors.
 
 */
 
void netd_Punt(s)
 
	char *s;
 
{
 
	int i;
 

 
	(void) fprintf(stderr, "net daemon error: %s\n", s);
 
	for(i = 0; i < 16; i++)
 
		sock_close(i);
 
	exit(1);
 
}
 

 

 
/*
 
 *  void netd_init(int argc, char **argv) --
 
 *      Initializes the net daemon.  Should be called before any other
 
 *      routine in the server.
 
 */
 
void netd_init(argc, argv)
 
	int argc;
 
	char *argv[];
 
{
 

 

 
	netd_parsecmdln(argc, argv);	/* parse command line */
 
	signal(SIGINT, netd_break);	/* break handler */
 
}
 

 
/*
 
 *  void netd_break() --
 
 *      Break handler.  Closes all sockets and exits.
 
 */
 
void netd_break()
 
{
 
	int i;
 

 
	(void) fprintf(stderr, "Netd:  break caught... exiting\n");
 
	for(i = 0; i < 3; i++)
 
		sock_close(i);
 

 
	exit(1);
 
}
 

 
/*
 
 *  void netd_parsecmdln(int argc, char **argv) --
 
 *      Parse command line arguments.
 
 */
 
void netd_parsecmdln(argc, argv)
 
	int argc;
 
	char *argv[];
 
{
 
	if (argc == 1)		/* no options */
 
		return;
 

 
	if (argc > 3)
 
		netd_Punt("Usage: sos [-v] [-r]");
 

 
	for(; argc > 1; argc--) {
 
		if (strcmp("-v", argv[argc - 1]) == 0)
 
			NFS_VERBOSE = TRUE;	
 
		else if (strcmp("-r", argv[argc - 1]) == 0)
 
			NFS_READONLYFS = TRUE;
 
		else
 
			netd_Punt("Usage: sos [-v] [-r]");
 
	}
 
}		
 
