/*
 *
 *    Experimental POP2 Server for 4.2BSD Unix
 *
 *          Written at USC-ISI  
 *
 *    Version: 16 July 1986
 *
 *    Invocation:
 *       popd [-x]
 *          -x: turns on debugging output
 */

#ifndef lint
static char sccsid[] = "%W% (Ames) %G%";
#endif

#include "popd.h"
#include "def.h"
#include <ctype.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/file.h>

#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>

#include <arpa/inet.h>

#ifndef TIMEOUT
#define TIMEOUT 3600
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

int helo(), fold(), read_msg(), retr(), acks(), ackd(), nack(), quit();
int name(), head(), echo(), dofrom(), smtp(), dele(), pass(), undel();
int noop(), updt();

int onalrm(), onpipe();

struct cmdent {
	char	*cmd_name;
	int	(*cmd_fctn)();
} key, cmdtbl[] = {
	{ "helo", helo } ,
	{ "fold", fold } ,
	{ "read", read_msg } ,
	{ "retr", retr } ,
	{ "acks", acks } ,
	{ "ackd", ackd } ,
	{ "nack", nack } ,
	{ "name", name } ,
	{ "head", head } ,
	{ "unix", dofrom },
	{ "smtp", smtp } ,
	{ "noop", noop } ,
	{ "echo", echo } ,	/* For debugging */
	{ "dele", dele },
	{ "undel", undel },
	{ "pass", pass },
	{ "updt", updt },
	{ "quit", quit }
};
#define NUMCMDS	(sizeof cmdtbl / sizeof (struct cmdent))

#define MAX_OUTPUT 450

int cur_msg, msg_cnt, cur_msg_len;
struct msg_desc *cur_msg_ptr = NULL;

int debug = 0 ;
int keepalive = 0;		/* set if SO_KEEPALIVE set */

extern int errno;
extern char *sys_errlist[];

char myname[MAXHOSTNAMELEN+1];
char *hisname;

/* where it all begins... */
main (argc, argv)
int argc ;
char ** argv ;
{
		/* Process arguments */	
	while (--argc > 0 && **++argv == '-') 
		switch (*(1+*argv)) {
		
		case 'x':	/* -x   (turn on debug output) */
			debug = 1 ;
			break ;
			
		default:
			fprintf(stderr, "popd: Unknown parm: %s\n", *argv) ;
			exit(1) ;
		} ;
		

#ifdef LOG_DAEMON
	openlog("popd", LOG_ODELAY, LOG_DAEMON);
#else
	openlog("popd", 0);
#endif
	if (gethostname(myname, sizeof myname - 1) < 0) {
		syslog(LOG_ERR, "gethostname: %m");
		exit(1);
	}

	do_pop();
}

/* here to do all the real protocol work... */
/* assumes that socket is already open and we're about to prompt */
do_pop ()
{
	int clnlen = sizeof (struct sockaddr_in) ;
	char line[BUFSIZ];
	register char *cp;
	struct cmdent *cmd;
	struct	sockaddr_in client_name ;
	int myargc;
	static char **myargv;
	char 	*stdoutbuf;

		/* Set up a buffer for output -- trying to limit
		 * how much stuff we through at the K-box until
		 * we can fix KIP.  -PEY
		 */

		 stdoutbuf = (char *)malloc(MAX_OUTPUT + 3);
		 setbuffer(stdout, stdoutbuf, MAX_OUTPUT + 3);
	
		/* Set up I/O stream for input side of net conn, and
		 * look up remote host number.
		 */
	if (getpeername(0, &client_name, &clnlen) < 0)
		hisname = NULL;
	else {
		hisname = inet_ntoa(client_name.sin_addr);
		if (keepalive) {
			int on = 1;

			if (setsockopt(0, SOL_SOCKET, SO_KEEPALIVE,
			    (char *)&on, sizeof (on)) < 0) {
				syslog(LOG_ERR, "SO_KEEPALIVE: %m");
				keepalive = 0;
			}
		}
	}
	
	/* Set up initial files. */
	tinit();
	/* provide initial prompt */
	printf("+ POP2 Unix Server on %s ready\r\n", myname);
	signal(SIGALRM, onalrm);
	signal(SIGPIPE, onpipe);
    
	for(;;) {
		fflush(stdout);
		if (!keepalive)
			alarm(TIMEOUT);
		if (fgets(line, sizeof line, stdin) == NULL) {
			/* EOF.  It was unexpected... */
			if (hisname) {
				printf("- %s lost input channel to %s\r\n",
				    myname, hisname);
				syslog(LOG_INFO, "lost input channel to %s",
				    hisname);
			} else
				printf("- %s lost input channel\r\n", myname);
			cleanup(0);
		}
		if (!keepalive)
			alarm(0);
		if (cp = index(line, '\r'))
			*cp = '\0';
		else if (cp = index(line, '\n'))
			*cp = '\0';

		myargc = parsit(line, &myargv);
		if (myargc == 0)	/* blank line */
			continue;

		cp = myargv[0];
		while (*cp) {
			if (isupper(*cp))
				*cp = tolower(*cp);
			cp++;
		}

		for(cmd = cmdtbl; cmd < &cmdtbl[NUMCMDS]; cmd++) {
			if (strcmp(myargv[0], cmd->cmd_name) == 0)
				break;
		}
		if (cmd >= &cmdtbl[NUMCMDS]) {
			printf("- Command unrecognized.\r\n");
			continue;
		}

		(*(cmd->cmd_fctn))(myargc, myargv);

		if (quit == cmd->cmd_fctn) {
			printf("+ Ok, %s closing connection.\r\n", myname);
			cleanup(0);
		}
	}
}

echo(argc, argv)
char **argv;
{
	while (argc--) {
		fputs(*argv++, stdout);
		putchar(':');
	}
	fputs("\r\n", stdout);
}

/*ARGSUSED*/
noop(argc, argv)
char **argv;
{
	fputs("+ Ok\r\n", stdout);
}

smtp(argc, argv)
char **argv;
{
	int pid, wpid;

	pid = vfork();
	if (pid < 0) {
		printf("- %s\r\n", sys_errlist[errno]);
		return (-1);
	}
	if (pid == 0) {
		execl("/usr/lib/sendmail", "sendmail", "-bs", 0);
		printf("- /usr/lib/sendmail: %s\r\n", sys_errlist[errno]);
		fflush(stdout);
		_exit(1);
	}
	while ((wpid = wait(0)) != pid)
		if (wpid < 0) {
			printf("- %s\r\n", sys_errlist[errno]);
			return (-1);
		}
	return 0;
}

onalrm()
{
	if (hisname) {
		printf("- %s timeout on connection to %s\r\n", myname, hisname);
		syslog(LOG_INFO, "timeout on connection to %s", hisname);
	} else
		printf("- %s timeout\r\n", myname);
	cleanup(0);
}

onpipe()
{
	cleanup(0);
}
