/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "%W% (Ames) %G%";
#endif not lint

#include "popd.h"
#include "rcv.h"
#ifdef VMUNIX
#include <sys/wait.h>
#endif
#include <ctype.h>
#include <sys/stat.h>

#define MAX_OUTPUT	10

/*
 * Print the message.
 */

retr(argc, argv)
char **argv;
{
	int ch;
	int output = 0;
	long c;
	FILE *ibuf;

	if (argc > 1) {
		printf("- invalid arguments\r\n");
		return (-1);
	}
	if (!logged_on) {
		printf("- Logon with HELO first.\r\n");
		return (-1);
	}
	if (state == WAIT_FOR_ACK) {
		printf("- expecting ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (dot == NULL) {
		printf("- Panic:  There are no messages.\r\n");
		return (-1);
	}

	switch (state) {
	    case RETR_BODY:
		c = dot->m_size;
		state = WAIT_FOR_ACK;
		break;
	    case RETR_HEAD:
		c = dot->m_hsize;
		state = 0;
		break;
	    default:
		printf("- not ready to RETR a message\r\n");
		return (-1);
	}

	ibuf = setinput(dot);
	if (unixfrom == 0) {		/* Don't send unix From line. */
		ch = dot->m_fromsize;
		c -= ch;
		while (ch-- > 0L)
			(void)getc(ibuf);
	}
	while (c-- > 0L) {
		ch = getc(ibuf);
		if (ch == EOF) {
			/* HELP! */
			syslog(LOG_ERR, "Got EOF in retr()");
			ch = '.';
		}
		if (ch == '\n') {
			putchar('\r');
			output++;
		}
		putchar(ch);
		output++;
		if (output > MAX_OUTPUT) {
			fflush(stdout);
			output = 0;
		}
	}
	return(0);
}
