/* --------------------------------- gr.h ----------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Vga graphics low level routines.
*/

#ifndef FLY8_FAST_GR
#define FLY8_FAST_GR

#define GrOR		0x200
#define VGA_PAGE	((char *)0xd0000000)

#define GR_TYPES	0x000f
#define GR_TYPE_T4K	0x0000
#define GR_TYPE_S3	0x0001

/* line.c */
extern int	_GrWriteMode;
extern char	*_ActiveBase;
extern void FAR MoveTo (int x1, int y1);
extern void FAR	DrawTo (int x2, int y2, Uint c);
extern void FAR SetWriteMode (int mode);
extern void FAR InitGr (int mode, int sizex, int sizey);
extern void FAR SetActiveBase (Ulong b);
extern void FAR SetVisualBase (Ulong b);
extern void FAR GrClear (int x, int y, int sizex, int sizey, Uint color);

/* ellipse.c */
extern void FAR GrEllipse (int xc, int yc, int a, int b, Uint c);

/* subs.x */
extern void FAR vgaset (char *va, int color, int length);
extern char * FAR ILoop (char *va, int dy, int dx, int dvx, int dvy, int color);
extern char * FAR SLoop (char *va, int count, int dva, int color);

#endif
