/* --------------------------------- grqc.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Vga graphics driver (uses quickC graphics library).
*/

#include "fly.h"
#include "colors.h"

#include <conio.h>

#ifdef C7GRAPH
#include <c7graph.h>
#else
#include <graph.h>
#endif

#define DOSYNC		0x0001

static struct videoconfig	vc[1] = {0};
static struct _fontinfo		vf[1] = {0};
static struct rccoord		stack[10] = {0}, *pstack = stack;
static Uint			LastColor = (Uint)-1;

static void FAR
GrPushTextPos (void)
{
	if (pstack < stack+sizeof(stack))
		*pstack++ = _gettextposition ();
}

static void FAR
GrPopTextPos (void)
{
	if (pstack > stack) {
		--pstack;
		_settextposition ((*pstack).row, (*pstack).col);
	}
}

static void FAR
GrSetVisual (int page)
{
	int	port;

	if (2 == CS->device->colors)
		port = 0x3ba;		/* monochrome */
	else
		port = 0x3da;		/* colour */

	if (CS->device->flags & DOSYNC) {
		while (inp (port) & 0x01)	/* wait for Display Enabled */
			sys_poll ();
	}
	_setvisualpage(page);
	if (CS->device->flags & DOSYNC) {
		while (inp (port) & 0x08)	/* wait for Vert Sync start */
			sys_poll ();
		while (!(inp (port) & 0x08))	/* wait for Vert Sync end */
			sys_poll ();
	}
}

static void FAR
GrSetActive (int page)
{
	_setactivepage(page);
}

static int FAR
GrCursorMode (int mode)
{return (0);}

static void FAR
GrDrawTo (int x, int y, Uint color)
{
	if (color != LastColor) {
		_setcolor (color);
		LastColor = color;
	}
	_lineto (x, y);
}

static void FAR
GrTextColor (Uint fg, Uint bg)
{
	_settextcolor (fg);
	_setbkcolor (bg);
}

static void FAR
GrFontSet (DEVICE *dev, char *fname)
{
#if 0
	_getfontinfo(vf);
	dev->FontWidth  = vf->pixwidth;
	dev->FontHeight = vf->pixheight;
#else
	dev->FontWidth  = vc->numxpixels / vc->numtextcols;
	dev->FontHeight = vc->numypixels / vc->numtextrows;
#endif
}

static void FAR
GrTextChar (int c)
{
	char	buf[2];
	struct rccoord	pos;

	buf[0] = (char)c;
	buf[1] = '\0';
	if (st.flags1 & SF_DBUFFERING) {
		pos = _gettextposition ();
		GrSetActive (st.which_buffer);
		_outtext (buf);
		_settextposition (pos.row, pos.col);
		GrSetActive (1-st.which_buffer);
	}
	_outtext (buf);
}

static void FAR
GrTextPut (int c)
{
	if (c == '\f')
		_settextposition (1 ,1);
	else
		GrTextChar (c);
}

static void FAR
GrSetTextPos (int row, int col)
{
	_settextposition (row, col);
}

static void FAR
GrTextClear (void)
{
	if (st.flags1 & SF_DBUFFERING) {
		GrSetActive (st.which_buffer);
		_clearscreen (_GWINDOW);
		GrSetActive (1-st.which_buffer);
	}
	_clearscreen (_GWINDOW);
}

static void FAR
GrWriteMode (int mode)
{
	switch (mode) {
	case T_MSET:
		_setwritemode (_GPSET);
		break;
	case T_MOR:
		_setwritemode (_GOR);
		break;
	case T_MXOR:
		_setwritemode (_GXOR);
		break;
	}
}

static void FAR
GrSetPalette (int index, long color)
{
	int	r, g, b;
	long	c;

	r = ((int)(color      )) & 0x0ff;
	g = ((int)(color >>  8)) & 0x0ff;
	b = ((int)(color >> 16)) & 0x0ff;
	c = (((0x03fL&(b>>2))<<16) + ((0x03fL&(g>>2))<<8) + (0x03fL&(r>>2)));

	_remappalette (index, c);
}
		
static int FAR
GrInit (DEVICE *dev, char *options)
{
	if (_setvideomode (dev->mode) == 0)
		return (1);

	_getvideoconfig (vc);
	if (vc->numxpixels == 0)
		return (1);
	dev->npages = vc->numvideopages;
	st.black   = 0;
	st.white   = 1;
	st.red     = 2;	/* do not change! */
	st.blue    = 4;	/* do not change! */
	st.magenta = 6;	/* do not change! */
	st.green   = 3;
	st.brown   = 5;
	st.gray    = 7;
	st.hudlow  = 8;
	st.hudhigh = 9;
	st.skyblue = 10;
	st.lred    = 11;
	st.lgray   = 12;
	st.ground  = 13;
	st.lblue   = 14;
/*	st.white   = 15;	keep 15 for OR'ed white */

	GrSetPalette (st.black,   C_BLACK);
	GrSetPalette (st.white,   C_WHITE);
	GrSetPalette (st.red,     C_RED);
	GrSetPalette (st.blue,    C_BLUE);
	GrSetPalette (st.magenta, C_MAGENTA);
	GrSetPalette (st.green,   C_GREEN);
	GrSetPalette (st.brown,   C_BROWN);
	GrSetPalette (st.gray,    C_GRAY);
	GrSetPalette (st.hudlow,  C_LYELLOW);
	GrSetPalette (st.hudhigh, C_YELLOW);
	GrSetPalette (st.lred,    C_LIGHTRED);
	GrSetPalette (st.skyblue, C_SKYBLUE);
	GrSetPalette (st.lgray,   C_LIGHTGRAY);
	GrSetPalette (st.ground,  C_GRAY);
	GrSetPalette (st.lblue,   C_LIGHTBLUE);

#if 0
	_getfontinfo(vf);
	dev->FontWidth  = vf->pixwidth;
	dev->FontHeight = vf->pixheight;
#else
	dev->FontWidth  = vc->numxpixels / vc->numtextcols;
	dev->FontHeight = vc->numypixels / vc->numtextrows;
#endif
	return (0);
}

static void FAR
GrTerm (DEVICE *dev)
{
	_setvideomode (_DEFAULTMODE);
}

static void FAR
GrOpenTextWindow (SCREEN *scr)
{
	_settextwindow (1+scr->miny/scr->FontHeight,
			1+scr->minx/scr->FontWidth,
			1+(scr->miny+scr->sizey)/scr->FontHeight,
			1+(scr->minx+scr->sizex)/scr->FontWidth);
	GrTextColor (scr->FgColor, scr->BgColor);
	_wrapon (_GWRAPON);
	_settextposition (1 ,1);
}

static void FAR
GrCloseTextWindow (SCREEN *scr)
{}

static void FAR
GrEllipse (int x1, int y1, int rx, int ry, Uint color)
{
	if (color != LastColor) {
		_setcolor (color);
		LastColor = color;
	}
	_ellipse (_GBORDER, x1-rx, y1+ry, x1+rx, y1-ry);
}

static void FAR
GrFlush (void)
{}

#if 0
static void FAR
GrClear (SCREEN *scr)
{
	/* set bg color = scr->BgColor */
	_clearscreen (_GCLEARSCREEN);
}
#endif

static void FAR
GrShutters (int eye)
{
	if (st.misc[7]) {
		if (eye >= 0)
			outp (st.misc[7]+4, 1+2*eye);
		else if (-1 == eye)
			outp (st.misc[7]+4, 1);		/* on */
		else if (-2 == eye)
			outp (st.misc[7]+4, 0);		/* off */
	}
}

struct GrDriver NEAR GrQc = {
	"GrQC",
	0,
	0,
	GrInit,
	GrTerm,
	GrOpenTextWindow,
	GrCloseTextWindow,
	GrFontSet,
	GrTextPut,
	GrTextChar,
	GrTextColor,
	GrCursorMode,
	_moveto,
	GrDrawTo,
	GrSetVisual,
	GrSetActive,
	0,	/* GrClear() too slow */
	GrSetTextPos,
	GrPushTextPos,
	GrPopTextPos,
	GrTextClear,
	GrWriteMode,
	GrSetPalette,
	GrEllipse,
	GrFlush,
	GrShutters
};
#undef DOSYNC
