/* --------------------------------- console.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Console keyboard handler: Microsoft WINDOWS
 * Windows support by Michael Taylor miket@canb.auug.org.au
*/

#include <windows.h>

#include "fly.h"


extern HWND	ghWndMain, ghWndText;
extern RECT	rect;
extern HDC	hdc, texthdc, memhdc;
extern HBITMAP	mybm1, mybm2, oldbm;
extern HPALETTE	hpal;
static MSG	msg;
static int	key = -1;
static int	pressed = 0;
static int	win_x = 0, win_y = 0, button1 = 0, button2 = 0;
static int 	shift=0, ctrl=0, alt=0;

static int FAR
kread (void)
{
        int key = -1;

        if (PeekMessage (&msg, ghWndMain, 0, 0, PM_REMOVE)) {
		if (msg.message == WM_QUIT)
        		key = -1;
    		switch (msg.message) {
	      		case WM_KEYUP:
        	       		switch (msg.wParam) {
                	        case VK_CONTROL:
                        		ctrl = 0;
                        		break;
                                case VK_SHIFT:
                        	        shift = 0;
                        	        break;
                                case VK_MENU:
                        	        alt = 0;
                        	        break;
			        default: 
			        /* if not a key we need let system handle it */
				        TranslateMessage ( (LPMSG)&msg );
			        	DispatchMessage ( (LPMSG)&msg );
                		        break;
                        	}
                        	break;
	      		case WM_KEYDOWN:
	      			/* catch special keys eg F1 - F12 */
        	       	switch (msg.wParam) {
                	        case VK_CONTROL:
                        		ctrl = K_CTRL;
                        		break;
                                case VK_SHIFT:
                        	        shift = 32;
                        	        break;
                                case VK_MENU:
                        	        alt = K_ALT;
                        	        break;
                                case VK_ESCAPE:
                        	        key = K_ESC;
		              	        pressed = 1;
                        	        break;
                                case VK_SPACE:
                        	        key = ' ';
		              	        pressed = 1;
                        	        break;
                                case 'A':
                                case 'B':
                                case 'C':
                                case 'D':
                                case 'E':
                                case 'F':
                                case 'G':
                                case 'H':
                                case 'I':
                                case 'J':
                                case 'K':
                                case 'L':
                                case 'M':
                                case 'N':
                                case 'O':
                                case 'P':
                                case 'Q':
                                case 'R':
                                case 'S':
                                case 'T':
                                case 'U':
                                case 'V':
                                case 'W':
                                case 'X':
                                case 'Y':
                                case 'Z':
                        	        key = (msg.wParam - shift + 32);
		              	        pressed = 1;
                        	        break;
                                case '0':
                                case '1':
                                case '2':
                                case '3':
                                case '4':
                                case '5':
                                case '6':
                                case '7':
                                case '8':
                                case '9':
                        	        key = msg.wParam;
		              	        pressed = 1;
                        	        break;
                                case VK_NUMPAD0:
                                case VK_NUMPAD1:
                                case VK_NUMPAD2:
                                case VK_NUMPAD3:
                                case VK_NUMPAD4:
        /*                      case VK_NUMPAD5:*/
                                case VK_NUMPAD6:
                                case VK_NUMPAD7:
                                case VK_NUMPAD8:
                                case VK_NUMPAD9:
                        	        key = '0' + msg.wParam - VK_NUMPAD0;
		              	        pressed = 1;
                        	        break;
                                case VK_NUMPAD5:
                        	        key = K_CENTER;
		              	        pressed = 1;
                        	        break;
                                case VK_DELETE:
                        	        key = K_DEL;
                        	        pressed = 1;
                        	        break;
                                case VK_BACK:
                        	        key = K_RUBOUT;
                        	        pressed = 1;
                        	        break;
                                case VK_TAB:
                        	        key = K_TAB;
                        	        pressed = 1;
                        	        break;
                                case VK_RETURN:
                        	        key = K_ENTER;
                        	        pressed = 1;
                        	        break;
                                case VK_DECIMAL:
                        	        key = '.';
                        	        pressed = 1;
                        	        break;
                                case VK_ADD:
                        	        key = '+';
                        	        pressed = 1;
                        	        break;
                                case VK_SUBTRACT:
                        	        key = '-';
                        	        pressed = 1;
                        	        break;
                                case VK_DIVIDE:
                        	        key = '/';
                        	        pressed = 1;
                        	        break;
                                case VK_SEPARATOR:
                        	        key = '\\';
                        	        pressed = 1;
                        	        break;
                                case VK_MULTIPLY:
                        	        key = '*';
                        	        pressed = 1;
                        	        break;
                                case VK_F1:
                        	        key = K_F1;
		              	        pressed = 1;
                        	        break;
                                case VK_F2:
                        	        key = K_F2;
		              	        pressed = 1;
                        	        break;
                                case VK_F3:
                        	        key = K_F3;
		              	        pressed = 1;
                        	        break;
                                case VK_F4:
                        	        key = K_F4;
		              	        pressed = 1;
                        	        break;
                                case VK_F5:
                        	        key = K_F5;
		              	        pressed = 1;
                        	        break;
                                case VK_F6:
                        	        key = K_F6;
		              	        pressed = 1;
                        	        break;
                                case VK_F7:
                        	        key = K_F7;
		              	        pressed = 1;
                        	        break;
                                case VK_F8:
                        	        key = K_F8;
		              	        pressed = 1;
                        	        break;
                                case VK_F9:
                        	        key = K_F9;
		              	        pressed = 1;
                        	        break;
                                case VK_F10:
                        	        key = K_F10;
		              	        pressed = 1;
                        	        break;
                                case VK_F11:
                        	        key = K_F11;
		              	        pressed = 1;
                        	        break;
                                case VK_F12:
                        	        key = K_F12;
		              	        pressed = 1;
                        	        break;
                                case VK_UP:
                        	        key = K_UP;
		              	        pressed = 1;
                        	        break;
                                case VK_DOWN:
                        	        key = K_DOWN;
		              	        pressed = 1;
                        	        break;
                                case VK_LEFT:
                        	        key = K_LEFT;
		              	        pressed = 1;
                        	        break;
                                case VK_RIGHT:
                        	        key = K_RIGHT;
		              	        pressed = 1;
                        	        break;
                                case VK_END:
                        	        key = K_END;
		              	        pressed = 1;
                        	        break;
                                case VK_HOME:
                        	        key = K_HOME;
		              	        pressed = 1;
                        	        break;
                                case VK_INSERT:
                        	        key = K_INS;
		              	        pressed = 1;
                        	        break;
		      	        case VK_LBUTTON:
                		        button1 = 1;
         			        break;
      			        case VK_RBUTTON:
                		        button2 = 1;
         			        break;
			        default:	
			        /* if not a key we need let system handle it */
				        TranslateMessage ( (LPMSG)&msg );
			        	DispatchMessage ( (LPMSG)&msg );
                		        break;
                        }
    		        default:	
    		        	/* other messages Dispatch */
			        TranslateMessage ( (LPMSG)&msg );
		        	DispatchMessage ( (LPMSG)&msg );
               		        break;
                }
        }
        
        /* remove messages for the Text window */
	if (PeekMessage (&msg, ghWndText,   0, 0, PM_REMOVE)) {
	        TranslateMessage ( (LPMSG)&msg );
        	DispatchMessage ( (LPMSG)&msg );
        }
	        
        if (pressed) {
		if (alt || ctrl)
		        key |= K_CTRL | K_ALT;
	        pressed = 0;
        }
        
	return (key);

}

static int FAR
kwait (void)
{
	MSG msg;
	int esc, c = 0;

   	/* Polling messages from event queue */
   	GetMessage((LPMSG)&msg, ghWndMain, 0, 0);
      	TranslateMessage ((LPMSG)&msg);
      	DispatchMessage ((LPMSG)&msg);
      	
	for (esc = 0; -1 != c; c = kread ())
		if (K_ESC == c)
			esc = 1;
	return (esc);
}

static int FAR
kgetch (void)
{
	int	c;

	while ((c = kread ()) == -1)
		sys_poll ();
	return (c);
}

static int FAR
kinit (char *options)
{options = options; return (0);}

static void FAR
kterm (void)
{}

struct KbdDriver NEAR KbdConsole = {
	"CONSOLE",
	0,
	kinit,
	kterm,
	kread,
	kgetch,
	kwait
};

extern int FAR
GetMouse (int *x, int *y, char *btn, int *nbtn)
{
	*x = win_x;
	*y = win_y;
	btn[0] = (char)button1;			/* right button */
	btn[1] = (char)button2;			/* left button */
	*nbtn = 2;
	return (0);
}

/* procedure called by WINDOWS when an event occurs in the fly8 display window
*/
long FAR PASCAL
Fly8WndProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
    	PAINTSTRUCT ps;
    	POINT pt;

    	switch (message) {
       
       	case WM_DESTROY:		/* quit the Fly8 application */
		PostQuitMessage ( 0 );
		die ();
		break;

       	case WM_PAINT:			/* paint the window */
		BeginPaint ( hWnd, (LPPAINTSTRUCT)&ps );
		GetClientRect (hWnd, &rect);
		EndPaint ( hWnd, (LPPAINTSTRUCT)&ps );
		break;

       	case WM_SETFOCUS:		/* just got the input focus */
		SelectPalette (hdc, hpal, FALSE);
		RealizePalette (hdc);	/* remap colours as we lost the focus */
		break;

       	case WM_SIZE:			/* resize the window */
		GetClientRect (hWnd, &rect);
  		CS->sizex = rect.right;
  		CS->sizey = rect.bottom;
  		set_screen (rect.right, rect.bottom);
		if (oldbm) {		/* resize the bitmap as well */
			SelectObject (memhdc, oldbm);
			DeleteObject (mybm1);
			DeleteObject (mybm2);
			mybm1 = CreateCompatibleBitmap (hdc, CS->sizex, CS->sizey);
			mybm2 = CreateCompatibleBitmap (hdc, CS->sizex, CS->sizey);
			oldbm = SelectObject (memhdc, mybm1);
			FillRect (memhdc, &rect, GetStockObject (BLACK_BRUSH));
			SelectObject (memhdc, mybm2);
			FillRect (memhdc, &rect, GetStockObject (BLACK_BRUSH));
		}
		break;

      	case WM_MOUSEMOVE:
      		button1 = MK_LBUTTON & wParam;
      		button2 = MK_RBUTTON & wParam;
      		pt.x = LOWORD(lParam);
      		pt.y = HIWORD(lParam);
      		ScreenToClient (hWnd, &pt); 
		win_x = pt.x;
		win_y = pt.y;	
		break;

      	case WM_LBUTTONDOWN:
		button1 = 1;
		break;

      	case WM_RBUTTONDOWN:
		button2 = 1;
		break;
#if 0
      	case WM_LBUTTONUP:
/*		wsprintf(ButtonText, "WM_LBUTTONUP: %x, %d, %d",
			wParam, LOWORD(lParam), HIWORD(lParam));*/
		break;

      	case WM_LBUTTONDBLCLK:
/*		wsprintf(ButtonText, "WM_LBUTTONDBLCLK: %x, %d, %d",
			wParam, LOWORD(lParam), HIWORD(lParam));*/
		break;

      	case WM_KEYDOWN:
/*		wsprintf(KeyboardText, "WM_KEYDOWN: %x, %x, %x",
	      		wParam, LOWORD(lParam), HIWORD(lParam));*/
		break;

      	case WM_KEYUP:
/*		wsprintf(KeyboardText, "WM_KEYUP: %x, %x, %x",
	      		wParam, LOWORD(lParam), HIWORD(lParam));*/
		break;
#endif
	case WM_CHAR:		/* all normal alphanumeric keys */
	      	key = wParam;
	      	pressed = 1;
	      	break;
	      	
#if	0
      	case WM_KEYDOWN:	/* catch special keys eg F1 - F12 */
	       	switch (wParam) {
		case VK_F1:
			key = K_F1;
		      	pressed = 1;
			break;
		case VK_F2:
			key = K_F2;
		      	pressed = 1;
			break;
		case VK_F3:
			key = K_F3;
		      	pressed = 1;
			break;
		case VK_F4:
			key = K_F4;
		      	pressed = 1;
			break;
		case VK_F5:
			key = K_F5;
		      	pressed = 1;
			break;
		case VK_F6:
			key = K_F6;
		      	pressed = 1;
			break;
		case VK_F7:
			key = K_F7;
		      	pressed = 1;
			break;
		case VK_F8:
			key = K_F8;
		      	pressed = 1;
			break;
		case VK_F9:
			key = K_F9;
		      	pressed = 1;
			break;
		case VK_F10:
			key = K_F10;
		      	pressed = 1;
			break;
		case VK_F11:
			key = K_F11;
		      	pressed = 1;
			break;
		case VK_F12:
			key = K_F12;
		      	pressed = 1;
			break;
		case VK_UP:
			key = K_UP;
		      	pressed = 1;
			break;
		case VK_DOWN:
			key = K_DOWN;
		      	pressed = 1;
			break;
		case VK_LEFT:
			key = K_LEFT;
		      	pressed = 1;
			break;
		case VK_RIGHT:
			key = K_RIGHT;
		      	pressed = 1;
			break;
		case VK_END:
			key = K_END;
		      	pressed = 1;
			break;
		case VK_HOME:
			key = K_HOME;
		      	pressed = 1;
			break;
		case VK_INSERT:
			key = K_INS;
		      	pressed = 1;
			break;
		case VK_NUMPAD5:
			key = K_CENTER;
		      	pressed = 1;
			break;
		default:	/* if not a special key do not keep it */
			break;
		}
		break;
#endif

       	default:
		return DefWindowProc( hWnd, message, wParam, lParam );
		break;
       	}

    	return(0L);
}
