/* -------------------------------- oground.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Object description: ground.
*/

#include "fly.h"


/* This object is a simple x-y reference grid that follows the plane.
*/

#define GUNIT	4000
#define HORIZON	(0x07fffL*VONE)

static SHAPE shape_ground = {
	0,
	0,
	0,
	1L,		/* weight */
	0		/* drag */
};

static int FAR
init_ground (BODY *b)
{
	int	i, last, g, h;
	VERTEX	*p, *vx_ground;

	i = (int)(HORIZON/VONE/GUNIT);
	last = 2*i+1;

	if (!(vx_ground = (VERTEX *)xcalloc (sizeof (VERTEX), 4*last+1)))
		return (1);

	shape_ground.v = vx_ground;

	h = GUNIT*i;
	for (g = -h, p = vx_ground, i = 0; i < last; ++i, g += GUNIT) {
		p->V[X] = g;	p->V[Y] = -h;	p->V[Z] = 0;
		p->flags = V_MOVE;	++p;

		p->V[X] = g;	p->V[Y] = h;	p->V[Z] = 0;
		p->flags = V_DRAW;	++p;

		p->V[X] = -h;	p->V[Y] = g;	p->V[Z] = 0;
		p->flags = V_MOVE;	++p;

		p->V[X] = h;	p->V[Y] = g;	p->V[Z] = 0;
		p->flags = V_DRAW;	++p;
	}
	p->flags = 0;
	return (0);
}

static void FAR
term_ground (BODY *b)
{
	shape_ground.v = xfree (shape_ground.v);
}

static int FAR
create_ground (OBJECT *p)
{
	p->color = st.ground;
	p->time = FOREVER;
	p->flags |= F_VISIBLE;
	Mident (p->T);

	return (0);
}

static void FAR
delete_ground (OBJECT *p)
{}

static void FAR
dynamics_ground (OBJECT *p, int interval)
{
	p->R[X] = (((CV->R[X]/VONE+GUNIT/2)/GUNIT)*GUNIT)*VONE;
	p->R[Y] = (((CV->R[Y]/VONE+GUNIT/2)/GUNIT)*GUNIT)*VONE;
}

BODY BoGround = {
	0,
	0,
	"GROUND",
	&shape_ground,
	init_ground,
	term_ground,
	create_ground,
	delete_ground,
	dynamics_ground,
	body_hit
};

#undef GUNIT
#undef HORIZON
