/* --------------------------------- osmoke.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: smoke speck.
*/

#include "fly.h"


static SHAPE shape_smoke = {
	0,
	0,
	0,
	1L,		/* weight */
	0		/* drag */
};

static int FAR
init_smoke (BODY *b)
{
	if (shape_read (&shape_smoke, "smoke"))
		return (1);
	return (0);
}

static void FAR
term_smoke (BODY *b)
{
	shape_free (shape_smoke.v);
}

static int FAR
create_smoke (OBJECT *p)
{
	if (!st.owner)
		return (1);

	p->color = st.lgray;
	p->time = 5*TIMEPSEC;
	p->flags |= F_VISIBLE|F_DONE;

	LVcopy (p->R, st.owner->R);
	Vcopy (p->a, st.owner->a);
	Mcopy (p->T, st.owner->T);
        p->speed = p->V[Z] = 10*VONE;

        return (0);
}

#define DVSMOKE        1*VONE
#define DASMOKE        (D90/10)

static void FAR
dynamics_smoke (OBJECT *p, int interval)
{
	p->V[X] += Frand()%(DVSMOKE+1) - DVSMOKE/2;
	p->V[Y] += Frand()%(DVSMOKE+1) - DVSMOKE/2;
	p->V[Z] += Frand()%(DVSMOKE+1) - DVSMOKE/2;
	p->speed = ihypot3d (p->V);
	p->a[X] += Frand()%(DASMOKE+1) - DASMOKE/2;
	p->a[Y] += Frand()%(DASMOKE+1) - DASMOKE/2;
	p->a[Z] += Frand()%(DASMOKE+1) - DASMOKE/2;
	Mobj (p);

	object_update (p, interval);
}

#undef DVSMOKE
#undef DASMOKE

BODY BoSmoke = {
	0,
	0,
	"SMOKE",
	&shape_smoke,
	init_smoke,
	term_smoke,
	create_smoke,
	body_delete,
	dynamics_smoke,
	body_hit
};
