/* --------------------------------- random.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the random pointing device.
*/

#include "fly.h"


static int FAR
Rread (POINTER *p, int transfer)
{
	int	i;

	if (p->c[0] > 0) {
		if (p->a[3] < 75)
			p->a[3] += 5;		/* throttle up */
		--p->c[0];
	} else if (p->c[0] > -10) {
		--p->c[0];
		p->a[1] += 10;			/* pitch up */
	} else if (p->c[0] > -30) {
		--p->c[0];
		p->a[1] -= 10;			/* pitch down */
	} else if (p->c[0] > -40) {
		--p->c[0];
		p->a[1] += 10;			/* pitch up */
	} else {
		p->a[1] = 0;
		p->b[1] = 0;
#if 1
		i = p->a[0];
		if (i < 0)
			++i;
		else if (i > 0)
			--i;
		i += (Frand () % 10) - 5;
		if (i > 40)
			i = 80 - i;
		else if (i < -40)
			i = -80 - i;
		p->a[0] = i;
#else
		p->a[0] = 0;
#endif
	}
	if (transfer) {
		p->l[0] = p->a[0];
		p->l[1] = p->a[1];
		p->l[3] = p->a[3];
	}

	return (0);
}

static int FAR
Rcal (POINTER *p)
{
	p->c[0] = 50;		/* set course for 250 m/s */
	p->b[0] = 0;
	p->b[1] = 0;
	p->l[0] = 0;
	p->l[1] = 0;
	p->l[0] = 0;
	p->l[1] = 0;
	return (0);
}

static int FAR
Rinit (POINTER *p, char *options)
{
	return (Rcal (p));
}

static void FAR
Rterm (POINTER *p)
{}

static void FAR
Rkey (POINTER *p, int key)
{}

struct PtrDriver NEAR PtrRandom = {
	"RANDOM",
	0,
	Rinit,
	Rterm,
	Rcal,
	Rcal,			/* center */
	Rread,
	Rkey
};
