/* --------------------------------- system.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Common system-services.
*/

#include "fly.h"


static void NEAR
idle_loop (void)
{
	Ulong	t;

	if ((st.flags & SF_SIMULATING) || !(st.flags & SF_INITED))
		return;
	st.flags |= SF_SIMULATING;

	t = Tm->Milli () - st.big_bang - st.present;
	if (VIS_ALTERNATING == st.stereo) {		/* limit refresh rate */
		if (t < REFRESH/2)
			goto ret;
	} else if ((st.flags1 & SF_DBUFFERING) && !(st.network & NET_ON)) {
		if (t < 10)
			goto ret;
	} else if (t < REFRESH)
		goto ret;

	active_loop (t);		/* do one video frame */
	log_flush (0);
ret:
	st.flags &= ~SF_SIMULATING;
}

extern void FAR
sys_poll (void)
{
	st.lasttime = Tm->Milli () - st.big_bang;
	if (Sys->Poll)
		Sys->Poll ();
	if (Snd->Poll)
		Snd->Poll (0);
	idle_loop ();
}
