/* --------------------------------- version.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* version number and last date/time.
*/

#include "fly.h"


#define	VERSION		"1.02"
#define	VERDATE		__DATE__
#define	VERTIME		__TIME__

extern void FAR
welcome (int where)
{
	if (0 == where) {		/* screen */
		MsgPrintf (100, "Welcome to Fly8");
		MsgPrintf (100, "Version %s %s %s", VERSION, VERDATE, VERTIME);
		MsgPrintf (100, "By Eyal Lebedinsky");
		MsgPrintf (100, "(eyal@ise.canberra.edu.au)");
#ifndef NOSTDERR
	} else if (2 == where) {	/* stderr */
		fprintf (stderr, "Welcome to Fly8 ");
		fprintf (stderr, "version %s %s %s\n", VERSION, VERDATE, VERTIME);
		fprintf (stderr, "By Eyal Lebedinsky ");
		fprintf (stderr, "(eyal@ise.canberra.edu.au)\n");
#endif
	} else {			/* log */
		LogPrintf ("Welcome to Fly8 ");
		LogPrintf ("version %s %s %s\n", VERSION, VERDATE, VERTIME);
		LogPrintf ("By Eyal Lebedinsky ");
		LogPrintf ("(eyal@ise.canberra.edu.au)\n");
	}
}
#undef VERSION
#undef VERDATE
#undef VERTIME
