/* --------------------------------- debug.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Routines that get used only for debug.
*/

#ifndef	DEBUG_MULDIV
#define	DEBUG_MULDIV
#endif

#include "fly.h"


#ifdef	DEBUG_MULDIV

static int	muldiv_flag = 0;

extern long FAR
lcheck (long x, char *name, char *file, int line)
{
	if (x > (long)0x00007fffL) {
		muldiv_flag = 1;
		LogPrintf ("check> %s(%u) %s>%ld\n", file, line, name, x);
		++st.stats[42];
		return (0x00007fffL);
	}
	if (x < (long)0xffff8000L) {
		muldiv_flag = 2;
		LogPrintf ("check> %s(%u) %s<%ld\n", file, line, name, x);
		++st.stats[42];
		return (0xffff8000L);
	}
	return (x);
}

extern int FAR
fmulchk (long x, long y, char *file, int line)
{
	long	r, tx, ty, tr;
	int	t;

	t = muldiv_flag;
	muldiv_flag = 0;

	x = lcheck (tx=x, "x", file, line);
	y = lcheck (ty=y, "y", file, line);
	r = (tx * ty) >> FSCALE;
	r = lcheck (tr=r, "r", file, line);
	if (muldiv_flag)
		LogPrintf ("fmul (%ld, %ld)= %ld\n", tx, ty, tr);
	else
		muldiv_flag = t;
	return ((int)r);
}

extern int FAR
fdivchk (long x, long y, char *file, int line)
{
	long	r, tx, ty, tr;
	int	t;

	t = muldiv_flag;
	muldiv_flag = 0;

	x = lcheck (tx=x, "x", file, line);
	y = lcheck (ty=y, "y", file, line);
	if (y == 0L) {
		muldiv_flag = 3;
		LogPrintf ("check> %s(%u) y=%ld\n", file, line, y);
		++st.stats[42];
		tr=r = 0x7fff;
	} else {
		r = (tx << FSCALE) / ty;
		r = lcheck (tr=r, "r", file, line);
	}
	if (muldiv_flag)
		LogPrintf ("fdiv (%ld, %ld)= %ld\n", tx, ty, tr);
	else
		muldiv_flag = t;
	return ((int)r);
}

extern int FAR
muldivchk (long x, long y, long z, char *file, int line)
{
	long	r, tx, ty, tz, tr;
	int	t;

	t = muldiv_flag;
	muldiv_flag = 0;

	x = lcheck (tx=x, "x", file, line);
	y = lcheck (ty=y, "y", file, line);
	if (z == 0L) {
		tz = z;
		muldiv_flag = 3;
		LogPrintf ("check> %s(%u) z=%ld\n", file, line, tz);
		++st.stats[42];
		tr=r= 0x7fff;
	} else {
		z = lcheck (tz=z, "z", file, line);
		r = (tx * ty) / tz;
		r = lcheck (tr=r, "r", file, line);
	}
	if (muldiv_flag)
		LogPrintf ("muldiv (%ld, %ld, %ld)= %ld\n", tx, ty, tz, tr);
	else
		muldiv_flag = t;
	return ((int)r);
}
#endif	/*DEBUG_MULDIV*/

#undef DEBUG_MULDIV
