/* ------------------------- ellipse.c -------------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Based on the version from ACM TOG V11N3 (July 1992), this one is
 * modified to do 2 quads at a time to reduce VGA page flips.
*/

#include "fly.h"
#include "gr.h"

#include <graphics.h>


#define point(x,y,c) \
	pva = xxyy+(x)+(y);		\
	if (!_GrWriteMode)		\
		*pva = (Uchar)(c);	\
	else  if (_GrWriteMode & GrXOR)	\
		*pva ^= (c);		\
	else if (_GrWriteMode & GrOR)	\
		*pva  |= (c)

#define incx()		x++, b2x += b2, dxt += d2xt, t += dxt
#define incy()		y--, a2y -= a2, dyt += d2yt, t += dyt, yy -= width

extern void FAR
GrEllipse (int xc, int yc, int a, int b, Uint c)
{
	char	*xxyy, *pva;
	int	x, y, width, height;
	long	yy, a2, b2, crit1, crit2, crit3, t, dxt, dyt, d2xt, d2yt;
	long	b2x, a2y;

	width  = GrMaxX () + 1;
	height = GrMaxY () + 1;
	if (xc-a < 0 || xc+a >= width ||
	    yc-b < 0 || yc+b >= height)
		return;
	SetWriteMode (c);
	xxyy = _ActiveBase + xc + yc * (long)width;

	x = 0;
	y = b;
	yy = y*(long)width;
	a2 = (long)a*a;
	b2 = (long)b*b;
	crit1 = -(a2/4 + a%2 + b2);
	crit2 = -(b2/4 + b%2 + a2);
	crit3 = -(b2/4 + b%2);
	t = -a2*y;
	dxt = 2*b2*x;
	dyt = -2*a2*y;
	d2xt = 2*b2;
	d2yt = 2*a2;
	b2x = b2*x;
	a2y = a2*y;

	while (y>=0 && x<=a) {
		point (x, yy, c);
		if (x && y) {
			point (-x, yy, c);
		}
		if (t + b2x <= crit1 || t + a2y <= crit3)
			incx ();
		else if (t - a2y > crit2)
			incy ();
		else {
			incx ();
			incy ();
		}
	}

	x = 0;
	y = b;
	yy = y*(long)width;
	t = -a2*y;
	dxt = 2*b2*x;
	dyt = -2*a2*y;
	d2xt = 2*b2;
	d2yt = 2*a2;
	b2x = b2*x;
	a2y = a2*y;

	while (y>=0 && x<=a) {
		if (x || y) {
			point (-x, -yy, c);
		}
		if (x && y) {
			point ( x, -yy, c);
		}
		if (t + b2x <= crit1 || t + a2y <= crit3)
			incx ();
		else if (t - a2y > crit2)
			incy ();
		else {
			incx ();
			incy ();
		}
	}
}
