/* --------------------------------- grdj.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Vga graphics driver (direct tseng4000 access, 256 colors only).
*/

#include "fly.h"
#include "colors.h"

#include <graphics.h>
#include <pc.h>


#define inp(p) 		inportb(p)
#define outp(p,b)	outportb(p,b)

#define GrOR	0x200

static int _GrWriteMode;
static int x = 0, y = 0;

static void FAR
DrawTo (int x2, int y2, Uint c)
{
	GrLine (x, y, x2, y2, _GrWriteMode|c);
	x = x2;
	y = y2;
}

static void FAR
MoveTo (int x1, int y1)
{
	x = x1;
	y = y1;
}

static void FAR
SetActive (int page)
{}

static void FAR
SetVisual (int page)				/* done */
{}

static int FAR
CursorMode (int mode)
{return (0);}

static void FAR
TextColor (Uint fg, Uint bg)			/* done */
{}

static void FAR
FontSet (DEVICE *dev, char *fname)		/* done */
{}

static void FAR
TextChar (int c)				/* done */
{}

static void FAR
TextPut (int c)					/* done */
{}

static void FAR
SetTextPos (int row, int col)			/* done */
{}

static void FAR
PushTextPos (void)
{}

static void FAR
PopTextPos (void)
{}

static void FAR
TextClear (void)
{}

static void FAR
WriteMode (int mode)
{
	switch (mode) {
	default:
	case T_MSET:
		_GrWriteMode = 0;
		break;
	case T_MOR:
		_GrWriteMode = GrOR;
		break;
	case T_MXOR:
		_GrWriteMode = GrXOR;
		break;
	}
}

static void FAR
Clear (int x, int y, int sizex, int sizey, Uint color)
{
	for (sizey += y, sizex += x-1;y < sizey; ++y)
		GrLine (x, y, sizex, y, color);
}

static void FAR
SetPalette (int n, long c)
{
	int	r, g, b;

	r = 0x0ff & (int)(c      );
	g = 0x0ff & (int)(c >>  8); 
	b = 0x0ff & (int)(c >> 16);
	GrSetColor (n, r, g, b);
}

static void FAR
OpenTextWindow (SCREEN *scr)
{}

static void FAR
CloseTextWindow (SCREEN *scr)
{}

static int FAR
Init (DEVICE *dev, char *options)
{
	int	i;

	if (dev->sizex == 0 || dev->sizey == 0)
		return (1);

	GrSetMode (GR_width_height_graphics, dev->sizex, dev->sizey);

#if 0
	if (dev->mode > 0)
		GrSetBiosMode (dev->mode);
#endif
	dev->npages = 1;
	for (i = 0; i++ < 256 && GrAllocCell () >= 0;)	/* get 2-255 */
		;

	st.black   = 0;	/* cannot change */
	st.white   = 1;	/* cannot change */
	st.red     = 2;	/* do not change! */
	st.blue    = 4;	/* do not change! */
	st.magenta = 6;	/* do not change! */
	st.green   = 3;
	st.brown   = 5;
	st.gray    = 7;
	st.hudlow  = 8;
	st.hudhigh = 9;
	st.skyblue = 10;
	st.lred    = 11;
	st.lgray   = 12;
	st.ground  = 13;
	st.lblue   = 14;
/*	st.white   = 15;	keep 15 for OR'ed white */

	SetPalette (st.black,   C_BLACK);
	SetPalette (st.white,   C_WHITE);
	SetPalette (st.red,     C_RED);
	SetPalette (st.blue,    C_BLUE);
	SetPalette (st.magenta, C_MAGENTA);
	SetPalette (st.green,   C_GREEN);
	SetPalette (st.brown,   C_BROWN);
	SetPalette (st.gray,    C_GRAY);
	SetPalette (st.hudlow,  C_LYELLOW);
	SetPalette (st.hudhigh, C_YELLOW);
	SetPalette (st.lred,    C_LIGHTRED);
	SetPalette (st.skyblue, C_SKYBLUE);
	SetPalette (st.lgray,   C_LIGHTGRAY);
	SetPalette (st.ground,  C_GRAY);
	SetPalette (st.lblue,   C_LIGHTBLUE);

	for (i = 0; i < dev->npages; ++i) {
		SetActive (i);
		Clear (0, 0, dev->sizex, dev->sizey, st.black);
	}

	SetVisual (0);
	SetActive (0);

	if (st.fname == 0)
		st.fname = strdup ("6x8.fnt");
	FontSet (dev, st.fname);
	dev->FontWidth  = 8;
	dev->FontHeight = 8;

	return (0);
}

static void FAR
Term (DEVICE *dev)		/* done */
{
	GrSetMode (GR_default_text, 0, 0);
}

static void FAR
Ellipse (register int x1, register int y1, int rx, int ry, register Uint color)
{
	int	ax, bx, cx, dx, ay, by, cy, dy;

	ax = fmul ( 3196, rx);		/* sin (pi/16) */
	ay = fmul ( 3196, ry);
	bx = fmul ( 9102, rx);		/* sin (3*pi/16) */
	by = fmul ( 9102, ry);
	cx = fmul (13623, rx);		/* sin (5*pi/16) */
	cy = fmul (13623, ry);
	dx = fmul (16069, rx);		/* sin (7*pi/16) */
	dy = fmul (16069, ry);

	MoveTo (x1+dx, y1-ay);
	DrawTo (x1+cx, y1-by, color);
	DrawTo (x1+bx, y1-cy, color);
	DrawTo (x1+ax, y1-dy, color);
	DrawTo (x1-ax, y1-dy, color);
	DrawTo (x1-bx, y1-cy, color);
	DrawTo (x1-cx, y1-by, color);
	DrawTo (x1-dx, y1-ay, color);
	DrawTo (x1-dx, y1+ay, color);
	DrawTo (x1-cx, y1+by, color);
	DrawTo (x1-bx, y1+cy, color);
	DrawTo (x1-ax, y1+dy, color);
	DrawTo (x1+ax, y1+dy, color);
	DrawTo (x1+bx, y1+cy, color);
	DrawTo (x1+cx, y1+by, color);
	DrawTo (x1+dx, y1+ay, color);
	DrawTo (x1+dx, y1-ay, color);
}

static void FAR
Sync (void)
{}

static void FAR
Flush (void)
{}

static void FAR
Shutters (int eye)
{
	if (st.misc[7]) {
		if (eye >= 0)
			outp (st.misc[7]+4, 1+2*eye);
		else if (-1 == eye)
			outp (st.misc[7]+4, 1);		/* on */
		else if (-2 == eye)
			outp (st.misc[7]+4, 0);		/* off */
	}
}

#undef inp
#undef outp
#undef GrOR

struct GrDriver NEAR GrDJ = {
	"GrDJ",
	0,
	0,
	Init,
	Term,
	OpenTextWindow,
	CloseTextWindow,
	FontSet,
	TextPut,
	TextChar,
	TextColor,
	CursorMode,
	MoveTo,
	DrawTo,
	SetVisual,
	SetActive,
	0,	/* Clear() too slow */
	SetTextPos,
	PushTextPos,
	PopTextPos,
	TextClear,
	WriteMode,
	SetPalette,
	Ellipse,
	Sync,		/* not used anymore */
	Flush,
	Shutters
};
