/* --------------------------------- mouse.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the mouse as a pointing device.
*/

#include "fly.h"

#include <graphics.h>
#include <mouse.h>


#define PO	p->opt

static int	speed = 2;

static int FAR
MUcal (POINTER *p)
{
	MouseWarp (GrMaxX()/2, GrMaxY()/2);
	return (0);
}

static int FAR
MUinit (POINTER *p, char *options)
{
	MouseSetSpeed (speed);
	p->flags |= PF_INITED;

	return (0);
}

static void FAR
MUterm (POINTER *p)
{
	p->flags = 0;
}

static int FAR
MUread (POINTER *p)
{
	MouseEvent	event[1];
	int		i;

	MouseGetEvent (M_POLL|M_NOPAINT, event);

	i = GrMaxX();
	p->a[PO[1]] = muldiv (event->x, 200, i) - 100;		/* x */
	p->a[PO[1]] *=  -PO[0];

	i = GrMaxY();
	p->a[PO[3]] = muldiv (event->y, 200, i) - 100;		/* y */
	p->a[PO[3]] *=  PO[2];

	p->b[PO[4]] += event->buttons & M_LEFT;		/* right button */
	p->b[PO[5]] += event->buttons & M_RIGHT;	/* left button */

	return (0);
}

struct PtrDriver NEAR PtrMouse = {
	"MOUSE",
	0,
	MUinit,
	MUterm,
	MUcal,
	MUcal,			/* center */
	MUread,
	std_key
};
