/* --------------------------------- drivers.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* User defined lists of drivers.
 *
 * Associated with the player we have one of each:
 *  Graphics Driver (output)
 *  Sound Driver (output)
 *  Keyboard Driver (input)
 *  Pointer Driver (input)
 *  Network Drivers (i/o)
 *
 *  Windows support by Michael Taylor miket@canb.auug.org.au
*/

#include "fly.h"

extern struct GrDriver NEAR GrMSWin;

struct GrDriver NEAR * FAR GrDrivers[] = {
	&GrMSWin,		/* flicker - single buffered		 */
				/* use bitmaps to double buffer - Slow!! */
0};


struct SndDriver NEAR * FAR SndDrivers[] = {
	0,
0};


extern struct PtrDriver NEAR PtrMouse;
extern struct PtrDriver NEAR PtrKeypad;
extern struct PtrDriver NEAR PtrAstick;
extern struct PtrDriver NEAR PtrBstick;
extern struct PtrDriver NEAR PtrRandom;

struct PtrDriver NEAR * FAR PtrDrivers[] = {
	&PtrKeypad,
	&PtrMouse,
	&PtrAstick,
	&PtrBstick,
	&PtrRandom,
0};


extern struct KbdDriver NEAR KbdConsole;

struct KbdDriver NEAR * FAR KbdDrivers[] = {
	&KbdConsole,
0};


struct NetDriver NEAR * FAR NetDrivers[] = {
0};
