/* ------------------------- ellipse.c -------------------------------------- */

/* Based on the acm version from TOG V11N3 (July 1992), this one is
 * modified to do 2 quads at a time to limit VGA page flips.
*/

#include "vgr.h"

#define FastPlot(dx,dy,c) \
	if (((xy=xxyy+(dx)+(dy))&0xff0000L) != rp)	\
		(_GrNewPage (xy), rp = xy&0xff0000L);	\
	if (!_GrWriteMode)				\
		VGA_PAGE[(uint)xy] = (uchar)(c);	\
	else if (_GrWriteMode & GrOR)			\
		VGA_PAGE[(uint)xy] |= (c);		\
	else /* GrXOR */				\
		VGA_PAGE[(uint)xy] ^= (c)

#define point(x,y,c)	FastPlot (x, y, c)
#define incx()		(x++, b2x += b2, dxt += d2xt, t += dxt)
#define incy()		(y--, a2y -= a2, dyt += d2yt, t += dyt, yy -= _GrSizeX)

extern void far
GrEllipse (int xc, int yc, int a, int b, unsigned int c)
{
	register long	xxyy;
	register ulong	xy;
	int	x = 0, y = b;
	long	yy = y*(long)_GrSizeX;
	long	rp = ((long)_ReadPage) << 16;
	long	a2 = (long)a*a, b2 = (long)b*b;
	long	crit1 = -(a2/4 + a%2 + b2);
	long	crit2 = -(b2/4 + b%2 + a2);
	long	crit3 = -(b2/4 + b%2);
	long	t = -a2*y;
	long	dxt = 2*b2*x, dyt = -2*a2*y;
	long	d2xt = 2*b2, d2yt = 2*a2;
	long	b2x = b2*x, a2y = a2*y;

	if (xc-a < 0 || xc+a >= (int)_GrSizeX ||
	    yc-b < 0 || yc+b >= (int)_GrSizeY)
		return;
#if 0
	GrSetWriteMode (c);
#endif
	xxyy = xc + ActiveBase + yc * (long)_GrSizeX;

	while (y>=0 && x<=a) {
		point (x, yy, c);
		if (x && y) {
			point (-x,  yy, c);
		}
		if (t + b2x <= crit1 || t + a2y <= crit3)
			incx ();
		else if (t - a2y > crit2)
			incy ();
		else {
			incx ();
			incy ();
		}
	}

	x = 0, y = b;
	yy = y*(long)_GrSizeX;
	rp = ((long)_ReadPage) << 16;
	t = -a2*y;
	dxt = 2*b2*x, dyt = -2*a2*y;
	d2xt = 2*b2, d2yt = 2*a2;
	b2x = b2*x, a2y = a2*y;

	while (y>=0 && x<=a) {
		if (x || y) {
			point (-x, -yy, c);
		}
		if (x && y) {
			point ( x, -yy, c);
		}
		if (t + b2x <= crit1 || t + a2y <= crit3)
			incx ();
		else if (t - a2y > crit2)
			incy ();
		else {
			incx ();
			incy ();
		}
	}
}


#if 0
/*
 * This one is from acm TOG V11N3 (July 1992).
*/

#define point(x,y,c)	FastPlot (x, y, c)
#define incx()		x++, b2x += b2, dxt += d2xt, t += dxt
#define incy()		y--, a2y -= a2, dyt += d2yt, t += dyt, yy -= _GrSizeX

static void far
AcmEllipse (int xc, int yc, int a, int b, unsigned int c)
{
	register long	xxyy;
	register ulong	xy;
	register long	yy = (long)b*_GrSizeX;
	int		x = 0, y = b;
	long		a2 = (long)a*a, b2 = (long)b*b;
	long		crit1 = -(a2/4 + a%2 + b2);
	long		crit2 = -(b2/4 + b%2 + a2);
	long		crit3 = -(b2/4 + b%2);
	long		t = -a2*y;
	long		dxt = 2*b2*x, dyt = -2*a2*y;
	long		d2xt = 2*b2, d2yt = 2*a2;
	long		b2x = b2*x, a2y = a2*y;

	if (xc-a < 0 || xc+a >= (int)_GrSizeX ||
					yc-b < 0 || yc+b >= (int)_GrSizeY)
		return;
	GrSetWriteMode (c);
	xxyy = xc + ActiveBase + yc * (long)_GrSizeX;

	while (y>=0 && x<=a) {
		point (x, yy, c);
		if (x || y)
			point (-x, -yy, c);
		if (x && y) {
			point ( x, -yy, c);
			point (-x,  yy, c);
		}
		if (t + b2x <= crit1 ||
		    t + a2y <= crit3)
			incx ();
		else if (t - a2y > crit2)
			incy ();
		else {
			incx ();
			incy ();
		}
	}
}
#endif


#if 0
From mcdonald@aries.scs.uiuc.edu Wed Sep  2 00:53:12 1992

>I thought the books will have it - but no. The latest I checked
>[FoleyEtAl2ed] uses some floats and the loop calculation are not just
>linear (add/subtract). An older book [F.S.HillJr] leaves it as an
>exercise to the reader and no on. Circles are nice but useless generaly
>because most screen have at least some modes where the pixels are NOT
>square.

>So, Any reference, program (any language) or description (must be
>detailed) will be most wellcome.

>No, this is not a course exercise. These days I consider it a compliment
>to be mestaken for a student (not that it happens).

Here is code for an ellipse drawer for horizontal or vertical ellipses.
All integer. 

extern void     e_start();	/* Starts off by writing right and left
				 * points                                */
			/* The "lower" and "higher" in the following refer
			 * to the upper right quadrant. In my PC program
			 * these are assembler routines		         */
extern void     e_xd();	/* Moves one step to lower x (in all 4 quadrants)*/
extern void     e_xdyu();	/* Moves to lower x, higher y            */
extern void     e_yu();   	/* Moves to higher y                     */

#define FastPlot(dx,dy,c) \
	if ((uint)((xy=xxyy+(dx)+(dy)) >> 16) !=_ReadPage)	\
		_GrNewPage (xy);			\
	if (!_GrWriteMode)				\
		VGA_PAGE[(uint)xy] = (uchar)(c);	\
	else if (_GrWriteMode & GrXOR)			\
		VGA_PAGE[(uint)xy] ^= (c);		\
	else if (_GrWriteMode & GrOR)			\
		VGA_PAGE[(uint)xy] |= (c)

#define e_start(xl,xr,y,c)	FastPlot(-irx,0,c);FastPlot(+irx,0,c)
#define	e_4()		FastPlot(-dx,-dyy,c);FastPlot(+dx,-dyy,c);\
			FastPlot(-dx,+dyy,c);FastPlot(+dx,+dyy,c)
#define	e_xd()		e_4()
#define	e_xdyu()	dyy+=_GrSizeX;e_4()
#define	e_yu()		dyy+=_GrSizeX;e_4()

/* Draw an ellipse with width irx and height iry                         */
/* from a routine by Tim Hogan in Dr. Dobb's Journal May '85 p.40        */
/* Improved by calculating increments incrementally, thus removing all   */
/* multiplies from the loops. These multiplies were very bad since they  */
/* were (long)*(long). This code, when compiled by Microsoft C Version 4,*/
/* can't be significantly improved by hand optimization.                 */
/* Written Sept. 7, 1987 by J.D. McDonald (public domain)                */

static void far
OldGrEllipse (int x, int y, int irx, int iry, uint c)
{
	register long	xxyy;
	register ulong	xy;
	register int	dy, dx;
	long		d, dyy;
	long		alpha, beta, alpha2, alpha4, beta2, beta4;
	long		ddx, ddy, alphadx, betady;

	if (x-irx < 0 || x+irx >= (int)_GrSizeX ||
					y-iry < 0 || y+iry >= (int)_GrSizeY)
		return;
	GrSetWriteMode (c);
	xxyy = x + ActiveBase + y * (long)_GrSizeX;
	dyy = 0;

    beta = (long) irx *(long) irx;
    alpha = (long) iry *(long) iry;
    if (alpha == 0L)
	alpha = 1L;
    if (beta == 0L)
	beta = 1L;
    dy = 0;
    dx = irx;
    alpha2 = alpha << 1;
    alpha4 = alpha2 << 1;
    beta2 = beta << 1;
    beta4 = beta2 << 1;
    alphadx = alpha * dx;
    betady = 0;
    ddx = alpha4 * (1 - dx);
    ddy = beta2 * 3;
    d = alpha2 * ((long) (dx - 1) * dx) + alpha + beta2 * (1 - alpha);
    e_start(x - dx, x + dx, y, c);
    do {
	dy++;
	if (d >= 0) {
	    d += ddx;
	    dx--;
	    alphadx -= alpha;
	    ddx += alpha4;
	    e_xdyu();
	} else {
	    e_yu();
	}
	d += ddy;
	betady += beta;
	ddy += beta4;
    } while (alphadx > betady);
    d = beta2 * ((long) dy * (dy + 1)) + alpha2 * ((long) dx * (dx - 2) + 1) 
	+ beta * (1 - alpha2);
    ddx = alpha2 * (3 - (dx << 1));
    ddy = beta4 * (1 + dy);
    do {
	dx--;
	if (d <= 0) {
	    d += ddy;
	    ddy += beta4;
	    dy++;
	    e_xdyu();
	} else {
	    e_xd();
	}
	d += ddx;
	ddx += alpha4;
    } while (dx > 0);
}

#if 0
extern void far
fillelip(int x, int y, int irx, int iry, uint c)
{
    beta = (long) irx *(long) irx;
    alpha = (long) iry *(long) iry;
    if (alpha == 0L)
	alpha = 1L;
    if (beta == 0L)
	beta = 1L;
    dy = 0;
    dx = irx;
    alpha2 = alpha << 1;
    alpha4 = alpha2 << 1;
    beta2 = beta << 1;
    beta4 = beta2 << 1;
    alphadx = alpha * dx;
    betady = 0;
    ddx = alpha4 * (1 - dx);
    ddy = beta2 * 3;
    d = alpha2 * ((long) (dx - 1) * dx) + alpha + beta2 * (1 - alpha);
    rectfill(x - dx, y, x + dx, y, c);
    do {
	if (d >= 0) {
	    d += ddx;
	    dx--;
	    alphadx -= alpha;
	    ddx += alpha4;
	}
	d += ddy;
	dy++;
	betady += beta;
	ddy += beta4;
	rectfill(x - dx, y + dy, x + dx, y + dy, c);
	rectfill(x - dx, y - dy, x + dx, y - dy, c);
    } while (alphadx > betady);
    d = beta2 * ((long) dy * (dy + 1)) + alpha2 * ((long) dx * (dx - 2) + 1) 
	+ beta * (1 - alpha2);
    ddx = alpha2 * (3 - (dx << 1));
    ddy = beta4 * (1 + dy);
    do {
	dx--;
	if (d <= 0) {
	    d += ddy;
	    ddy += beta4;
	    dy++;
	    rectfill(x - dx, y + dy, x + dx, y + dy, c);
	    rectfill(x - dx, y - dy, x + dx, y - dy, c);
	}
	d += ddx;
	ddx += alpha4;
    } while (dx > 0);
}
#endif
#endif
