/* ------------------------------- low.c ------------------------------------ */

#include <time.h>
#include <conio.h>

#include "vgr.h"

uint		near _ReadPage = 0L;
static uint	_WritePage = 0L;

extern int far
GrSetBiosMode (n)
int	n;
{
	REGISTERS	regs;

	if (n >= 0x100) {
		regs.ax = 0x4f02;
		regs.bx = n;
	} else
		regs.ax = n;
	return (int10 (&regs));
}

extern void far _fastcall
_GrSetPage (pread, pwrite)
int	pread;
int	pwrite;
{
	_SetPG (pread);

	_ReadPage = pread;
	_WritePage = pwrite;
}

extern uint far _fastcall
_GrGetPage ()
{
	return (_ReadPage);
}

extern uchar far * far _fastcall
_GrAddr (x, y, width)
uint	x;
uint	y;
uint	width;
{
	ulong	xy;
	uint	page;

	page = (uint)((xy = x + ActiveBase + y*(long)width) >> 16);
#if 0
	if (page > 0x0f)
		return VGA_PAGE;
#endif
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

extern uchar far * far _fastcall
_GrNewPage (xy)
ulong	xy;
{
	uint	page;

	page = (uint)(xy >> 16);
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

static short far
Disable (void)
{
	short	flags;

	_asm {
		pushf
		pop	flags
		cli
	}
	return (flags);
}

static void far
Enable (short flags)
{
	_asm {
		push	flags
		popf
	}
}

extern void far _fastcall
_GrSetColor (color, r, g, b)
int	color;
int	r;
int	g;
int	b;
{
	short	flags;

	flags = Disable ();
	outp (0x3c8, color);	(void)inp (0x080);
	outp (0x3c9, r >> 2);	(void)inp (0x080);
	outp (0x3c9, g >> 2);	(void)inp (0x080);
	outp (0x3c9, b >> 2);
	Enable (flags);
}

extern void far
GrSetVisual (long base)
{
	_SetVS (base);
}

extern int far
GrVsync (void)
{
	time_t	i;

	i = time (0) + 2;
	while (inp (0x3da) & 0x08)	/* wait for end Vsync */
		if (i == time (0))
			return (1);	/* timed out */
	while (!(inp (0x3da) & 0x08))	/* wait for start Vsync */
		if (i == time (0))
			return (1);	/* timed out */
	return (0);
}
