;****************************************************************************
;*
;*						MegaGraph Graphics Library
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*							All rights reserved.
;*
;* Filename:	$RCSfile: sv_banks.asm $
;* Version:		$Revision: 1.2 $
;*
;* Language:	80386 Assembler
;* Environment:	IBM PC (MS DOS)
;*
;* Description:	This source file contains the code needed to change banks
;*		on supported SuperVGA adapters, along with tables to find
;*		the correct routines for a specified video card.
;*
;*		The code in here originally appeared in John Bridges
;*		VGAKIT library, and has been modified to work with the
;*		MGL. Specifically support for individually setting the
;*		read and write banks has been included, along with adapter
;*		initialisation code (such as accessing extended registers
;*		etc).
;*
;*		To set up separate read/write banks, you must first call
;*		NewBank to set the read/write banks to the same value,
;*		then call ReadBank to change the read bank value.
;*
;* $Id: sv_banks.asm 1.2 1993/03/07 04:05:36 kjb Exp $
;*
;* Revision History:
;* -----------------
;*
;* $Log: sv_banks.asm $
;* Revision 1.2  1993/03/07  04:05:36  kjb
;* Bug fixes.
;*
;* Revision 1.1  1993/03/03  10:26:52  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; NewBank	Change to a new 64k bank on a SuperVGA card (reading and writing)
;----------------------------------------------------------------------------
;
; Changes to a new 64k bank given the specified index. The global variable
; CurBank is updated to reflect the current bank number and can be used
; to avoid unnecessary bank switching.
;
; These routines should set both the read and write bank for cards that
; support multiple banks to the same bank number.
;
; Note that the value of all regs MUST be preserved across this call.
;
; Entry:		AX	- Number of 64k bank (0-15 for 1Mb cards)
;
; Registers:	None.
;
;----------------------------------------------------------------------------

_TEXT	ENDS
_DATA	SEGMENT

; Table of SuperVGA bank switching routines by video card.

chipbank dw	NONE_bank

SVGA_bank dw	NONE_bank	;  0 No Chip
	dw	VESA_bank	;  1 VESA SuperVGA
	dw	ATI_bank	;  2 ATI Technologies SuperVGA (NONE)
	dw	AHEADA_bank	;  3 AHEAD A SuperVGA (NONE)
	dw	AHEADB_bank	;  4 AHEAD B SuperVGA
	dw	CHIPS451_bank	;  5 Chips & Technologies SuperVGA
	dw	EVEREX_bank	;  6 Everex SuperVGA (NONE)
	dw	GENOA_bank	;  7 Genoa Systems SuperVGA (NONE)
	dw	OAK_bank	;  8 OAK Technologies SuperVGA (NONE)
	dw	PARADISE_bank	;  9 Paradise SuperVGA
	dw	TRIDENT_bank	; 10 Trident 8800 SuperVGA
	dw	TRIDENT_bank	; 11 Trident 8900 SuperVGA
	dw	VIDEO7V5_bank	; 12 Video7 SuperVGA
	dw	ET3000_bank	; 13 Tseng Labs ET3000 SuperVGA
	dw	ET4000_bank	; 14 Tseng Labs ET4000 SuperVGA
	dw	NCR_bank	; 15 NCR 77C22E SuperVGA
	dw	S3_bank		; 16 S3 SuperVGA
	dw	ACUMOS_bank	; 17 AcuMos SuperVGA
	dw	AL2101_bank	; 18 AL2101 SuperVGA
	dw	MXIC_bank	; 19 MXIC SuperVGA
	dw	P2000_bank	; 20 P2000 SuperVGA
	dw	RT3106_bank	; 21 RT3106 SuperVGA
	dw	CIRRUS_bank	; 22 Cirrus 5422 SuperVGA

_DATA	ENDS
_TEXT	SEGMENT


setbank	PROC	near
	jmp	[chipbank]

NONE_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	ret

VESA_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	push	ax
	push	bx
	push	dx
	mul	[VesaGran]	; Adjust with granularity factor
	push	ax
	mov	dx,ax		; Select window position
	xor	bx,bx		; BH := 0 (Select SVGA memory window)
				; BL := 0 (window to set)
	call	[VesaBank]	; Change bank A
	pop	dx		; Select window position
	inc	bx		; BL := 1 (window to set)
	call	[VesaBank]	; Change bank B
	pop	dx
	pop	bx
	pop	ax
	ret

ATI_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,0Fh		; Mask out bottom four bits
	mov	ah,al
	shl	ah,1		; Shift read bank into position
	shl	ah,1
	shl	ah,1
	shl	ah,1
	or	ah,al		; AH := combined read/write register numbers
	rol	ah,1		; Shift banks numbers in position
	mov	dx,1CEh		; Port of extended registers
	mov	al,0B2h
	out	dx,ax		; Set the ATI Bank Register
	pop	dx
	pop	ax
	sti
	ret

AHEADA_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	push	cx
	mov	ch,al
	mov	dx,03CCh	; bit 0 in bit 5 of Misc Output reg
	in	al,dx		; Read Misc output register
	mov	dl,0C2h
	and	al,11011111b
	shr	ch,1		; Need to set the bit?
	jnc	@@SkpA		; No, so skip it
	or	al,00100000b
@@SkpA:	out	dx,al		; Set the new value
	mov	dx,3CEh		; bits 3-1 in bits 2-0 of Segment Reg
	mov	al,0Dh		; Index 0Dh for segment reg
	mov	ah,ch		; ch contains top three bits shr 1
	out	dx,ax		; Set the new value
	pop	cx
	pop	dx
	pop	ax
	sti
	ret

AHEADB_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	ah,al		; Combine read/write bank numbers
	shl	ah,1
	shl	ah,1
	shl	ah,1
	shl	ah,1
	or	ah,al
	mov	al,0Dh		; Index of Bank Switch register
	mov	dx,3CEh
	out	dx,ax		; Set the register
	pop	dx
	pop	ax
	sti
	ret

CHIPS451_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	ah,al
	mov	al,0Bh		; Index of Single/Low Map register
	mov	dx,3D6h
	out	dx,ax		; Set the register value
	pop	dx
	pop	ax
	sti
	ret

CHIPS452_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	ah,al
	shl	ah,1		; Change 64k bank into 16k bank number
	shl	ah,1
	shl	ah,1		; *4 for 16 color modes
	shl	ah,1
	mov	al,10h		; Index of Single/Low Map register
	mov	dx,3D6h
	out	dx,ax		; Set the register value
	pop	dx
	pop	ax
	sti
	ret

CHIPS453_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	ah,al
	shl	ah,1		; Change 64k bank into 4k bank number
	shl	ah,1
	shl	ah,1
	shl	ah,1
	shl	ah,1		; *4 for 16 color modes
	shl	ah,1
	mov	al,10h		; Index of Single/Low Map register
	mov	dx,3D6h
	out	dx,ax		; Set the register value
	pop	dx
	pop	ax
	sti
	ret

EVEREX_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	push	cx
	mov	cl,al
	mov	dx,3C4h
	mov	al,8
	out	dx,al
	inc	dl
	in	al,dx
	dec	dl
	shl	al,1
	shr	cl,1
	rcr	al,1
	mov	ah,al
	mov	al,8
	out	dx,ax		; Bit 0 stored in 3C4 index 8 bit 7
	mov	dl,0CCh
	in	al,dx
	mov	dl,0C2h
	and	al,0DFh
	shr	cl,1
	jc	@@Nob2
	or	al,20h
@@Nob2:	out	dx,al		; Bit 1 stored in 3C2 bit 5
	pop	cx
	pop	dx
	pop	ax
	sti
	ret

GENOA_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	ah,al		; Put read bank in bits 2-0 ...
	shl	al,1		; ...  write bank in bits 5-3
	shl	al,1
	shl	al,1
	or	ah,al
	or	ah,40h		; Set MEM bit
	mov	al,6		; Index of Memory Segment Register
	mov	dx,3C4h
	out	dx,ax		; Set the read/write banks
	pop	dx
	pop	ax
	sti
	ret

OAK_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,15
	mov	ah,al		; Combine read/write bank numbers
	shl	al,1
	shl	al,1
	shl	al,1
	shl	al,1
	or	ah,al
	mov	al,11h		; Index of bank switch register
	mov	dx,3DEh
	out	dx,ax		; Set the register value
	pop	dx
	pop	ax
	sti
	ret

PARADISEPVGA_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3CEh
	shl	al,1		; change 64k bank into 4k bank number
	shl	al,1
	shl	al,1
	shl	al,1
	mov	ah,al
	mov	al,9		; Index of PROA register
	out	dx,ax		; Program PROA register
	pop	dx
	pop	ax
	sti
	ret

PARADISE_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3CEh
	shl	al,1		; change 64k bank into 4k bank number
	shl	al,1
	shl	al,1
	shl	al,1
	mov	ah,al
	mov	al,9		; Index of PROA register (read bank)
	out	dx,ax		; Program PROA register
	mov	al,0Ah		; Index of PROB register (write bank)
	out	dx,ax		; Program PROB register
	pop	dx
	pop	ax
	sti
	ret

TRIDENT_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	xor	al,2		; Adjust page bit
	mov	ah,al
	mov	dx,3C4h
	mov	al,0Bh		; Index of Chip Version register
	out	dx,al		; Program index
	inc	dl
	xor	al,al
	out	dx,al		; Force old definitions
	in	al,dx		; Force new definitions
	dec	dl
	mov	al,0Eh		; Index of New Mode Control Reg
	out	dx,ax		; Program the page value
	pop	dx
	pop	ax
	sti
	ret

NCR_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	shl	al,1		; Change 64k bank into 16k bank number
	shl	al,1
	mov	ah,al
	mov	al,18h
	mov	dx,3C4h
	out	dx,ax		; Set write bank number
	mov	al,1Ch
	out	dx,ax		; Set read bank number
	pop	dx
	pop	ax
	sti
	ret

VIDEO7_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	cx
	push	dx
	and	al,0Fh		; Mask to 4 bits
	mov	ch,al
	mov	dx,3C4h
	mov	ah,ch
	and	ah,1
	mov	al,0F9h		; Index of Extended Page Select register
	out	dx,ax		; Program PS bit in register
	mov	al,ch
	and	al,1100b	; Bits 3-2 for read field
	mov	ah,al
	shr	ah,1		; Bits 1-0 for write field
	shr	ah,1
	or	ah,al		; Combine two values
	mov	al,0F6h
	out	dx,al		; Index the bank select register
	inc	dl
	in	al,dx		; Read old value
	and	al,11110000b	; Zero out old bits
	or	al,ah		; Combine with new values
	out	dx,al		; Program the values
	mov	ah,ch
	and	ah,10b		; Mask out bit 2
	shl	ah,1		; Put into bit 5
	shl	ah,1
	shl	ah,1
	shl	ah,1
	mov	dx,3CCh		; Address Miscellaneous register
	in	al,dx		; Read old value
	and	al,0DFh		; Zero bit 5
	mov	dx,3C2h
	or	al,ah		; Or in the page bit
	out	dx,al		; Program the new value
	pop	dx
	pop	cx
	pop	ax
	sti
	ret

VIDEO7V5_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,0Fh		; Mask to 4 bits
	shl	al,1		; Shift into bits 7-4
	shl	al,1
	shl	al,1
	shl	al,1
	mov	ah,al
	mov	dx,3C4h
	mov	al,0E8h		; Index of write bank register
	out	dx,ax		; Program the write bank
	mov	al,0E9h		; Index of read bank register
	out	dx,ax		; Program the read bank
	pop	dx
	pop	ax
	sti
	ret

ET3000_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,7		; Mask out bottom 3 bits
	mov	ah,al		; Combine read and write bank values in al
	shl	ah,1
	shl	ah,1
	shl	ah,1
	or	al,ah
	or	al,40h		; Set bit 6 to select 64k segments
	mov	dx,3CDh		; Point to memory segment register
	out	dx,al		; Set the new bank value
	pop	dx
	pop	ax
	sti
	ret

ET4000_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,0Fh		; Mask out bottom 4 bits
	mov	ah,al		; Combine read and write values in al
	shl	ah,1
	shl	ah,1
	shl	ah,1
	shl	ah,1
	or	al,ah
	mov	dx,3CDh		; Point to memory segment register
	out	dx,al		; Set the new bank value
	pop	dx
	pop	ax
	sti
	ret

S3_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	pushf
	cli
	push	ax
	push	cx
	push	dx
	mov	dx,03D4h
	mov	ch,al		; Save value for later
	and	al,0Fh		; Mask off all but bottom 4 bits
	mov	cl,al
	mov	ax,04838h	; Enable extended registers
	out	dx,ax
	mov	al,31h		; Index of S3R1
	out	dx,al
	inc	dl
	in	al,dx		; Read value of S3R1
	or 	al,00001001b	; Set bits 0 and 3
	out	dx,al		; Write value back again
	dec	dl
	mov	al,35h		; Index of S3R5
	out	dx,al
	inc	dl
	in	al,dx		; Read value of S3R5
	and	al,0F0h		; Mask off low nybble
	or	al,cl		; Or in new bank number
	out	dx,al		; Write the value back again
	dec	dl
	cmp	VideoMem,1024
	jle	@@S32		; Only 1 meg
	mov	ax,0A039h	; Unlock system control registers
	out	dx,ax
	mov	al,51h		; Index of CR51
	out	dx,al
	inc	dl
	in	al,dx		; Read value of CR51
	mov	cl,0CH		; Mask out appropriate bits
	cmp	VideoMem,2048
	jg	@@S324		; more than 2MB
	mov	cl,04H		; Mask out appropriate bits
@@S324:
	shr	ch,1
	shr	ch,1
	and	ch,cl		; only use correct bits
	not	cl
	and	al,cl		; Clear old bits
	or	al,ch		; Or in top bits of bank number
	out	dx,al		; Write the value back again
	dec	dl
	mov	ax,0039h	; Lock system control registers
	out	dx,ax
@@S32:	mov	ax,0038h	; Disable extended registers
	out	dx,ax
	pop	dx
	pop	cx
	pop	ax
	popf
	ret

CIRRUS_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3CEh
	shl	al,1		; Convert to 4k bank number
	shl	al,1
	shl	al,1
	shl	al,1
	mov	ah,al
	mov	al,9
	out	dx,ax
	pop	dx
	pop	ax
	sti
	ret

ACUMOS_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3CEh
	shl	al,1		; Convert to 4k bank number
	shl	al,1
	shl	al,1
	shl	al,1
	mov	ah,al
	mov	al,9
	out	dx,ax
	pop	dx
	pop	ax
	sti
	ret

AL2101_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3D6h
	out	dx,al		; Set read bank register
	inc	dx
	out	dx,al		; Set write bank
	pop	dx
	pop	ax
	sti
	ret

MXIC_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	and	al,0Fh		; Mask out all but 4 bottom bits
	mov	ah,al		; Combine read/write bank numbers
	shl	al,1
	shl	al,1
	shl	al,1
	shl	al,1
	or	ah,al
	mov	al,0C5h		; Index of bank switch register
	mov	dx,3C4h
	out	dx,ax		; Set the register value
	pop	dx
	pop	ax
	sti
	ret

P2000_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3D6h
	out	dx,al		; Set write bank register
	inc	dx
	out	dx,al		; Set read bank
	pop	dx
	pop	ax
	sti
	ret

RT3106_bank:
	mov	[CurBank],ax	; Save the new bank number for later
	cli
	push	ax
	push	dx
	mov	dx,3D6h
	out	dx,al		; Set write bank register
	inc	dx
	out	dx,al		; Set read bank
	pop	dx
	pop	ax
	sti
	ret

setbank	ENDP
