#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "pktdrvr.h"

extern void INTERRUPT far pkint0 __ARGS((void));
extern void pkset (void (far *receiver)(), int far *stk);

typedef unsigned short ushort;

static int far
find_driver (void)
{
	int	i;

	for (i = 0x0060; i < 0x0080; ++i)
		if (test_for_pd (i))
			return (i);
	return (-1);
}

static int	rcvdev, rcv0, rcv1, lastrcv0, lastrcv1, lastcx;
static unsigned char far pktbuff[1024];

#if 0

extern void INTERRUPT far pkvec0 __ARGS((void));
extern int	near stack[2048] = {0};
extern int	near Stktop[1] = {0};		/* VERY compiler dependent */
extern void far
pkint (int dev, ushort di, ushort si, ushort bp, ushort dx, ushort cx,
	ushort bx, ushort ax, ushort ds, ushort es)
{
	unsigned char far *buffer = pktbuff;

	rcvdev = dev;			/* debug */

	switch (ax) {
	case 0:				/* Space allocate call */
		if (cx <= sizeof (pktbuff)) {
			es = FP_SEG (buffer);
			di = FP_OFF (buffer);
		} else
			es = di = 0;
		++rcv0;			/* debug */
		lastcx = cx;		/* debug */
		break;
	case 1:				/* Packet complete call */
		++rcv1;			/* debug */
		break;
	default:
		break;
	}
}
#endif

static int	col = 0;

static void far
receiver (int dev, ushort di, ushort si, ushort bp, ushort dx, ushort cx,
	ushort bx, ushort ax, ushort ds, ushort es)
{
	unsigned char far *buffer = pktbuff;
	int	t, tt;

	rcvdev = dev;			/* debug */

	switch (ax) {
	case 0:				/* Space allocate call */
		if (cx <= sizeof (pktbuff)) {
			es = FP_SEG (buffer);
			di = FP_OFF (buffer);
		} else
			es = di = 0;
		++rcv0;			/* debug */
		lastcx = cx;		/* debug */
		break;
	case 1:				/* Packet complete call */
		++rcv1;			/* debug */
		break;
	default:
		break;
	}
}

#define	STKSIZE	2048
static int	*stack = 0, handle = -1, pktint;

static void far
die (int n)
{
	int	rc;

	if (-1 != handle) {
		rc = release_type (pktint, handle);
		if (-1 == rc)
			printf ("release_type failed %d\n", Derr);
		else
			printf ("Handle released\n");
		handle = -1;
	}

	if (stack) {
		free (stack);
		stack = 0;
	}

	exit (n);
}

static struct epacket {
	char	to[6];
	char	from[6];
	char	type[2];
	char	len[2];
	char	data[256];
}	msg;

main ()
{
	int	i, ch, rc, msglen;
	int	version, class, type, number, basic;
	unsigned char	*name, address[16], addrname[16];

	pktint = find_driver ();
	if (-1 == pktint) {
		printf ("no driver\n");
		die (1);
	}
	printf ("Driver found at 0x%0x\n", pktint);


	if (!(stack = (int *)malloc (STKSIZE * sizeof (int)))) {
		printf ("malloc filed\n");
		die (1);
	}

	pkset (receiver, stack+STKSIZE);

	handle = access_type (pktint, CL_SERIAL_LINE, ANYTYPE, 0,
		(char far *)0, 0, pkint0 /*pkvec0*/);
	if (-1 == handle) {
		printf ("access_type failed %d\n", Derr);
		die (1);
	}
	printf ("Handle acquired: 0x%0x\n", handle);

	rc = driver_info (pktint, handle, &version, &class, &type, &number,
		&name, &basic);
	if (rc) {
		printf ("driver_info failed %0x\n", Derr);
		die (1);
	}
	printf ("Driver info:\n");
	printf ("  version 0x%0x\n", version);
	printf ("  class   0x%0x\n", class);
	printf ("  type    0x%0x\n", type);
	printf ("  number  0x%0x\n", number);
	printf ("  name    %s\n",    name);
	printf ("  basic   0x%0x\n", basic);

	rc = get_address (pktint, handle, address, sizeof (address));
	if (rc) {
		printf ("get_address failed %0x\n", Derr);
		goto ret;
	}
	sprintf (addrname, "%02x%02x%02x%02x%02x%02x",
		address[0], address[1], address[2],
		address[3], address[4], address[5]);
	printf ("My ethernet address is %s\n", addrname);


	memcpy (address, "\x12\x34\x56\x54\x32\x10", 6);
	rc = set_address (pktint, address, sizeof (address));
	if (rc) {
		printf ("set_address failed %0x\n", Derr);
		goto ret;
	}

	rc = get_address (pktint, handle, address, sizeof (address));
	if (rc) {
		printf ("get_address failed %0x\n", Derr);
		goto ret;
	}
	sprintf (addrname, "%02x%02x%02x%02x%02x%02x",
		address[0], address[1], address[2],
		address[3], address[4], address[5]);
	printf ("My new ethernet address is %s\n", addrname);

	memcpy (msg.from, address, 6);
	memcpy (msg.to,   "\x00\x00\x00\x12\x34\x56", 6);
	memcpy (msg.type, TYPE_IP, 2);
	memset (msg.data, 0x5a, sizeof (msg.data));	/* debug */
	strcpy (msg.data, "Hello from ");
	strcat (msg.data, addrname);
	msglen = 16 + strlen (msg.data);
	msg.len [0] = (char)(msglen >> 8);
	msg.len [1] = (char)(msglen);
	printf ("msg len %d \"%s\"\n", strlen (msg.data), msg.data);
	printf ("pkt len %d (0x%0x)\n", msglen, msglen);
	printf ("My message is");
	for (i = 0; i < msglen; ++i) {
		if (!(i%32))
			printf ("\n%04x", i);
		if (!(i%4))
			printf (" ");
		printf ("%02x", ((unsigned char *)&msg)[i]);
	}
	printf ("\n");
memcpy (msg.to, "123456abcdef123456ABCDEFxy", 14);
	for (;;) {
		if (kbhit()) {
			ch = getch ();
			if (0x1b == ch || 't'-'a'+1 == ch)
				break;
			rc = send_pkt (pktint, (char *)&msg, msglen);
			if (rc)
				printf ("pkt_send failed %0x\n", Derr);
			else
				printf ("Packet sent\n");
		}
		if (rcv0 != lastrcv0) {
			printf ("r0 %d len %d\n", rcv0, lastcx);
			lastrcv0 = rcv0;
		}
		if (rcv1 != lastrcv1) {
			printf ("r1 %d len %d", rcv1, lastcx);
			for (i = 0; i < lastcx; ++i) {
				if (!(i%32))
					printf ("\n%04x", i);
				if (!(i%4))
					printf (" ");
				printf ("%02x", pktbuff[i]);
			}
			printf ("\n");
			lastrcv1 = rcv1;
		}
	}

ret:
	if ('t'-'a'+1 == ch) {
		rc = terminate (pktint, handle);
		if (-1 == rc)
			printf ("terminate failed %d\n", Derr);
		else {
			printf ("Driver terminated\n");
			handle = -1;
		}
	}

	die (0);
}
