/* This is file GR.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <time.h>
#include <conio.h>

#include "vgr.h"

uint	near _ReadPage = 0;
uint	near _GrType = GRT_NONE;
uint	near _GrSizeX = 0;

uint	near _GrSizeY = 0;
uint	near _GrWriteMode = 0;
long	ActiveBase = 0;

#define	BADXY(x,y)	((x)<0 || (x)>_GrMaxX || (y)<0 || (y)>_GrMaxY)

#define	VIDEO_ADDR(x,y) \
	(((uint)((xy=(x)+ActiveBase+(y)*(long)_GrSizeX) >> 16) ==_ReadPage) \
	? (VGA_PAGE+(uint)xy) : _GrNewPage (xy))

static uint	_WritePage = 0;
static uint	_GrMaxX = 0;
static uint	_GrMaxY = 0;

static void far _GrCopyLine (int xf, int yf, int xt, int yt, int n);
static void far _GrLineGet (uchar *t, int xf, int yf, int n);
static void far _GrLinePut (int xt, int yt, int n, uchar *f);

extern void far
GrSetWriteMode (int mode)
{
	mode &= 0xff00;
	if (_GrWriteMode != mode) {
		_GrWriteMode = mode;
		_SetWM (mode);
	}
}

extern void far
GrSetXY (w, h)
int	w;
int	h;
{
	_GrSizeX = w;
	_GrSizeY = h;
	_GrMaxX = _GrSizeX-1;
	_GrMaxY = _GrSizeY-1;
}

extern void far
GrPlot (x, y, c)
int	x;
int	y;
int	c;
{
	ulong		xy;
	register uchar	far *a;

	if (BADXY (x, y))
		return;
	a = VIDEO_ADDR (x, y);
#if 0
	GrSetWriteMode (c);
#endif
	if (_GrWriteMode & GrXOR)
		*a ^= c;
	else if (_GrWriteMode & GrOR)
		*a |= c;
	else
		*a = c;
}

extern int far
GrPixel (x, y)
int	x;
int	y;
{
	ulong		xy;

	if (BADXY (x, y))
		return (0);
	 return (*VIDEO_ADDR (x, y));
}

extern void far
GrPlot3d (x, y, c)
int	x;
int	y;
int	c;
{
	ulong		xy;
	register uchar far *a;

	if (BADXY (x, y))
		return;
	a = VIDEO_ADDR (x, y);
	if ((*a < c) || (c < 0xc0))
		*a = c;
}

extern int far
GrMaxX ()
{
	return (_GrMaxX);
}

extern int far
GrMaxY ()
{
	return (_GrMaxY);
}

extern int far
GrSizeX ()
{
	return (_GrSizeX);
}

extern int far
GrSizeY ()
{
	return (_GrSizeY);
}

static void far
_GrCopyLine (xf, yf, xt, yt, n)
int	xf;
int	yf;
int	xt;
int	yt;
int	n;
{
	int	p, pt, pf;
	uchar	far *at, far *af;

	at = _GrAddr (xt, yt, _GrSizeX);
	pt = _GrGetPage ();
	_GrAddr (xt+n-1, yt, _GrSizeX);
	if (pt == _GrGetPage ()) {
		af = _GrAddr (xf, yf, _GrSizeX);
		pf = _GrGetPage ();
		_GrAddr (xf+n-1, yf, _GrSizeX);
		if (pf == _GrGetPage ()) {
			_GrSetPage (pf,pt);
#ifdef	MYMEM
			vgamov ((uint)(ulong)at, (uint)(ulong)af, n);
#else
			memmove (at, af, n);
#endif
			return;
		}
	}
	while (n-- > 0)
		GrPlot (xt++, yt, GrPixel (xf++, yf));
}

extern void far
GrCopy (xf, yf, xt, yt, w, h)
int	xf;
int	yf;
int	xt;
int	yt;
int	w;
int	h;
{
	if (w <= 0 || h <= 0 ||
	    xf+w > _GrSizeX || xf < 0 || yf+h > _GrSizeY || yf < 0 ||
	    xt+w > _GrSizeX || xt < 0 || yt+h > _GrSizeY || yt < 0)
		return;

	if (yt > yf) {			/* move down */
		for (yf += h-1, yt += h-1; h > 0; --h, --yf, --yt)
			_GrCopyLine (xf, yf, xt, yt, w);
	} else {			/* move up */
		for (; h > 0; --h, ++yf, ++yt)
			_GrCopyLine (xf, yf, xt, yt, w);
	}
}

extern void far
GrClear (x, y, w, h, c)
int	x;
int	y;
int	w;
int	h;
uint	c;
{
	int	p, pt, n, xt;
	uchar	far *at;

	if (w <= 0 || h <= 0 ||
	    x+w > _GrSizeX || x < 0 || y+h > _GrSizeY || y < 0)
		return;

	for (; h > 0; --h, ++y) {
		at = _GrAddr (x, y, _GrSizeX);
		pt = _GrGetPage ();
		_GrAddr (x+w-1, y, _GrSizeX);
		if (pt == _GrGetPage ()) {
#ifdef	MYMEM
			vgaset ((uint)(ulong)at, c, w);
#else
			memset (at, c, w);
#endif
			continue;
		}
		for (xt = x, n = w; n-- > 0;)
			GrPlot (xt++, y, c);
	}
}

extern void far
GrMove (xf, yf, xt, yt, w, h, c)
int	xf;
int	yf;
int	xt;
int	yt;
int	w;
int	h;
uint	c;
{
	GrCopy (xf, yf, xt, yt, w, h);
	GrClear (xt, yt, w, h, c);	/* todo: handle overlap */
}

static void far
_GrLineGet (t, xf, yf, n)
uchar	*t;
int	xf;
int	yf;
int	n;
{
	int	p, pf;
	uchar	far *af;

	af = _GrAddr (xf, yf, _GrSizeX);
	pf = _GrGetPage ();
	_GrAddr (xf+n-1, yf, _GrSizeX);
	if (pf == _GrGetPage ()) {
#ifdef	MYMEM
		vgaget (t, (uint)(ulong)af, n);
#else
		memmove (t, af, n);
#endif
		return;
	}
	while (n-- > 0)
		*t++ = GrPixel (xf++, yf);
}

static void far
_GrLinePut (xt, yt, n, f)
int	xt;
int	yt;
int	n;
uchar	*f;
{
	int	p, pt;
	uchar	far *at;

	at = _GrAddr (xt, yt, _GrSizeX);
	pt = _GrGetPage ();
	_GrAddr (xt+n-1, yt, _GrSizeX);
	if (pt == _GrGetPage ()) {
#ifdef	MYMEM 
		vgaput ((uint)(ulong)at, f, n);
#else
		memmove (at, f, n);
#endif
		return;
	}
	while (n-- > 0)
		GrPlot (xt++, yt, *f++);
}

extern void far
GrMemGet (p, xf, yf, w, h)
uchar	*p;
int	xf;
int	yf;
int	w;
int	h;
{
	if (w <= 0 || h <= 0 ||
	    xf+w > _GrSizeX || xf < 0 || yf+h > _GrSizeY || yf < 0)
		return;

	for (; h-- > 0; p += w)
		_GrLineGet (p, xf, yf++, w);
}

extern void far
GrMemPut (xt, yt, w, h, p)
int	xt;
int	yt;
int	w;
int	h;
uchar	*p;
{
	if (w <= 0 || h <= 0 ||
	    xt+w > _GrSizeX || xt < 0 || yt+h > _GrSizeY || yt < 0)
		return;

	for (; h-- > 0; p += w)
		_GrLinePut (xt, yt++, w, p);
}

extern void far
GrSetType (uint type, uint nbanks, uint width)
{
	_GrType = type & GRT_MASK;
	_SetCH (_GrType, nbanks, width);
}

extern int far
GrSetBiosMode (n)
int	n;
{
	REGISTERS	regs;

	if (n >= 0x100) {
		regs.ax = 0x4f02;
		regs.bx = n;
	} else
		regs.ax = n;
	return (int10 (&regs));
}

extern void far _fastcall
_GrSetPage (pread, pwrite)
int	pread;
int	pwrite;
{
	_SetPG (pread);

	_ReadPage = pread;
	_WritePage = pwrite;
}

extern uint far _fastcall
_GrGetPage ()
{
	return (_ReadPage);
}

extern uchar far * far _fastcall
_GrAddr (x, y, width)
uint	x;
uint	y;
uint	width;
{
	ulong	xy;
	uint	page;

	page = (uint)((xy = x + ActiveBase + y*(long)width) >> 16);
#if 0
	if (page > 0x0f)
		return VGA_PAGE;
#endif
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

extern uchar far * far _fastcall
_GrNewPage (xy)
ulong	xy;
{
	uint	page;

	page = (uint)(xy >> 16);
	if (page != _ReadPage)
		_GrSetPage (page, page);

	return (VGA_PAGE + (uint)xy);
}

static short far
_Disable (void)
{
	short	flags;

	_asm {
		pushf
		pop	flags
		cli
	}
	return (flags);
}

static void far
_Enable (short flags)
{
	_asm {
		push	flags
		popf
	}
}

extern void far _fastcall
_GrSetColor (color, r, g, b)
int	color;
int	r;
int	g;
int	b;
{
	short	flags;

	flags = _Disable ();
	outp (0x3c8, color);	(void)inp (0x080);
	outp (0x3c9, r >> 2);	(void)inp (0x080);
	outp (0x3c9, g >> 2);	(void)inp (0x080);
	outp (0x3c9, b >> 2);
	_Enable (flags);
}

extern void far
GrSetActive (long base)
{
	ActiveBase = base;
}

extern void far
GrSetVisual (long base)
{
	_SetVS (base);
}

extern int far
GrVsync (void)
{
	time_t	i;

	i = time (0) + 2;
	while (inp (0x3da) & 0x08)	/* wait for end Vsync */
		if (i == time (0))
			return (1);	/* timed out */
	while (!(inp (0x3da) & 0x08))	/* wait for start Vsync */
		if (i == time (0))
			return (1);	/* timed out */
	return (0);
}
