#ifndef	CL_ETHERNET

#define	__ARGS(x)	x
#define	INTERRUPT	interrupt
#define	int32		long

/* Packet driver interface classes */
#define	CL_NONE		0
#define	CL_ETHERNET	1
#define	CL_PRONET_10	2
#define	CL_IEEE8025	3
#define	CL_OMNINET	4
#define	CL_APPLETALK	5
#define	CL_SERIAL_LINE	6
#define	CL_STARLAN	7
#define	CL_ARCNET	8
#define	CL_AX25		9
#define	CL_KISS		10
#define CL_IEEE8023	11
#define CL_FDDI 	12
#define CL_INTERNET_X25 13
#define CL_LANSTAR	14
#define CL_SLFP 	15
#define	CL_NETROM	16
#define NCLASS		17

/* Packet driver interface types (not a complete list) */
#define	TC500		1
#define	PC2000		10
#define	WD8003		14
#define	PC8250		15
#define	ANYTYPE		0xffff

/* Packet driver function call numbers. From Appendix B. */
#define	DRIVER_INFO		1
#define	ACCESS_TYPE		2
#define	RELEASE_TYPE		3
#define	SEND_PKT		4
#define	TERMINATE		5
#define	GET_ADDRESS		6
#define	RESET_INTERFACE		7
#define GET_PARAMETERS		10
#define AS_SEND_PKT		11
#define	SET_RCV_MODE		20
#define	GET_RCV_MODE		21
#define	SET_MULTICAST_LIST	22
#define	GET_MULTICAST_LIST	23
#define	GET_STATISTICS		24
#define SET_ADDRESS		25

/* Packet driver error return codes. From Appendix C. */

#define	NO_ERROR	0
#define	BAD_HANDLE	1	/* invalid handle number */
#define	NO_CLASS	2	/* no interfaces of specified class found */
#define	NO_TYPE		3	/* no interfaces of specified type found */
#define	NO_NUMBER	4	/* no interfaces of specified number found */
#define	BAD_TYPE	5	/* bad packet type specified */
#define	NO_MULTICAST	6	/* this interface does not support multicast */
#define	CANT_TERMINATE	7	/* this packet driver cannot terminate */
#define	BAD_MODE	8	/* an invalid receiver mode was specified */
#define	NO_SPACE	9	/* operation failed because of insufficient space */
#define	TYPE_INUSE	10	/* the type had previously been accessed, and not released */
#define	BAD_COMMAND	11	/* the command was out of range, or not	implemented */
#define	CANT_SEND	12	/* the packet couldn't be sent (usually	hardware error) */
#define CANT_SET	13	/* hardware address couldn't be changed (> 1 handle open) */
#define BAD_ADDRESS	14	/* hardware address has bad length or format */
#define CANT_RESET	15	/* couldn't reset interface (> 1 handle open) */

#define	CARRY_FLAG	0x1

#define	TYPE_IP		"\x08\x00"
#define	TYPE_ARP	"\x08\x06"

struct param {
	unsigned char	major_rev;	/* Revision of Packet Driver spec */
	unsigned char	minor_rev;	/*  this driver conforms to. */
	unsigned char	length;         /* Length of structure in bytes */
	unsigned char	addr_len;	/* Length of a MAC-layer address */
	unsigned short	mtu;		/* MTU, including MAC headers */
	unsigned short	multicast_aval; /* Buffer size for multicast addr */
	unsigned short	rcv_bufs;	/* (# of back-to-back MTU rcvs) - 1 */
	unsigned short	xmt_bufs;	/* (# of successive xmits) - 1 */
	unsigned short	int_num;	/* Interrupt # to hook for post-EOI
					   processing, 0 == none */
};

struct statistics {
	unsigned long	packets_in;	/* Totals across all handles */
	unsigned long	packets_out;
	unsigned long	bytes_in;	/* Including MAC headers */
	unsigned long	bytes_out;
	unsigned long	errors_in;	/* Totals across all error types */
	unsigned long	errors_out;
	unsigned long	packets_lost;	/* No buffer from receiver(), card */
					/*  out of resources, etc. */
};

/* In pktdrvr.c: */

extern int	Derr;

extern int far	test_for_pd __ARGS((unsigned int intno));

extern int far	driver_info __ARGS((int intno, int handle, int *version,
		int *class, int *type, int *number, char **name, int *basic));
extern int far	access_type __ARGS((int intno, int if_class, int if_type,
		int if_number, char far *type, unsigned typelen,
		void (INTERRUPT far *receiver) __ARGS((void))));
extern int far	release_type __ARGS((int intno, int handle));
extern int far	send_pkt __ARGS((int intno, char *buffer, unsigned length));
extern int far	terminate __ARGS((int intno, int handle));
extern int far	get_address __ARGS((int intno, int handle, char *buf, int len));
extern int far	reset_interface __ARGS((int intno, int handle));
extern int far	get_parameters __ARGS((int intno, struct param **params));
extern int far	set_address __ARGS((int intno, char *addr, int len));
extern int far	get_statistics __ARGS((int intno, int handle,
		struct statistics **addr));
extern int far	as_send_pkt __ARGS((int intno, char far *buffer,
		unsigned length, void (INTERRUPT *upcall) __ARGS((void))));

/* in pkint.asm */

extern void pkset (void (far *receiver)(), int far *stk);

extern void INTERRUPT far pkint0 (void);
extern void INTERRUPT far pkint1 (void);
extern void INTERRUPT far pkint2 (void);
extern void INTERRUPT far pkint3 (void);

extern void INTERRUPT far pksende (void);
extern void INTERRUPT far pksends (void);

#endif	/* CL_ETHERNET */
