/*  ARC - Archive utility - ARCDIR

    Version 1.02, created on 02/04/86 at 01:36:09

(C) COPYRIGHT 1985 by System Enhancement Associates; ALL RIGHTS RESERVED

    By:  Thom Henderson

    Description:
         This file contains the dir() routine used when adding files to an
         archive.  It is an adaptation of the CI-C86 library function
         filedir().  It differes in that it returns the file names one by
         one, instead of all at once.

    Language:
         Computer Innovations Optimizing C86
*/
#include <stdio.h>

static struct
{   char dummy[21];                    /* reserved for dos */
    unsigned char attribute;           /* returned attribute */
    unsigned time;
    unsigned date;
    long size;                         /* size of file */
    unsigned char fn[13];              /* string containing the filename */
}   ff_area;

char *dir(filename,mode)               /* get files, one by one */
char *filename;                        /* template, or NULL */
int mode;                              /* search mode bits */
{
    struct { int ax,bx,cx,dx,si,di,ds,es; } reg;
    char *result, *alloc();
    static int first = 1;              /* true only on first call */

#ifdef _C86_BIG
    reg.ds = ((unsigned long)filename) >> 16;
#else
    segread(&reg.si);                  /* get ds value */
#endif
    if(filename)                       /* if filename is given */
    {    reg.dx = filename;            /* then use it */
         reg.ax = 0x4e00;              /* and search for first */
    }
    else if(first)                     /* if no name and first call */
         return NULL;                  /* then not much we can do */
    else reg.ax = 0x4f00;              /* else search for next */
    first = 0;                         /* no longer first time */

    reg.cx = mode;                     /* set search modes */
    bdos(0x1a,&ff_area);               /* set the transfer address */

    if(sysint21(&reg,&reg)&1)
         return NULL;                  /* no more files */

    result = alloc(strlen(ff_area.fn)+1);
    strcpy(result,ff_area.fn);         /* save name of file */
    return result;
}
