;CRC calculation
;(C) Copyright 1987 Rahul Dhesi, All Rights Reserved

public	_addbfcrc

dgroup	group	_data
	assume ds:dgroup,es:nothing
_data	segment word public 'data'
extrn	_crccode:word
extrn	_crctab:word
_data	ends

;Declare Segments
_text	segment byte public 'code'
	assume cs:_text,ds:dgroup

_addbfcrc proc near

	push	bp
	mov	bp,sp
	push	di
	push	si

	mov	ah,0bh
	int	21h			;check console status & process ^C

	mov	ax,_crccode			;crccode
	mov	di,[bp+4]			;buffer address
	mov	cx,[bp+6]			;byte count

	jcxz	zero_trip		;zero-trip loop
loop:
	sub	bh,bh
	mov	bl,al
	xor	bl,ds:[di]		;now bx = (crccode xor c) & 0x00ff
	shl	bx,1			;double bx (because items are 2 bytes)

	mov	dx,word ptr _crctab[bx]	;dx = exp2

	sub	bh,bh
	mov	bl,ah			;bx <- exp1

	xor	bx,dx			;bx <- exp1 xor exp2
	mov	ax,bx			;crccode <- exp1 xor exp2
	inc	di			;inc buffer pointer
	loop	loop			;dec CX, jump if not zero

done:
	mov	_crccode,ax

zero_trip:
	pop	si
	pop	di
	mov	sp,bp
	pop	bp
	ret
_addbfcrc 	endp

_text	ends

	end
