

1
// This file will help you learn to use CC.
1

1
// Lines following // are called COMMENTS and
1
// are ignored by CC.  Comments can be used to
1
// annotate your calculations.
1

1
// As you read this file, place the cursor on
1
// each line and push <Enter>.  That will cause
1
// the line to be executed, so you will be able
1
// to see what it does.
1

1
2+3   // execute this line
1

1
// If you executed 2+3, you saw 5 as the ANSwer
1
// and the Last Result.  Enter your own formula
1
// on the blank line below and execute it.
1

1

1

1
// Anytime you want to interrupt this lesson to
1
// try a function of your own, just push 
1
// function key F3 a few times to open up empty
1
// lines in the window.  Try pushing F3 now.
1
// To erase a line, put the cursor on it and
1
// press Shift-F4.
1

1
// You can use transcendental functions with CC
1
// Try the following lines:
1

1
3.6^2.1   // ^ means exponentiation
1
Sin(2.4)
1
Exp(-30)  // very large and small numbers are  
1
           represented in exponential notation
2
ln(1.3)   // natural logarithm
1
sin(3.4)-4*ln(2.7)   //* means multiply
1
sqrt(18.27)   // sqrt means square root
1

1
// CC includes an on-line help facility.  To 
1
// read about CC's functions, press function 
1
// key F1 and choose topic H.
1
// Push <ESC> to leave Help and return here.
1

1
// CC can calculate with complex numbers.  If
1
// you are interested in complex math, try the
1
// following lines.
1

1
(1+)/(3-4)  // enter =sqrt(-1) with alt-i
1
exp(3+4)
1
Asin(3)    // real argument, complex result
1
Ln(-1)
1

1
// You can assign the result of a calculation
1
// to a variable.  Watch the Output window as
1
// you execute these lines:
1

1
a = 4
1
b = (3.2 - 5.4)/2.1
1
c = a-3 //variables can be used in calculations
1

1
// Test yourself -- answers at end of file
1
// 1.  Find the hypotenuse of a right triangle 
1
      with legs of length 3.8 and 7.2.
2

1

1
// 2.  What is the final balance if $5000 is   
1
      invested at 7% for 8 years
2

1

1
// You can also define functions with CC, which
1
// can be evaluated, graphed, integrated,
1
// differentiated, and solved for roots.
1

1
f(x) = x^2 + sin(x)  // execute this line to   
1
                       define f(x)
2

1
y = f(2)
1
z = 3+f(sin(y))
1

1
// There are now more variables defined than
1
// can be shown.  Use function keys F5 and F6
1
// to scroll the output window.
1

1
// Now we will graph f(x).  Push <Enter> when  
1
  you wish to stop viewing the graph and      
2
  return to this screen.
3

1
graph(f(x),x)
1

1
// To see more or less of the curve, you can 
1
// alter the viewing window with the WINDOW
1
// command.  The syntax is 
1
//    WINDOW(xmin, xmax, ymin, ymax)
1

1
Window(-3,3,-.5,10)
1
Graph(f(x),x)
1

1
// Compare to curve y = x^2
1

1
Graph(x^2,x)
1

1
// You can graph any expression like f(x) or
1
// x^2 or even x^2*f(x).  
1
// You can display as many curves as you want 
1
// on one graph.  To erase the graph and start
1
// over, enter the command ERASE or resize the
1
// window with WINDOW.
1

1
// Read more about graphing in the help file.
1

1
// To differentiate the function f(x) at x=3,  
1
  i.e. to calculate f'(3), enter the command
2

1
d1 = dif(f(x),x=3)
1

1
// You can also differentiate an expression
1

1
d2 = dif(x^2+sin(x),x=3)   // will equal d1
1

1
// You can define one function to be the       
1
  derivative of another
2

1
g(x) = dif(f(x),x)
1
window(-1,1,-1,3)
1
graph(f(x),x)
1
graph(g(x),x)
1
Write@(0.6,0.85,'F(x)')  // graphs can be 
1
Write@(0.5,1.75,'dF/dx') // labeled
1

1
// To see the symbolic derivative of f(x),     
1
  differentiate f(x) with respect to an       
2
  undefined variable name.
3

1
df = dif(f(w),w)
1

1
// To find where the graph of x^2+sin(x)       
1
  crosses the x-axis, we solve the equation   
2
  f(p) = 0
3

1
Solve(f(p)=0, p=-1)   // p=-1 is first guess
1

1
// Recall what the graph of f(x) looks like by 
1
  pressing function key F9 to review the last 
2
  graph.  To find the area between the graph  
3
  of f(x) and the x-axis, we integrate f(x)   
4
  between p (where the graph crosses the x-   
5
  axis) and 0. 
6
// This would not be possible without first    
1
  solving for p.
2

1
Area := -IN(f(x),x=p to 0)
1

1
// CC includes a version of the integration    
1
  operator, INTEG, that shows a graph of the  
2
  area being integrated.  It returns the same 
3
  answer as the ordinary integration operator 
4
  IN.
5

1
Area = -INTEG(f(x),x=p to 0)
1

1
// CC will graph parametric and polar equations
1
  It will also graph surfaces in three dimen- 
2
  sions.  You can read about all these opera- 
3
  tions in the help file.  Here's an example  
4
  of 3D graphing.
5

1
Graph3d(2x^2-y^2, x=-1,1, y=-1,1, -1,2, 15)
1

1
// You can change the shading of 3d graphs by  
1
  pressing the keys 1 (opaque--what you see   
2
  first), 2 (striped), 3 (striped the other   
3
  way), 4 (transparent).  Press F9 to recall  
4
  the last graph, then press the number keys  
5
  to change its shading.
6

1
// You can also rotate the 3d graph on the     
1
  screen by pressing the keys x, X, y, Y, z, Z
2

1
// Test yourself
1
// 3.  Graph the curve cos(x)-x.  Find the     
1
      intersections of this curve with the x- 
2
      axis, the area between the curve and the
3
      x-axis, and the slope of the curve where
4
      it crosses the x-axis.
5

1

1

1

1
// 4.  Find the first three points to the right
1
      of the y-axis where the line y = x meets
2
      the graph of y = tan(x).
3

1

1

1

1
// If you aren't interested in vectors, skip   
1
  the next section.  CC3 will do vector arith-
2
  metic and other operations with arrays and  
3
  lists.  Note that if you define
4

1
v = (3, 5, 6)   // execute this line
1

1
// v is displayed in the output window as three
1
  parts: v[1], v[1], v[3].
2
// Let's do some vector arithmetic.
1

1
w = (4, 6, 3)
1

1
u = v+w
1

1
u = 5*v
1

1
u = v^2
1

1
u = v*w  
1

1
// CC is not just a calculator.  It is also a  
1
  programming environment.   Push function key
2
  F10 to view the "Scratchpad", where CC's    
3
  programs are written, then push F10 again to
4
  return to this screen.
5

1
// Now that you have viewed the Scratchpad,    
1
  execute the function PC(x,n)
2

1
a1=PC(1,10)    // approximate solution
1
a2 = sin(1)    // exact solution
1

1
a3 = PC(1,20)  // better approximation
1
a4 = PC(1,100) // excellent approximation
1

1
// The algorithm fails for x > 1.5 because CC
1
// always computes positive square roots.
1

1
// The manual has many more examples of using  
1
  programming with CC.
2

1
// These notes have not mentioned the          
1
  constructors SUM, PRODUCT, and LIST; CC's   
2
  statistical features; symbolic calculations;
3
  saving work with disk and printer; or       
4
  advanced programming techniques.
5
// All these points are explained in the manual
1

1
// *** Answers to Test Yourself ***
1

1
Ans1 = sqrt(3.8^2 + 7.2^2)
1

1
Ans2 = 5000*(1.07)^8
1

1
// Ans3
1
f(x) = cos(x)-x
1
window(0,1,-1,1)
1
graph(f(x),x)
1
solve(f(p)=0,p=1)       // curve crosses x-axis
1
Ans3_1 = in(f(x),x=0,p)  // area
1
Ans3_2 = d(f(x),x=p)     // slope
1

1
// Ans4
1
window(0,12,0,12)
1
graph(tan(x),x)
1
graph(x,x)
1
// using the crosshairs, we see that the x-    
1
  coordinates of the intersections are approx-
2
  imately 4.504, 7.735, 10.893
3
solve(Tan(x)=x, x=4.505)
1
Ans4_1 = x
1
solve(tan(x)=x, x=7.735)
1
Ans4_2 = x
1
solve(tan(x)=x, x=10.893)
1
Ans4_3 = x
1


1

1
// This is CC's Scratchpad, where you can write programs using CC's features.
1

1
// One warning.  If you push <Enter> while in the Scratchpad, you will split
1
// the line you are on at the cursor and push the lines below the cursor down
1
// one line.  To avoid rearranging the lines in the Scratchpad, use the up-
1
// and down-arrow keys to move the cursor around the Scratchpad.
1

1
// Below is a sample program that uses the predictor-corrector method to
1
// compute the solution to the differential equation:
1

1
//              y'(t) = sqrt(1-y(t)^2)
1
//              y(0) = 0
1

1
// Of course, the exact solution is y(t) = sin(t).  To execute this program,
1
// push function key F10 to return to the calculator window and follow the
1
// instructions there.
1

1

1
Function PC(x,n)
1
// use n-step predictor corrector method to solve the initial value problem  
1
  above and return the estimated value for y(x).
2
  dt = x/n             // use n steps between 0 and x
1
  t = 0                // starting value for t
1
  y = 0                // initial value for y
1
  f(y) = sqrt(1-y^2)   // f(y) is slope of y(t) 
1
  for j = 1 to n do
1
      slope1 = f(y)    
1
      y1 = y + slope1*dt   // first estimate for next value of y
1
      slope2 = f(y1)
1
      avgslope = (slope1+slope2)/2
1
      y = y+avgslope*dt    // corrected estimate for next value of y
1
    end
1
  return(y)
1
end      
1

