/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.event.popup;

import java.awt.Point;
import org.nakedobjects.basicgui.event.popup.MenuOptionTarget;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.UsesViewer;

public abstract class MenuOption {
    private String name;
    private int type;
    public static final int COMPONENT = 0;
    public static final int VIEW = 1;
    public static final int OBJECT = 2;
    public static final int EXPLORATION = 3;
    public static final boolean VETO = true;
    public static final boolean ALLOW = false;

    public MenuOption() {
        this("", 1);
    }

    public MenuOption(String string, int n) {
        this.name = string;
        this.type = n;
    }

    public abstract void action(MenuOptionTarget var1, Point var2);

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void runAction(final MenuOptionTarget menuOptionTarget, final Point point) {
        if (menuOptionTarget instanceof Display) {
            new Thread(new Runnable(){
                ObjectViewer viewer;
                {
                    this.viewer = ((UsesViewer)((Object)menuOptionTarget)).getViewer();
                }

                public void run() {
                    this.viewer.setActive(true);
                    MenuOption.this.action(menuOptionTarget, point);
                    this.viewer.setActive(false);
                }
            }, "menu action").start();
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "Component";
                break;
            }
            case 1: {
                string = "View";
                break;
            }
            case 2: {
                string = "Object";
                break;
            }
            case 3: {
                string = "Debug";
                break;
            }
            default: {
                string = "Other";
            }
        }
        String string2 = this.getClass().getName();
        return "name=" + string2.substring(string2.lastIndexOf(46) + 1) + ",type=" + string;
    }

    public boolean veto(MenuOptionTarget menuOptionTarget) {
        return false;
    }
}

