/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.distribution.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.apache.log4j.Category;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.UpdateNotifier;
import org.nakedobjects.object.distribution.UpdateMessage;
import org.nakedobjects.object.distribution.UpdateMessageBuilder;
import org.nakedobjects.object.distribution.UpdateMessageException;
import org.nakedobjects.utility.ConfigurationParameters;

public class UDPUpdateNotifier
implements UpdateNotifier {
    public static final String ADDRESS = "nakedobjects.udp-updates.group";
    public static final String PORT = "nakedobjects.udp-updates.port";
    public static final String PACKAGE_SIZE = "nakedobjects.udp-updates.size";
    public static final String TTL = "nakedobjects.udp-updates.ttl";
    public static final String DEFAULT_ADDRESS = "225.5.2.2";
    public static final int DEFAULT_PORT = 6561;
    public static final int DEFAULT_TTL = 4;
    public static final int DEFAULT_PACKAGE_SIZE = 8192;
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$distribution$simple$UDPUpdateNotifier == null ? (class$org$nakedobjects$distribution$simple$UDPUpdateNotifier = UDPUpdateNotifier.class$("org.nakedobjects.distribution.simple.UDPUpdateNotifier")) : class$org$nakedobjects$distribution$simple$UDPUpdateNotifier));
    private MulticastSocket mcs;
    private InetAddress multicastAddress;
    private int port;
    private int packageSize;
    private UpdateMessageBuilder builder;
    static /* synthetic */ Class class$org$nakedobjects$distribution$simple$UDPUpdateNotifier;

    public UDPUpdateNotifier() {
        try {
            String string = ConfigurationParameters.getInstance().getString(ADDRESS, DEFAULT_ADDRESS);
            this.multicastAddress = InetAddress.getByName(string);
            this.port = ConfigurationParameters.getInstance().getInteger(PORT, 6561);
            this.packageSize = ConfigurationParameters.getInstance().getInteger(PACKAGE_SIZE, 8192);
            int n = ConfigurationParameters.getInstance().getInteger(TTL, 4);
            LOG.info((Object)("Multicast settings: group=" + string + ", port=" + this.port + ", ttl=" + n));
            LOG.debug((Object)("Mulitcast to be sent to " + this.multicastAddress));
            this.mcs = new MulticastSocket(this.port);
            this.mcs.setTimeToLive(n);
            this.builder = new UpdateMessageBuilder();
        }
        catch (SocketException socketException) {
            LOG.fatal((Object)"Failed to set up multicast socket", (Throwable)socketException);
            System.exit(0);
        }
        catch (IOException iOException) {
            LOG.error((Object)"Failed to set up multicast socket", (Throwable)iOException);
            System.exit(0);
        }
    }

    private void broadcast(UpdateMessage updateMessage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(updateMessage);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.multicastAddress, this.port);
            if (byArray.length > this.packageSize) {
                LOG.warn((Object)"UDP package is greater than expected package size");
            }
            this.mcs.send(datagramPacket);
            LOG.debug((Object)("Update message sent: " + updateMessage + " " + datagramPacket.getLength() + " bytes"));
        }
        catch (IOException iOException) {
            LOG.error((Object)this, (Throwable)iOException);
        }
    }

    public void broadcastAdd(NakedCollection nakedCollection, NakedObject nakedObject) {
        try {
            this.broadcast(this.builder.createAddMessage(nakedCollection, nakedObject));
        }
        catch (UpdateMessageException updateMessageException) {
            LOG.error((Object)this, (Throwable)updateMessageException);
        }
    }

    public void broadcastObject(NakedObject nakedObject) {
        try {
            this.broadcast(this.builder.createObjectMessage(nakedObject));
        }
        catch (UpdateMessageException updateMessageException) {
            LOG.error((Object)this, (Throwable)updateMessageException);
        }
    }

    public void broadcastRemove(NakedCollection nakedCollection, NakedObject nakedObject) {
        try {
            this.broadcast(this.builder.createRemoveMessage(nakedCollection, nakedObject));
        }
        catch (UpdateMessageException updateMessageException) {
            LOG.error((Object)this, (Throwable)updateMessageException);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public String toString() {
        return "UPD Update Notifier dispatching on " + this.multicastAddress.getHostName() + "/" + this.getPort();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

