/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.AbstractObjectStore;
import org.nakedobjects.object.AggregateOid;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.NonPersistentObjectException;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.SimpleOid;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.utility.NotImplementedException;

public class TransientObjectStore
extends AbstractObjectStore {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$TransientObjectStore == null ? (class$org$nakedobjects$object$TransientObjectStore = TransientObjectStore.class$("org.nakedobjects.object.TransientObjectStore")) : class$org$nakedobjects$object$TransientObjectStore));
    private final Hashtable serials = new Hashtable();
    private long nextId;
    private Vector persistentObjectVector = new Vector();
    static /* synthetic */ Class class$org$nakedobjects$object$TransientObjectStore;

    public boolean isFirstElement(NakedCollection nakedCollection, NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        Vector vector = this.getCollectionElements(nakedCollection);
        return vector.size() > 0 && vector.firstElement().equals(nakedObject);
    }

    public boolean isFirstInstance(NakedObject nakedObject, NakedObject nakedObject2) throws NonPersistentObjectException {
        if (!nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        Enumeration enumeration = this.elements();
        NakedClass nakedClass = nakedObject.getNakedClass();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!nakedClass.equals(data.type) || !this.matchesPattern(nakedObject, data)) continue;
            return data.oid.equals(nakedObject2.getOid());
        }
        return false;
    }

    public boolean isLastElement(NakedCollection nakedCollection, NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        Vector vector = this.getCollectionElements(nakedCollection);
        return vector.size() > 0 && vector.lastElement().equals(nakedObject);
    }

    public boolean isLastInstance(NakedObject nakedObject, NakedObject nakedObject2) throws NonPersistentObjectException {
        if (!nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        Enumeration enumeration = this.elements();
        NakedClass nakedClass = nakedObject.getNakedClass();
        Data data = null;
        while (enumeration.hasMoreElements()) {
            Data data2 = (Data)enumeration.nextElement();
            if (!nakedClass.equals(data2.type) || !this.matchesPattern(nakedObject, data2)) continue;
            data = data2;
        }
        return data != null && data.oid.equals(nakedObject2.getOid());
    }

    private boolean matchesPattern(NakedObject nakedObject, Data data) {
        try {
            NakedObject nakedObject2 = this.getObject(data.oid);
            NakedClass nakedClass = nakedObject2.getNakedClass();
            Field[] fieldArray = nakedClass.getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (!field.isAggregate() && !field.isDerived()) {
                    Naked naked;
                    Naked naked2;
                    if (field.isValue()) {
                        naked2 = (NakedValue)field.get(nakedObject);
                        naked = (NakedValue)field.get(nakedObject2);
                        if (!naked2.isEmpty()) {
                            String string = naked2.title().toString().toLowerCase();
                            String string2 = naked.title().toString().toLowerCase();
                            if (string2.indexOf(string) == -1) {
                                return false;
                            }
                        }
                    } else {
                        naked2 = field.get(nakedObject);
                        naked = field.get(nakedObject2);
                        if (naked2 != null) {
                            if (naked == null) {
                                return false;
                            }
                            if (naked2 != naked) {
                                return false;
                            }
                        }
                    }
                }
                ++n;
            }
            return true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return false;
        }
        catch (ObjectStoreException objectStoreException) {
            return false;
        }
    }

    public Vector getNextElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectNotFoundException, NonPersistentObjectException, ObjectStoreException {
        int n2;
        int n3;
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (nakedObject != null && !nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        Vector vector = this.getCollectionElements(nakedCollection);
        int n4 = vector.size();
        if (nakedObject == null) {
            n3 = 0;
            n2 = n;
        } else {
            n3 = 0;
            while (n3 < n4) {
                if (nakedObject.equals(vector.elementAt(n3))) break;
                ++n3;
            }
            if (n3 == n4) {
                throw new ObjectNotFoundException("Could not find " + nakedObject);
            }
            n2 = ++n3 + n;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        Vector vector2 = new Vector();
        int n5 = n3;
        while (n5 < n2) {
            Object e = vector.elementAt(n5);
            if (e == null) {
                throw new RuntimeException();
            }
            vector2.addElement(e);
            ++n5;
        }
        return vector2;
    }

    public Vector getNextInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws NonPersistentObjectException, ObjectNotFoundException {
        if (nakedObject == null) {
            throw new NullPointerException();
        }
        if (nakedObject2 != null && !nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException("From element is not persistent");
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        Enumeration enumeration = this.elements();
        boolean bl = nakedObject2 == null;
        while (enumeration.hasMoreElements() && n2 < n) {
            Data data = (Data)enumeration.nextElement();
            if (!nakedClass.equals(data.type) || !this.matchesPattern(nakedObject, data)) continue;
            if (bl) {
                vector.add(this.createSkeletalObject(data));
                ++n2;
                continue;
            }
            if (!nakedObject2.getOid().equals(data.oid)) continue;
            bl = true;
        }
        if (!bl) {
            throw new ObjectNotFoundException("From object not found " + nakedObject2);
        }
        if (vector.size() == 0 && nakedObject2 != null) {
            throw new ObjectNotFoundException("No objects found matching pattern " + nakedObject + " after object " + nakedObject2);
        }
        return vector;
    }

    public NakedObject getObject(Object object) throws ObjectNotFoundException, ObjectStoreException {
        if (object == null) {
            throw new IllegalArgumentException("OID cannot be null");
        }
        if (this.isObjectCached(object)) {
            return this.getCachedObject(object);
        }
        if (this.containsKey(object)) {
            NakedObject nakedObject = null;
            Data data = this.get(object);
            if (!(data instanceof ObjectData)) {
                throw new NotImplementedException();
            }
            nakedObject = this.recreateObject((ObjectData)data);
            nakedObject.setOid(object);
            nakedObject.setResolved();
            this.cache(nakedObject);
            return nakedObject;
        }
        throw new ObjectNotFoundException(object);
    }

    public Vector getPreviousElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectNotFoundException, NonPersistentObjectException, ObjectStoreException {
        int n2;
        int n3;
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (nakedObject != null && !nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        Vector vector = this.getCollectionElements(nakedCollection);
        int n4 = vector.size();
        if (nakedObject == null) {
            n3 = n4;
            n2 = n3 - n;
        } else {
            n3 = 0;
            while (n3 < n4) {
                if (nakedObject.equals(vector.elementAt(n3))) break;
                ++n3;
            }
            if (n3 == n4) {
                throw new ObjectNotFoundException("Could not find " + nakedObject);
            }
            n2 = n3 - n;
            if (n2 < 0) {
                n2 = 0;
            }
        }
        Vector vector2 = new Vector();
        int n5 = n2;
        while (n5 < n3) {
            Object e = vector.elementAt(n5);
            if (e == null) {
                throw new RuntimeException();
            }
            vector2.addElement(e);
            ++n5;
        }
        return vector2;
    }

    public Vector getPreviousInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws NonPersistentObjectException {
        Object object;
        if (nakedObject == null) {
            throw new NullPointerException();
        }
        if (nakedObject2 != null && !nakedObject2.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        Enumeration enumeration = this.elements();
        NakedClass nakedClass = nakedObject.getNakedClass();
        Data[] dataArray = new Data[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = (Data)enumeration.nextElement();
            if (((Data)object).oid == null) {
                throw new RuntimeException();
            }
            if (!nakedClass.equals(((Data)object).type) || !this.matchesPattern(nakedObject, (Data)object)) continue;
            if (nakedObject2 != null && nakedObject2.getOid().equals(((Data)object).oid)) break;
            dataArray[n2] = object;
            if (++n2 != n) continue;
            n2 = 0;
        }
        object = new Vector(n);
        int n3 = n2;
        while (n3 < n && dataArray[n3] != null) {
            ((Vector)object).addElement(this.createSkeletalObject(dataArray[n3]));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            ((Vector)object).addElement(this.createSkeletalObject(dataArray[n4]));
            ++n4;
        }
        return object;
    }

    public void addElement(NakedCollection nakedCollection, NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        this.getCollectionElements(nakedCollection).addElement(nakedObject);
        this.broadcastAddUpdate(nakedCollection, nakedObject);
    }

    public boolean containsElement(NakedCollection nakedCollection, NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        return this.getCollectionElements(nakedCollection).contains(nakedObject);
    }

    public void destroyObject(NakedObject nakedObject) throws NonPersistentObjectException {
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        LOG.info((Object)("Delete requested on '" + nakedObject + "'"));
        this.remove(nakedObject.getOid());
        this.clearCache(nakedObject);
    }

    public void endTransaction() throws ObjectStoreException {
    }

    public NakedObject finderObject(NakedClass nakedClass) {
        throw new RuntimeException("Unimplemented");
    }

    public boolean hasInstances(NakedClass nakedClass) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!data.type.equals(nakedClass)) continue;
            return true;
        }
        return false;
    }

    public String name() {
        return "Transient Object Store";
    }

    public synchronized Object newOid() {
        return new SimpleOid(this.nextId++);
    }

    public int numberOfElements(NakedCollection nakedCollection) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        return this.getCollectionElements(nakedCollection).size();
    }

    public int numberOfInstances(NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (nakedObject == null) {
            throw new NullPointerException();
        }
        NakedClass nakedClass = nakedObject.getNakedClass();
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!nakedClass.equals(data.type)) continue;
            ++n;
        }
        return n;
    }

    public void removeElement(NakedCollection nakedCollection, NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedCollection.isPersistent()) {
            throw new NonPersistentObjectException("Collection is not persistent");
        }
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException("Element is not persistent");
        }
        this.getCollectionElements(nakedCollection).removeElement(nakedObject);
        this.broadcastRemoveUpdate(nakedCollection, nakedObject);
    }

    public void reset() {
        this.persistentObjectVector = new Vector();
    }

    public void resolve(NakedObject nakedObject) throws ObjectNotFoundException, ObjectStoreException {
        if (nakedObject == null) {
            throw new NullPointerException("Object reference must be non-null.");
        }
        Object object = nakedObject.getOid();
        if (object == null) {
            throw new IllegalArgumentException("Object must have an OID.");
        }
        if (nakedObject.isResolved()) {
            return;
        }
        Data data = this.get(object);
        if (data instanceof ObjectData) {
            ObjectData objectData = (ObjectData)data;
            Field[] fieldArray = nakedObject.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                Object object2 = objectData.get(field.getName());
                if (object2 != null) {
                    if (field.isValue()) {
                        ((NakedValue)field.get(nakedObject)).restoreString((String)object2);
                    } else if (this.isObjectCached(object2)) {
                        ((Association)field).init(nakedObject, this.getCachedObject(object2));
                    } else {
                        Data data2 = this.get(object2);
                        NakedObject nakedObject2 = data2.type.acquireInstance();
                        nakedObject2.setOid(object2);
                        this.cache(nakedObject2);
                        ((Association)field).set(nakedObject, nakedObject2);
                    }
                }
                ++n;
            }
            nakedObject.setResolved();
        }
    }

    public void save(NakedObject nakedObject) throws NonPersistentObjectException, ObjectStoreException {
        if (!nakedObject.isPersistent()) {
            throw new NonPersistentObjectException();
        }
        if (nakedObject instanceof NakedCollection) {
            throw new RuntimeException("Collections save their elements separately");
        }
        this.saveObject(nakedObject);
        if (nakedObject.isPersistent()) {
            this.broadcastObjectUpdate(nakedObject);
        }
    }

    public long serialNumber(String string) {
        Long l;
        if (this.serials.containsKey(string)) {
            l = (Long)this.serials.get(string);
            l = new Long(l + 1L);
        } else {
            l = new Long(1L);
        }
        this.serials.put(string, l);
        return l;
    }

    public void shutdown() {
    }

    public void startTransaction() throws ObjectStoreException {
    }

    private Vector getCollectionElements(NakedCollection nakedCollection) throws ObjectStoreException {
        if (this.containsKey(nakedCollection.getOid())) {
            CollectionData collectionData = (CollectionData)this.get(nakedCollection.getOid());
            return collectionData.elements;
        }
        throw new ObjectStoreException("Key not found " + nakedCollection.getOid());
    }

    private Object createSkeletalObject(Data data) {
        Object object = data.oid;
        if (this.isObjectCached(object)) {
            return this.getCachedObject(object);
        }
        NakedObject nakedObject = data.type.acquireInstance();
        nakedObject.setOid(object);
        return nakedObject;
    }

    public void makePersistent(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject instanceof InternalCollection) {
            throw new IllegalArgumentException("Cannot persist an InternalCollection");
        }
        this.makePersistent(nakedObject, new Vector());
    }

    private void makePersistent(NakedObject nakedObject, Vector vector) throws ObjectStoreException {
        if (nakedObject == null || nakedObject.isPersistent() || vector.contains(nakedObject)) {
            return;
        }
        Object object = this.newOid();
        vector.addElement(nakedObject);
        if (nakedObject instanceof NakedCollection) {
            Enumeration enumeration = ((NakedCollection)nakedObject).elements();
            while (enumeration.hasMoreElements()) {
                Naked naked = (Naked)enumeration.nextElement();
                this.makePersistent((NakedObject)naked, vector);
            }
            this.saveCollection((NakedCollection)nakedObject, object);
            nakedObject.setOid(object);
        } else {
            Field[] fieldArray = nakedObject.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (!fieldArray[n].isValue() && !fieldArray[n].isDerived()) {
                    Naked naked = fieldArray[n].get(nakedObject);
                    if (naked instanceof InternalCollection) {
                        AggregateOid aggregateOid = new AggregateOid(object, fieldArray[n].getName());
                        this.makeInternalCollectionPersistent(aggregateOid, (NakedCollection)naked, vector);
                    } else if (naked instanceof NakedObject) {
                        this.makePersistent((NakedObject)naked, vector);
                    }
                }
                ++n;
            }
            nakedObject.setOid(object);
            this.saveObject(nakedObject);
        }
        nakedObject.setResolved();
        this.cache(nakedObject);
    }

    private void makeInternalCollectionPersistent(Object object, NakedCollection nakedCollection, Vector vector) throws ObjectStoreException {
        Enumeration enumeration = nakedCollection.elements();
        CollectionData collectionData = new CollectionData(nakedCollection.getNakedClass(), object);
        Vector vector2 = collectionData.elements;
        while (enumeration.hasMoreElements()) {
            Naked naked = (Naked)enumeration.nextElement();
            vector2.addElement(naked);
            this.makePersistent((NakedObject)naked, vector);
        }
        this.put(object, collectionData);
    }

    private void saveCollection(NakedCollection nakedCollection, Object object) throws ObjectStoreException {
        Enumeration enumeration = nakedCollection.elements();
        CollectionData collectionData = new CollectionData(nakedCollection.getNakedClass(), object);
        Vector vector = collectionData.elements;
        while (enumeration.hasMoreElements()) {
            Naked naked = (Naked)enumeration.nextElement();
            vector.addElement(naked);
        }
        this.put(object, collectionData);
    }

    private NakedObject recreateObject(ObjectData objectData) throws ObjectStoreException {
        NakedClass nakedClass = objectData.type;
        NakedObject nakedObject = nakedClass.acquireInstance();
        Field[] fieldArray = nakedClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            Object object = objectData.get(field.getName());
            if (object != null) {
                if (field.isValue()) {
                    ((NakedValue)field.get(nakedObject)).restoreString((String)object);
                } else if (this.isObjectCached(object)) {
                    ((Association)field).init(nakedObject, this.getCachedObject(object));
                } else {
                    Data data = this.get(object);
                    NakedObject nakedObject2 = data.type.acquireInstance();
                    nakedObject2.setOid(object);
                    this.cache(nakedObject2);
                    ((Association)field).set(nakedObject, nakedObject2);
                }
            }
            ++n;
        }
        return nakedObject;
    }

    private void saveObject(NakedObject nakedObject) throws ObjectStoreException {
        Field[] fieldArray = nakedObject.getNakedClass().getFields();
        ObjectData objectData = new ObjectData(nakedObject.getNakedClass(), nakedObject.getOid());
        int n = 0;
        while (n < fieldArray.length) {
            Naked naked = fieldArray[n].get(nakedObject);
            if (naked != null && !(naked instanceof NakedCollection)) {
                if (naked instanceof NakedObject) {
                    Object object = ((NakedObject)naked).getOid();
                    if (object == null) {
                        this.makePersistent((NakedObject)naked);
                    }
                    objectData.add(fieldArray[n].getName(), ((NakedObject)naked).getOid());
                } else {
                    objectData.add(fieldArray[n].getName(), ((NakedValue)naked).saveString());
                }
            }
            ++n;
        }
        this.put(nakedObject.getOid(), objectData);
    }

    private void put(Object object, Data data) {
        if (!this.containsKey(object)) {
            data.oid = object;
            this.persistentObjectVector.addElement(data);
        }
    }

    private void remove(Object object) {
        this.persistentObjectVector.remove(this.get(object));
    }

    private Data get(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!object.equals(data.oid)) continue;
            return data;
        }
        return null;
    }

    private boolean containsKey(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!object.equals(data.oid)) continue;
            return true;
        }
        return false;
    }

    private Enumeration elements() {
        return this.persistentObjectVector.elements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CollectionData
    extends Data {
        private Vector elements = new Vector();

        CollectionData(NakedClass nakedClass, Object object) {
            super(nakedClass, object);
        }

        public String toString() {
            return "CollectionData[type=" + this.type.getName() + ",elements=" + this.elements + "]";
        }
    }

    private class ObjectData
    extends Data {
        private Hashtable fields = new Hashtable();

        ObjectData(NakedClass nakedClass, Object object) {
            super(nakedClass, object);
        }

        public String toString() {
            return "ObjectData[type=" + this.type.getName() + ",fields=" + this.fields + "]";
        }

        private void add(String string, Object object) {
            if (object == null) {
                this.fields.remove(string);
            } else {
                this.fields.put(string, object);
            }
        }

        private Object get(String string) {
            return this.fields.get(string);
        }
    }

    private abstract class Data {
        NakedClass type;
        Object oid;

        Data(NakedClass nakedClass, Object object) {
            this.type = nakedClass;
            this.oid = object;
        }
    }
}

