/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.control;

import org.nakedobjects.object.control.About;
import org.nakedobjects.object.control.Allow;
import org.nakedobjects.object.control.Permission;
import org.nakedobjects.object.control.Veto;

public class ProgrammableAbout
implements About {
    private String name;
    private String description;
    private boolean isAccessible = true;
    private boolean isAvailable = true;
    private StringBuffer unavailableReason;

    private void appendReason(String string) {
        if (this.unavailableReason == null) {
            this.unavailableReason = new StringBuffer();
        } else {
            this.unavailableReason.append("; ");
        }
        this.unavailableReason.append(string);
    }

    public Permission canAccess() {
        if (this.isAccessible) {
            return Allow.DEFAULT;
        }
        return new Veto(this.unavailableReason.toString());
    }

    public Permission canUse() {
        if (this.isAvailable) {
            return Allow.DEFAULT;
        }
        return new Veto(this.unavailableReason == null ? "" : this.unavailableReason.toString());
    }

    public void changeName(String string) {
        this.name = string;
    }

    public ProgrammableAbout changeNameIfAvailable(String string) {
        if (this.canUse().isAllowed()) {
            this.name = string;
        }
        return this;
    }

    public ProgrammableAbout changeNameIfUnavailable(String string) {
        if (this.canUse().isVetoed()) {
            this.name = string;
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public ProgrammableAbout makeAvailableOnCondition(boolean bl) {
        this.isAvailable = this.isAvailable && bl;
        return this;
    }

    public ProgrammableAbout makeAvailableOnCondition(boolean bl, String string) {
        boolean bl2 = this.isAvailable = this.isAvailable && bl;
        if (!bl) {
            this.appendReason(string);
        }
        return this;
    }

    public ProgrammableAbout makeUnavailable(String string) {
        this.isAvailable = false;
        this.appendReason(string);
        return this;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

