/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class NumberOfInstancesRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private NakedObject pattern;

    public NumberOfInstancesRequest(NakedObject nakedObject) {
        this.pattern = nakedObject;
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            this.response = new Integer(nakedObjectStore.numberOfInstances(this.pattern));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    int size() throws ObjectStoreException {
        this.sendRequest();
        return (Integer)this.response;
    }

    public String toString() {
        return "Number of instances [pattern=" + this.pattern + "]";
    }
}

