Attribute VB_Name = "TSZD_API_Declares"
Option Explicit
'
'-----VB declarations for TSZD.DLL.  Written for VB5
'
'Richard Tainsh, Linhoff March Ltd, 17/2/99
'http://www.LinnhoffMarch.com


'-----Windows API functions needed for StringFromPointer routine
Declare Function lstrlen Lib "kernel32" Alias "lstrlenA" (ByVal StringPointer As Long) As Long
Declare Function lstrcpy Lib "kernel32" Alias "lstrcpyA" (ByVal lpString1 As String, ByVal StringPointer As Long) As Long

'-----TSZD.dll API functions
'     Note: For arguments, True = 1 , False = 0.

'.....This function opens zip file and creates a list of items, corresponding to
'     contents of zip file. Must be called before any other function to get access
'     to zip file. ZipFileName is the path and full name of zip file,
'     for example: 'C:\TEST.ZIP'. Returns zero on success.
Declare Function zOpenZipFile Lib "tszd.dll" (ByVal zipname As String) As Long

'.....Closes zip file, opened with zOpenZipFile. Returns zero on success.
Declare Function zCloseZipFile Lib "tszd.dll" () As Long

'.....Returns the total number of compressed files within zip file, i.e. the number
'     of items in the list. First item has index = 0, last item has '
'     Index = zGetTotalFiles - 1
Declare Function zGetTotalFiles Lib "tszd.dll" () As Long


'.....Returns the sum of uncompressed file size of all files within zip file.
Declare Function zGetTotalBytes Lib "tszd.dll" () As Long

'.....Returns the number of currently selected files.
Declare Function zGetSelectedFiles Lib "tszd.dll" () As Long

'.....Returns the sum of uncompressed file size of selected files within zip file.
Declare Function zGetSelectedBytes Lib "tszd.dll" () As Long

'.....If some error occurs in the DLL, this function will return a pointer to a string
'     that describes the error.
'     MUST be wrapped with StringFromPointer to obtain the VB String
Declare Function zGetLastErrorAsText Lib "tszd.dll" () As Long

'.....After extracting operation, this function will return the number of skipped
'     files - usually zero.
Declare Function zGetSkipedFiles Lib "tszd.dll" () As Long

'.....This function returns the number of currently processed files and bytes.
'     This is necessary to calculate position of progress indicator.
'     Returns 1 on success.
Declare Function zGetRunTimeInfo Lib "tszd.dll" (ProcessedFiles As Long, ProcessedBytes As Long) As Byte

'.....To cancel extract operation, call this function.
Declare Function zCancelOperation Lib "tszd.dll" () As Byte

'.....Extracts only one of the file in zip file. This is useful for viewing/launching files.
Declare Function zExtractOne Lib "tszd.dll" (ItemNo As Long, _
   ByVal ExtractDirectory As String, ByVal Password As String, _
   ByVal OverwriteExisting As Byte, ByVal UseFolders As Byte, _
   ByVal TestOnly As Byte, _
   ByVal RTInfoFunc As Long) As Long
'     Parameters are:
'     ItemNo -  Item number of the file in the list.
'          0<= ItemNo <= zGetTotalFile-1
'     ExtractDirectory - Directory where to extract files. If empty, current directory is used.
'     Password - password to be used, if file is encrypted.
'     OverwriteExisting - if 1, any existing file will be overwritten, otherwise will be skipped.
'     UseFolders - if 1, the relative path information stored in zip file will be used to determine
'          location of the extracting file.
'     TestOnly - if 1, files are only tested, not saved to disk.
'     RTInfoFunc - pointer to the application function, which will be called
'          periodically from library to show runtime information,
'          for example some kind of progress bar. Within this function, application can
'          call zGetRunTimeInfo or zCancelOperation. If nil, no runtime information will
'          be available.
'          In VB5+, this may be called by using AddressOf in the call, in VB4 set to nil.
'
'     Return value is zero on success, otherwise application can call zGetLastErrorAsText to get
'     type of error.

'.....Extracts only files in the list, previously selected by zSelectFile.
'     Parameters are the same as in zExtractOne. Returns zero on success.
Declare Function zExtractSelected Lib "tszd.dll" ( _
    ByVal ExtractDirectory As String, ByVal Password As String, _
  ByVal OverwriteExisting As Byte, ByVal UseFolders As Byte, _
  ByVal TestOnly As Byte, ByVal RTInfoFunc As Long) As Long

'.....Extracts all files. Parameters are the same as in zExtractOne.
'     Returns zero on success.
Declare Function zExtractAll Lib "tszd.dll" ( _
    ByVal ExtractDirectory As String, ByVal Password As String, _
    ByVal OverwriteExisting As Byte, _
    ByVal UseFolders As Byte, _
    ByVal TestOnly As Byte, _
    ByVal RTInfoFunc As Long) As Long


'.....Returns a pointer to the name of the file in the list with index i.
'     MUST be wrapped with StringFromPointer to obtain the VB String
Declare Function zGetFileName Lib "tszd.dll" (ByVal i As Long) As Long


'.....Returns a pointer to the extension of the file in the list with index i.
'     MUST be wrapped with StringFromPointer to obtain the VB String
Declare Function zGetFileExt Lib "tszd.dll" (ByVal i As Long) As Long


'.....Returns a pointer to the stored path of the file in the list with index i.
'     MUST be wrapped with StringFromPointer to obtain the VB String
Declare Function zGetFilePath Lib "tszd.dll" (ByVal i As Long) As Long


'.....Returns the MSDOS date of the file in the list with index i.
Declare Function zGetFileDate Lib "tszd.dll" (ByVal i As Long) As Long

'.....Returns the MSDOS time of the file in the list with index i.
Declare Function zGetFileTime Lib "tszd.dll" (ByVal i As Long) As Long

'.....Returns the uncompressed size of the file in the list with index i.
Declare Function zGetFileSize Lib "tszd.dll" (ByVal i As Long) As Long

'.....Returns the compressed size of the file in the list with index i.
Declare Function zGetCompressedFileSize Lib "tszd.dll" (ByVal i As Long) As Long

'.....Returns 1, if file in the list with index i is encrypted.
Declare Function zFileIsEncrypted Lib "tszd.dll" (ByVal i As Long) As Byte

'.....Returns a pointer to the result of the last operation on the file in the list with index i.
'     Usually 'Ok.'
'     MUST be wrapped with StringFromPointer to obtain the VB String
Declare Function zGetLastOperResult Lib "tszd.dll" (ByVal i As Long) As Long

'.....Returns 1, if file in the list with index i is selected.
Declare Function zFileIsSelected Lib "tszd.dll" (ByVal i As Long) As Byte


'.....Select/Unselect file in the list with index i. If how is 1, the file will be selected,
'     otherwise will be unselected.
Declare Function zSelectFile Lib "tszd.dll" (ByVal i As Long, ByVal how As Byte) As Byte


'.....Creates new empty zip file witn name ZipFileName, for example: "C:\temp\test.zip".
'     Returns zero on success.
Declare Function zCreateNewZip Lib "tszd.dll" (ByVal zipname As String) As Long


'.....Call this function after zCreateNewZip or zOpenZipFile for every file, which must be included
'     in the Zip file. The function checks if the file already exists in the archive, date and time
'     of the file depending of the UpdateMode, and if the conditions are true, adds the file to the
'     list of "to be compressed files".
Declare Function zOrderFile Lib "tszd.dll" (ByVal FileName As String, ByVal StoredName As String, _
    ByVal UpdateMode As Long) As Long
'     Parameters are:
'     FileName - the full path and name of the file, for example: "C:\TEMP\TEST.TXT"
'     StoredName - this is the path and the name, under which the file must be stored in zip file,
'          for example: "TEMP\TEST.TXT".
'     UpdateMode - points if the file must be added if it is already exists in the archive. There
'          are 3 possible values:
'          0 - "Add (and Replace) file", if file does not exist in the archive, it will be added, if exists, it will be replaced.
'          1 - "Freshen file", file will be compressed only if it already exists in the archive and is newer.
'          2 - "Update file", file will be compressed if does not exists in the archive or if it exists, but is newer.

'     The return value is zero if the file is succesfuly added to "Add List".



'.....Call this function to actually compress the files, previously requested with zOrderFile.
Declare Function zCompressFiles Lib "tszd.dll" (ByVal Password As String, _
    ByVal CompressionMethod As Long, ByVal ResetArchiveAttribute As Byte, _
    ByVal RTInfoFunc As Long) As Long
'     Parameters are:
'     Password - if is not empty, the files will be encrypted with this password.
'     CompressionMethod - there 4 possible values:
'          0 : Stored, no compression
'          1:     Fast compression
'          2:     Normal compression
'          3:     Max compression
'     ResetArchiveAttribute - if it is 1, the Archive attribute of the file will be reset after the
'          compressing of the file.
'
'     RTInfoFunc - pointer to the application function, which will be called periodically from
'          library to show runtime information, for example some kind of progress bar.
'          Within this function, application can call zGetRunTimeInfo or zCancelOperation.
'          If nil, no runtime information will be available.
'          In VB5+, this may be called by using AddressOf in the call, in VB4 set to nil.
'
'     Return value is zero on success, otherwise application can call zGetLastErrorAsText
'     to get type of error.
'
'     Just before return, this function calls internally zOpenZipFile, so the zip file is opened.
'     You can directly browse it. Do not forget to close it with zCloseZipFile.
  


  

Public Function StringFromPointer(Pointer As Long)
'
'-----Returns a VB String given a pointer to an LPSTR
'
'Richard Tainsh 23/9/98

Dim StrLen As Long
Dim NewString As String

'.....Get the length of the LPSTR
StrLen = lstrlen(Pointer)
'.....Allocate the NewString to the right size
NewString = String(StrLen, " ")

'.....Copy the LPSTR to the VB string
Call lstrcpy(NewString, Pointer)

StringFromPointer = NewString

End Function
