// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Svg.pas' rev: 10.00

#ifndef SvgHPP
#define SvgHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Dxfconv.hpp>	// Pascal unit
#include <Dxfimage.hpp>	// Pascal unit
#include <Sgconsts.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Mvfont.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Svg
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TsvgProgressEvent)(Graphics::TProgressStage Stage, int Done, int Count);

struct TsgSVGStyle;
typedef TsgSVGStyle *PsgSVGStyle;

struct TsgSVGStyle
{
	
public:
	Graphics::TColor FillColor;
	double FillOpacity;
	bool IsHaveFillColor;
	Graphics::TColor GradientColor;
	AnsiString GradientName;
	Graphics::TColor LineColor;
	AnsiString LineType;
	bool LineVisible;
	double Opacity;
	Byte TextAlign;
	Graphics::TColor TextColor;
	AnsiString TextFontName;
	Mvfont::TmvFontStyles TextFontStyles;
	double TextHeigth;
	bool Visibility;
	double Width;
} ;

class DELPHICLASS TSVGColors;
class PASCALIMPLEMENTATION TSVGColors : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStringList* FColorsString;
	int FInfo;
	
protected:
	int __fastcall HexToInt(AnsiString &vS);
	
public:
	__fastcall TSVGColors(void);
	__fastcall virtual ~TSVGColors(void);
	Graphics::TColor __fastcall StringToColor(AnsiString vStrColor);
	__property int Info = {read=FInfo, nodefault};
};


class DELPHICLASS TsgSVGBlock;
class PASCALIMPLEMENTATION TsgSVGBlock : public Dxfconv::TsgDXFBlock 
{
	typedef Dxfconv::TsgDXFBlock inherited;
	
private:
	TsgSVGStyle FSVGStyle;
	Sgconsts::TFRect *FSVGViewBox;
	bool FRotMatrix;
	
public:
	__fastcall virtual TsgSVGBlock(void);
	__fastcall virtual ~TsgSVGBlock(void);
};


class DELPHICLASS TsgSVGBlockInsertTable;
class PASCALIMPLEMENTATION TsgSVGBlockInsertTable : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Dxfconv::TsgDXFConverter* FConverter;
	Classes::TList* FBlockInsertList;
	bool FRotMatrix;
	
protected:
	TsgSVGBlock* __fastcall CreateBlock(const AnsiString AName, double const * AMatrix);
	TsgSVGBlock* __fastcall CreateBlockByInsert(const AnsiString AName, const Dxfconv::TsgSVGInsert* AInsert);
	int __fastcall IndexOfBlock(const TsgSVGBlock* ABlock);
	int __fastcall IndexOfName(const AnsiString AName);
	TsgSVGBlock* __fastcall GetBlock(int AIndex);
	TsgSVGBlock* __fastcall GetBlockLast(void);
	AnsiString __fastcall GetBlockName(const TsgSVGBlock* ABlock);
	Dxfconv::TsgSVGInsert* __fastcall GetInsert(int AIndex);
	void __fastcall LoadBlock(TsgSVGBlock* ABlock);
	void __fastcall LoadAllBlocks(void);
	TsgSVGBlock* __fastcall SetMatrixByBlock(const AnsiString AName, double const * AMatrix);
	
public:
	__fastcall TsgSVGBlockInsertTable(const Dxfconv::TsgDXFConverter* AConverter);
	__fastcall virtual ~TsgSVGBlockInsertTable(void);
};


class DELPHICLASS TsgSVGBase64;
class PASCALIMPLEMENTATION TsgSVGBase64 : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FCol;
	AnsiString FBuffer;
	Classes::TStrings* FStrs;
	int FRow;
	int FRMax;
	
protected:
	char __fastcall Next(void);
	
public:
	AnsiString __fastcall Encode(const AnsiString AStr, Classes::TStrings* AStrs, Classes::TStream* &S);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TsgSVGBase64(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgSVGBase64(void) { }
	#pragma option pop
	
};


class DELPHICLASS TsgSVGGradient;
class PASCALIMPLEMENTATION TsgSVGGradient : public Dxfconv::TsgDXFEntity 
{
	typedef Dxfconv::TsgDXFEntity inherited;
	
private:
	Sgconsts::TFPoint FCenterRadialGradient;
	Classes::TList* FColors;
	AnsiString FName;
	Classes::TList* FPercentFill;
	double FRadius;
	bool FVerticalGradient;
	
public:
	__fastcall virtual TsgSVGGradient(void);
	__fastcall virtual ~TsgSVGGradient(void);
	virtual void __fastcall AssignEntity(Dxfconv::TsgDXFEntity* Source);
	void __fastcall SetupProperty(Dxfconv::TsgDXFGradient* &AGradient);
	__property Sgconsts::TFPoint CenterRadialGradient = {read=FCenterRadialGradient, write=FCenterRadialGradient};
	__property bool IsVerticalGradient = {read=FVerticalGradient, write=FVerticalGradient, nodefault};
	__property Classes::TList* GradientColors = {read=FColors};
	__property AnsiString Name = {read=FName, write=FName};
	__property Classes::TList* PercentFill = {read=FPercentFill};
	__property double Radius = {read=FRadius, write=FRadius};
};


class DELPHICLASS TsgSVGImage;
class PASCALIMPLEMENTATION TsgSVGImage : public Dxfimage::TsgDXFImage 
{
	typedef Dxfimage::TsgDXFImage inherited;
	
private:
	int FBlockNoNameCount;
	TsgSVGBlockInsertTable* FBlockInsertTable;
	Classes::TList* FBlockList;
	AnsiString FBuffer;
	int FBufferSize;
	bool FError;
	Dxfconv::TsgDXFGradient* FHatch;
	int FIndexBuffer;
	int FIndexBufferOld;
	int FDefsTag;
	Classes::TList* FGradientList;
	TsvgProgressEvent FOnProgress;
	double FKoefDeviceCaps;
	AnsiString FMsgProgress;
	bool FTextUTF8;
	int FTickCount;
	bool FStopLoading;
	Classes::TStringList* FStylesOfEntity;
	TsgSVGStyle FStyle;
	TsgSVGStyle FStyleDef;
	TSVGColors* FSVGColors;
	Classes::TStringList* FSVGTag;
	Classes::TStringList* FSVGType;
	Sgconsts::TFRect FSVGViewBox;
	Sgconsts::TFPoint FSVGSize;
	int FUpdateProgress;
	unsigned FSwitch;
	int FSwitchCnt;
	void __fastcall DrawPattern(System::TObject* Sender);
	int __fastcall GetIndexOfGradientByName(const AnsiString AName);
	TsgSVGBlock* __fastcall GetBlockOfPattern(const AnsiString AName);
	
protected:
	void __fastcall AddEntity(Dxfconv::TsgDXFEntity* AEntity);
	void __fastcall AddListEntities(Classes::TList* AList);
	void __fastcall AddBlock(Dxfconv::TsgDXFEntity* AEntity, const AnsiString ABlockName);
	void __fastcall AddBlockListEntities(Classes::TList* AList, AnsiString ABlockName);
	void __fastcall AddHatchOfArc(Classes::TList* AList, Dxfconv::TsgDXFArc* Arc);
	void __fastcall AddHatchOfCircle(Classes::TList* AList, Dxfconv::TsgDXFCircle* ACircle);
	void __fastcall AddHatchOfEllipse(Classes::TList* AList, Dxfconv::TsgDXFEllipse* AEllipse);
	void __fastcall AddHatchOfPath(Classes::TList* AList, Dxfconv::TsgSVGPath* APath);
	void __fastcall AddHatchOfPolyline(Classes::TList* AList, Dxfconv::TsgDXFPolyline* APolyline);
	void __fastcall AddHatchOfSpline(Classes::TList* AList, Dxfconv::TsgDXFSpline* ASpline);
	void __fastcall AnalizeFile(void);
	void __fastcall AnalizeStyle(const AnsiString AStyle);
	double __fastcall AngleFromMatrix(Sgconsts::PFMatrix AMatrix);
	double __fastcall CalibreStr(const AnsiString AStr, Byte AType);
	double __fastcall CalibreVar(int ANumTag, Byte AType);
	void __fastcall ClearCommentarySymbols(void);
	void __fastcall ClearOnMouseEvnt(void);
	void __fastcall ClearPrefix(void);
	void __fastcall ClearStyle(void);
	HIDESBASE void __fastcall DoProgress(Graphics::TProgressStage AStage, int ADone, int ACount);
	TsgSVGBlock* __fastcall FindBlockInConverter(AnsiString ABlockName);
	void __fastcall InitCommentary(Dxfconv::TsgDXFEntity* AEntity, int AStarIndex, int AEndIndex);
	void __fastcall InitStandartStyleByText(void);
	bool __fastcall IsHasHatch(void);
	bool __fastcall IsNextVariable(int AIndex);
	bool __fastcall IsNextDigital(AnsiString AStr, int AIndex, int ALen);
	bool __fastcall IsTagClose(void);
	AnsiString __fastcall GetTagValue(const AnsiString AVal);
	void __fastcall LoadBlocksInConverter(void);
	void __fastcall LoadHatch(void);
	void __fastcall LoadGroup(int ACode, TsgSVGBlock* AGroup);
	AnsiString __fastcall MakeLineType(Classes::TList* ATicks);
	void __fastcall LoadMatrixParametrs(int &AIndex, Sgconsts::PFMatrix AMatrix);
	void __fastcall MakeHatch(Dxfconv::TsgDXFEntity* AEntity);
	void __fastcall MakeHatchByListEntities(Classes::TList* AList);
	Graphics::TColor __fastcall ReadInfoColor(int &AIndex);
	void __fastcall ReadBadData(const int AIndex);
	void __fastcall ReadTag(void);
	void __fastcall ReadTagCircle(void);
	void __fastcall ReadTagClass(int AIndex);
	AnsiString __fastcall ReadTagDesc();
	void __fastcall ReadTagEllipse(void);
	void __fastcall ReadTagEntity(void);
	void __fastcall ReadTagImage(void);
	void __fastcall ReadTagG(void);
	void __fastcall ReadTagGlyph(void);
	void __fastcall ReadTagGradient(bool AIsGradientLinear);
	void __fastcall ReadTagLine(void);
	void __fastcall ReadTagPath(void);
	void __fastcall ReadTagPolyline(void);
	void __fastcall ReadTagRectangle(void);
	Sgconsts::TFPoint __fastcall ReadTagRotate(int &AIndex);
	void __fastcall ReadTagSymbol(void);
	void __fastcall ReadTagStyle(int AIndex);
	void __fastcall ReadTagStyleType(void);
	void __fastcall ReadTagSvg(void);
	void __fastcall ReadTagText(void);
	Sgconsts::TFPoint __fastcall ReadTagTranslate(int &AIndex);
	Sgconsts::TFRect __fastcall ReadTagViewBox(int &AIndex);
	void __fastcall ReadTagUse(void);
	void __fastcall ReadTextTypeEncoding(void);
	virtual int __fastcall DoDraw(Dxfconv::TsgDXFEntity* Entity);
	void __fastcall SetupClass(const AnsiString AStyle);
	double __fastcall StringToVar(const AnsiString AStinrgVar);
	void __fastcall StyleOptions(const AnsiString AKey, AnsiString AValue);
	Sgconsts::TFPoint __fastcall TransformPoint(Sgconsts::PFPoint APoint, Sgconsts::PFMatrix AMatrix);
	void __fastcall UseBlock(const AnsiString ABlockName);
	
public:
	__fastcall virtual TsgSVGImage(void);
	__fastcall virtual ~TsgSVGImage(void);
	virtual Graphics::TColor __fastcall GetEntityColor(Dxfconv::TsgDXFEntity* AEntity, Dxfconv::TsgDXFInsert* AInsert);
	virtual void __fastcall LoadFromStream(Classes::TStream* AStream);
	virtual void __fastcall StopLoading(void);
	__property bool Error = {read=FError, nodefault};
};


//-- var, const, procedure ---------------------------------------------------
#define SSVGImage "SVG image"
extern PACKAGE Word CF_SVG;

}	/* namespace Svg */
using namespace Svg;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Svg
