// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'CADExport.pas' rev: 4.00

#ifndef CADExportHPP
#define CADExportHPP

#pragma delphiheader begin
#pragma option push -w-
#include <sgBitmap.hpp>	// Pascal unit
#include <TTF.hpp>	// Pascal unit
#include <sgConsts.hpp>	// Pascal unit
#include <SGLines.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <DXFImage.hpp>	// Pascal unit
#include <SHX.hpp>	// Pascal unit
#include <Extrusion.hpp>	// Pascal unit
#include <DXFConv.hpp>	// Pascal unit
#include <MVFont.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Cadexport
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TsgDXFDrawMode { dmNormal, dmBlack, dmGray };
#pragma option pop

#pragma option push -b-
enum TsgDXFViewDirection { vdTop, vdBottom, vdLeft, vdRight, vdFront, vdBack, vdSWIsometric, vdSEIsometric, 
	vdNWIsometric, vdNEIsometric };
#pragma option pop

typedef Shx::TsgSHXFontList* __fastcall (__closure *TsgSHXFontsProc)(void);

typedef void __fastcall (__closure *TsgRgnProc)(Windows::PRect P, int Count);

typedef void __fastcall (__closure *TsgLayoutProc)(int Index, Dxfconv::TsgDXFLayout* ALayout);

#pragma pack(push, 4)
struct TScaling
{
	Sgconsts::TFPoint Offset;
	Sgconsts::TFPoint Scale;
	int DX;
	int DY;
} ;
#pragma pack(pop)

struct TsgCanvasParams;
typedef TsgCanvasParams *PsgCanvasParams;

#pragma pack(push, 4)
struct TsgCanvasParams
{
	Graphics::TBrush* Brush;
	Graphics::TFont* Font;
	Graphics::TPen* Pen;
} ;
#pragma pack(pop)

struct TsgViewPortCanvasParams;
typedef TsgViewPortCanvasParams *PsgViewPortCanvasParams;

#pragma pack(push, 4)
struct TsgViewPortCanvasParams
{
	HDC HDC;
	TsgCanvasParams CanvasParams;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TsgCalcCoordsStruct
{
	Extended XScaled;
	Extended YScaled;
	double X;
	double Y;
	double Rot[4][3];
	Sgconsts::TFPoint RealLayoutCenter;
	int NullCoord;
} ;
#pragma pack(pop)

#pragma option push -b-
enum TsgDistanceUnits { duNone, duInch, duMM };
#pragma option pop

#pragma option push -b-
enum TsgAngularUnits { auNone };
#pragma option pop

#pragma pack(push, 1)
struct TsgMeasurement
{
	TsgDistanceUnits DistanceUnits;
	TsgAngularUnits AngularUnits;
} ;
#pragma pack(pop)

class DELPHICLASS TsgCADExport;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TsgCADExport : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Graphics::TProgressEvent FOnProgress;
	virtual void __fastcall Progress(Graphics::TProgressStage Stage, Byte PercentDone);
	
public:
	__fastcall virtual TsgCADExport(Dxfimage::TsgDXFImage* ACADImage);
	virtual void __fastcall SaveToStream(Classes::TStream* S) = 0 ;
	virtual void __fastcall SaveToFile(const AnsiString AFileName);
	__property Graphics::TProgressEvent OnProgress = {read=FOnProgress, write=FOnProgress};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TsgCADExport(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TsgSimpleExport;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TsgSimpleExport : public TsgCADExport 
{
	typedef TsgCADExport inherited;
	
private:
	Graphics::TColor FColor;
	Graphics::TColor FFillColor;
	Graphics::TColor FBackgroundColor;
	int FCount;
	int FCurrent;
	Ttf::TsgGDIAdapter* FGDI;
	Sgconsts::TFRect *FClippingRect;
	HRGN FClipRgn;
	Classes::TList* FSaveDC;
	Windows::TRect FIRect;
	double FBorderSize;
	Sgconsts::TsgBorderType FBorderType;
	Sgconsts::TFPoint FCenter;
	Graphics::TFontCharset FCharset;
	Dxfconv::TsgDXFConverter* FConverter;
	Dxfconv::TsgDXFLayout* FCurrentLayout;
	Classes::TList* FCounts;
	Graphics::TColor FDefaultColor;
	bool FDimensionsVisible;
	Sgconsts::TFRect FDrawingBox;
	TsgDXFDrawMode FDrawMode;
	double FDX;
	double FDY;
	Sgconsts::TFRect FExtents;
	int FIndex;
	Classes::TList* FIntPoints;
	Windows::TPoint FIPoints[8];
	bool FIsShowLineWeight;
	bool FIsWithoutBorder;
	bool FLineScaled;
	int FNullWidth;
	Classes::TNotifyEvent FOnLayoutChange;
	Classes::TList* FPoly;
	Sgconsts::TFRect FPureExtents;
	bool FReady;
	double FZRotate;
	Sgconsts::TFPoint FScale;
	bool FStretch;
	bool FShowImages;
	TsgViewPortCanvasParams *FViewPortCanvasParams;
	HRGN FViewPortRegion;
	double FXMax;
	double FXMin;
	double FYMax;
	double FYMin;
	double FZMax;
	double FZMin;
	double FXScale;
	int FXSize;
	double FZoom;
	double FLineWeightScale;
	bool FResizeDisproportionateDrawing;
	bool FTextVisible;
	double FXDisproportionateShift;
	double FYDisproportionateShift;
	TsgSHXFontsProc FSHXFontsProc;
	void __fastcall ApplyBrush(void);
	void __fastcall ApplyPen(System::TObject* Sender);
	void __fastcall ApplyScale(int AWidth, int AHeight);
	void __fastcall ApplyText(void);
	void __fastcall BoxPoint(const Sgconsts::TFPoint &P);
	void __fastcall DoClipRect(const Windows::TRect &R);
	void __fastcall DrawArc(System::TObject* Sender);
	void __fastcall DrawCircle(System::TObject* Sender);
	void __fastcall DrawFace(System::TObject* Sender);
	void __fastcall DrawHatch(System::TObject* Sender);
	void __fastcall DrawImage(System::TObject* Sender);
	int __fastcall DrawDimension(System::TObject* Sender);
	int __fastcall DrawInsert(System::TObject* Sender);
	void __fastcall DrawLeader(System::TObject* Sender);
	void __fastcall DrawLine(System::TObject* Sender);
	void __fastcall DrawPoly(System::TObject* Sender);
	void __fastcall DrawSpline(System::TObject* Sender);
	void __fastcall DrawSolid(System::TObject* Sender);
	void __fastcall DrawText(System::TObject* Sender);
	void __fastcall DrawFlatPoly(System::TObject* Sender);
	void __fastcall DrawFlatHatch(System::TObject* Sender);
	void __fastcall DrawViewport(System::TObject* Sender);
	void __fastcall DrawOle2Frame(System::TObject* Sender);
	void __fastcall DrawPointsListByPolyline(const System::TObject* AObj, const Classes::TList* DottedSingPts
		);
	void __fastcall DrawPointsListByPolyPolyline(const System::TObject* AObj, const Classes::TList* DottedSingPts
		);
	void __fastcall DrawPolyLine(Classes::TList* IntPoints);
	void __fastcall EnterInsert(System::TObject* Sender);
	void __fastcall EnterViewport(System::TObject* Sender);
	void __fastcall EnterXRef(System::TObject* Sender);
	void __fastcall FillFromFlat(Dxfconv::TsgFlatEntity* FP);
	void __fastcall ProcRgn(HRGN H, TsgRgnProc Proc);
	void __fastcall FillRgn(HRGN H);
	void __fastcall ClipRgn(HRGN H);
	int __fastcall IncCount(Dxfconv::TsgDXFEntity* Entity);
	void __fastcall Iterate(TsgLayoutProc Proc);
	void __fastcall CntLayout(int Index, Dxfconv::TsgDXFLayout* ALayout);
	void __fastcall ExpLayout(int Index, Dxfconv::TsgDXFLayout* ALayout);
	Dxfconv::TsgDXFBlock* __fastcall GetBlock(int Index);
	Dxfconv::TsgDXFEntity* __fastcall GetEntity(int Index);
	bool __fastcall GetIs3D(void);
	Dxfconv::TsgDXFLayout* __fastcall GetLayout(int Index);
	int __fastcall GetLayoutsCount(void);
	Sgconsts::TFPoint __fastcall GetScale(void);
	Shx::TsgSHXFontList* __fastcall GetSHXFontsProc(void);
	void __fastcall Assign(Dxfimage::TsgDXFImage* Source);
	void __fastcall Polyline(const void *Points, int Count);
	void __fastcall Polygon(const void *Points, int Count);
	void __fastcall PolyPolyline(const void *Points, const void *Counts, int Count);
	void __fastcall PolyPolygon(void *Points, void *Counts, int Count);
	void __fastcall ResetExtents(void);
	void __fastcall SaveDC(void);
	void __fastcall RestoreDC(void);
	void __fastcall SetBackgroundColor(Graphics::TColor Value);
	void __fastcall SetDefaultColor(Graphics::TColor Value);
	void __fastcall SetClippingRect(Sgconsts::PFRect Value);
	void __fastcall SetDrawingBox(const Sgconsts::TFRect &ABox);
	void __fastcall SetDrawMode(TsgDXFDrawMode Value);
	void __fastcall SetIs3D(bool Value);
	void __fastcall SetIsShowLineWeight(bool Value);
	void __fastcall SetIsWithoutBorder(bool Value);
	void __fastcall SetLineScaled(bool Value);
	void __fastcall SetStretch(bool Value);
	void __fastcall SetShowImages(bool Value);
	void __fastcall SetDimensionsVisible(bool AVisible);
	void __fastcall SetTextVisible(bool AVisible);
	void __fastcall SetColor(void);
	void __fastcall SetFColor(void);
	
protected:
	Graphics::TCanvas* FCanvas;
	Dxfconv::TsgCADIterate FDraw;
	Byte FExtPenFlag;
	virtual double __fastcall GetLineScale(void);
	double __fastcall GetRealImageMatrix(void);
	virtual bool __fastcall RotPict(Graphics::TGraphic* AGraphic, int Angle);
	virtual Windows::TRect __fastcall GetExportRect(void);
	virtual int __fastcall DoDraw(Dxfconv::TsgDXFEntity* Entity);
	virtual int __fastcall DoFinish(Dxfconv::TsgDXFEntity* Entity);
	void __fastcall Draw(Graphics::TCanvas* Canvas, const Windows::TRect &Rect);
	int __fastcall DrawEntity(Dxfconv::TsgDXFEntity* Entity);
	virtual void __fastcall FillBoxForCoordsCalc(int ACoord, Sgconsts::TFRect &ABox);
	void __fastcall SetCurrentLayout(const Dxfconv::TsgDXFLayout* ALayout);
	void __fastcall SetExtentsParameters(const Sgconsts::TFRect &ARect, const bool AIs3DExtents);
	virtual void __fastcall SetMatrix(void);
	virtual void __fastcall ExpPolyline(const void *Points, int Count);
	virtual void __fastcall ExpPolygon(const void *Points, int Count);
	virtual void __fastcall ExpPolyPolyline(const void *Points, const void *Counts, int Count);
	virtual void __fastcall ExpPolyPolygon(void *Points, void *Counts, int Count);
	virtual void __fastcall ExpFillRgn(Windows::PRect P, int Count);
	virtual void __fastcall ExpClipRgn(Windows::PRect P, int Count);
	virtual void __fastcall ExpImage(Windows::TRect &R, Graphics::TGraphic* AImage);
	virtual void __fastcall ExpSaveDC(void);
	virtual void __fastcall ExpRestoreDC(void);
	virtual void __fastcall PageStart(int N);
	virtual void __fastcall PageEnd(int N);
	virtual void __fastcall SetStrokeColor(Graphics::TColor AColor);
	virtual void __fastcall SetFillColor(Graphics::TColor AColor);
	virtual void __fastcall CloseFigure(void);
	virtual void __fastcall Progress(Graphics::TProgressStage Stage, Byte PercentDone);
	__property float FHCoef = {read=FDraw.YScale, write=FDraw.YScale};
	__property float FAngle = {read=FDraw.Angle, write=FDraw.Angle};
	__property TsgSHXFontsProc SHXFontsProc = {read=FSHXFontsProc};
	
public:
	__fastcall virtual TsgSimpleExport(Dxfimage::TsgDXFImage* ACADImage);
	__fastcall virtual ~TsgSimpleExport(void);
	Extended __fastcall AbsHeight(void);
	Extended __fastcall AbsWidth(void);
	virtual Graphics::TColor __fastcall GetEntityColor(Dxfconv::TsgDXFEntity* AEntity, Dxfconv::TsgDXFInsert* 
		AInsert);
	Windows::TPoint __fastcall GetPoint(const Sgconsts::TFPoint &P);
	Sgconsts::TFPoint __fastcall GetFPoint(const Sgconsts::TFPoint &P);
	void __fastcall GetExtents(void);
	virtual void __fastcall SaveToStream(Classes::TStream* S);
	__property Graphics::TColor BackgroundColor = {read=FBackgroundColor, write=SetBackgroundColor, nodefault
		};
	__property Dxfconv::TsgDXFBlock* Blocks[int Index] = {read=GetBlock};
	__property double BorderSize = {read=FBorderSize, write=FBorderSize};
	__property Sgconsts::TsgBorderType BorderType = {read=FBorderType, write=FBorderType, nodefault};
	__property Dxfconv::TsgDXFConverter* Converter = {read=FConverter};
	__property Dxfconv::TsgDXFLayout* CurrentLayout = {read=FCurrentLayout, write=SetCurrentLayout};
	__property Graphics::TColor DefaultColor = {read=FDefaultColor, write=SetDefaultColor, nodefault};
	__property Sgconsts::TFRect DrawingBox = {read=FDrawingBox, write=SetDrawingBox};
	__property TsgDXFDrawMode DrawMode = {read=FDrawMode, write=SetDrawMode, nodefault};
	__property Dxfconv::TsgDXFEntity* Entities[int Index] = {read=GetEntity};
	__property Sgconsts::TFRect Extents = {read=FExtents, write=FExtents};
	__property bool Is3D = {read=GetIs3D, write=SetIs3D, nodefault};
	__property bool IsShowLineWeight = {read=FIsShowLineWeight, write=SetIsShowLineWeight, nodefault};
	__property bool IsWithoutBorder = {read=FIsWithoutBorder, write=SetIsWithoutBorder, nodefault};
	__property Dxfconv::TsgDXFLayout* Layouts[int Index] = {read=GetLayout};
	__property int LayoutsCount = {read=GetLayoutsCount, nodefault};
	__property bool LineScaled = {read=FLineScaled, write=SetLineScaled, nodefault};
	__property double LineWeightScale = {read=FLineWeightScale, write=FLineWeightScale};
	__property int NullWidth = {read=FNullWidth, write=FNullWidth, nodefault};
	__property Classes::TNotifyEvent OnLayoutChange = {read=FOnLayoutChange, write=FOnLayoutChange};
	__property Sgconsts::TFRect PureExtents = {read=FPureExtents};
	__property bool ResizeDisproportionateDrawing = {read=FResizeDisproportionateDrawing, write=FResizeDisproportionateDrawing
		, nodefault};
	__property bool ShowImages = {read=FShowImages, write=SetShowImages, nodefault};
	__property Sgconsts::TFPoint Scale = {read=GetScale};
	__property bool Stretch = {read=FStretch, write=SetStretch, nodefault};
	__property bool DimensionsVisible = {read=FDimensionsVisible, write=SetDimensionsVisible, nodefault
		};
	__property bool TextVisible = {read=FTextVisible, write=SetTextVisible, nodefault};
	__property double XScale = {read=FXScale, write=FXScale};
	__property int XSize = {read=FXSize, write=FXSize, nodefault};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TsgSimpleExport* Drawing;
extern PACKAGE int MinDXFSize;

}	/* namespace Cadexport */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Cadexport;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// CADExport
