//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fSHX.h"
#include "fPaths.h"
#include "sgConsts.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfmSHX *fmSHX;
//---------------------------------------------------------------------------
__fastcall TfmSHX::TfmSHX(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfmSHX::FormCreate(TObject *Sender)
{
  LoadOptions();
  cbUseSHXFontsClick(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TfmSHX::LoadOptions(void)
{
  cbUseSHXFonts->Checked = bUseSHXFonts;
  edSHXSearchPath->Text = sSHXSearchPaths;
  edSHXDefaultPath->Text = sDefaultSHXPath;
  edSHXDefaultFont->Text = sDefaultSHXFont;
}
//---------------------------------------------------------------------------

void __fastcall TfmSHX::SaveOptions(void)
{
  bUseSHXFonts = cbUseSHXFonts->Checked;
  sSHXSearchPaths = edSHXSearchPath->Text;
  sDefaultSHXPath = edSHXDefaultPath->Text;
  sDefaultSHXFont = edSHXDefaultFont->Text;
  if (FOptions)
  {
    FOptions->WriteBool(sGeneral, sUseSHX, bUseSHXFonts);
    FOptions->WriteString(sGeneral, sSHXPaths, sSHXSearchPaths);
    FOptions->WriteString(sGeneral, sSHXPath, sDefaultSHXPath);
    FOptions->WriteString(sGeneral, sSHXFont, sDefaultSHXFont);
    #ifdef VER100
    FOptions->UpdateFile;
    #endif
  }
}
//---------------------------------------------------------------------------

void __fastcall TfmSHX::cbUseSHXFontsClick(TObject *Sender)
{
  Panel1->Enabled = cbUseSHXFonts->Checked;
  lblSHXSearchPath->Enabled = cbUseSHXFonts->Checked;
  lblDefautSHXPath->Enabled = cbUseSHXFonts->Checked;
  lblDefaultSHXFont->Enabled = cbUseSHXFonts->Checked;
  bUseSHXFonts = cbUseSHXFonts->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TfmSHX::btnSHXSearchPathClick(TObject *Sender)
{
  AnsiString S = edSHXSearchPath->Text;

  if (GetPathsExcute(&S, true))
    edSHXSearchPath->Text = S;
}
//---------------------------------------------------------------------------
void __fastcall TfmSHX::btnSHXDefaultPathClick(TObject *Sender)
{
  AnsiString vDir = "";
  AnsiString vCaption = "";
  WideString vRoot = "";

  if (SelectDirectory(vCaption, vRoot, &vDir))
    edSHXDefaultPath->Text = vDir;
}
//---------------------------------------------------------------------------

bool SHXOptionsExecute(TIniFile *AOptions, TComponent *AOwner)
{
  int res;
  TfmSHX *fmSHX = new TfmSHX(AOwner);
  fmSHX->FOptions = AOptions;
  fmSHX->LoadOptions();
  res = fmSHX->ShowModal();
  if (res)
    fmSHX->SaveOptions();
  fmSHX->Free();
  return (res != 0);
}
//---------------------------------------------------------------------------
