unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, sgConsts, sgDrawingNavigator;

type
  TForm2 = class(TForm)
    Label1: TLabel;
    edtCoordX: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    edtScale: TEdit;
    Button1: TButton;
    Button2: TButton;
    edtCoordY: TEdit;
    Label4: TLabel;
    edtCoordZ: TEdit;
    lblPercent: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure EditKeyPress(Sender: TObject; var Key: Char);
    procedure EditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

//var
//  Form2: TForm2;

implementation

uses Unit1;

{$R *.dfm}

procedure TForm2.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm2.Button1Click(Sender: TObject);
var
  SearchPoint: TFPoint;
  vScale: Double;
  vExt: TFRect;

  procedure ShowMsg(AText: string);
  begin
    MessageBox(Handle, PChar(AText), 'Show Point Dialog', MB_ICONWARNING);
  end;

  function TryConvert(AEdit: TEdit; var AValue: Double): Boolean;
  var
    vErr: Integer;
    DS: Char;
  begin
    Result := True;
     DS := DecimalSeparator;
    try
      DecimalSeparator := '.';
      Val(AEdit.Text, AValue, vErr);
    finally
      DecimalSeparator := DS;
    end;
    if vErr <> 0 then
    begin
      AEdit.SetFocus;
      AEdit.SelectAll;
      ShowMsg('Invalid floting point value.');
      Result := False;
    end;
  end;

begin
  if Form1.Img = nil then
    ShowMsg('This function don`t work for raster images')
  else
  begin
    vExt := Form1.Img.Extents;
    if TryConvert(edtCoordX, SearchPoint.X) then
    if TryConvert(edtCoordY, SearchPoint.Y) then
    if TryConvert(edtCoordZ, SearchPoint.Z) then
    if TryConvert(edtScale, vScale) then
    if (vExt.Left > SearchPoint.X) or (vExt.Right < SearchPoint.X) or
       (vExt.Top < SearchPoint.Y) or (vExt.Bottom > SearchPoint.Y) then
      ShowMsg('This point not in drawing extents.')
    else
      Form1.sgPaintBox.ShowPoint(SearchPoint, vScale / 100);
  end;
end;

procedure TForm2.FormShow(Sender: TObject);
var
  DS: Char;
begin
  DS := DecimalSeparator;
  try
    DecimalSeparator := '.';
    edtScale.Text := Format('%.3f',[Form1.sgPaintBox.Scale * 100]);
  finally
    DecimalSeparator := DS;
  end;
end;

procedure TForm2.EditKeyPress(Sender: TObject; var Key: Char);
begin
  if Key in [',', DecimalSeparator] then
    Key := '.';
  if not (Key in ['0'..'9', '.', #8, #13, #46, '-', '+', 'E', 'e']) then
    Key := #0;
end;

procedure TForm2.EditChange(Sender: TObject);
var
  I: Integer;
  S: string;
  vSelStart: Integer;
begin
  try
    TEdit(Sender).OnChange := nil;
    try
      vSelStart := TEdit(Sender).SelStart;
      S := TEdit(Sender).Text;
      for I := 1 to Length(S) do
        if S[I] in [',', DecimalSeparator] then
          S[I] := '.';
      TEdit(Sender).Text := S;
    finally
      TEdit(Sender).SelStart := vSelStart;
      TEdit(Sender).OnChange := EditChange;
    end;
  except
  end;
end;

end.
