// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'mSQLAccess.pas' rev: 5.00

#ifndef mSQLAccessHPP
#define mSQLAccessHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <DBCommon.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <msqlTypes.hpp>	// Pascal unit
#include <DBTables.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Bde.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Msqlaccess
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EmSQLException;
class DELPHICLASS TNativeConnect;
class PASCALIMPLEMENTATION TNativeConnect : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FHandle;
	
protected:
	int FStrtStmt;
	void __fastcall GetList(Msqltypes::pm_result Records, Classes::TStrings* List);
	
public:
	Msqltypes::TContainer* Tables;
	bool FLoggin;
	Msqltypes::TDBOptions DBOptions;
	__fastcall TNativeConnect(void);
	__fastcall virtual ~TNativeConnect(void);
	void __fastcall ProcessDBParams(Classes::TStrings* Params);
	void __fastcall InternalConnect(void);
	void __fastcall InternalDisconnect(void);
	int __fastcall CheckResult(int Retcode);
	AnsiString __fastcall GetErrorText(void);
	int __fastcall GetServerStat(void);
	AnsiString __fastcall GetHostInfo(void);
	AnsiString __fastcall GetServerInfo(void);
	void __fastcall SelectDB(char * DBName);
	void __fastcall TableList(Classes::TStrings* List);
	void __fastcall DatabaseList(Classes::TStrings* List);
	void __fastcall OpenTable(char * pszTableName, char * pszIndexName, Word iIndexId, Bde::DBIOpenMode 
		eOpenMode, Bde::DBIShareMode eShareMode, Bde::hDBICur &hCursor);
	void __fastcall QueryAlloc(Bde::hDBIStmt &hStmt);
	void __fastcall QueryPrepare(Bde::hDBIStmt &hStmt, char * Query);
	void __fastcall QExecDirect(Bde::DBIQryLang eQryLang, char * pszQuery, Bde::phDBICur phCur);
	void __fastcall OpenFieldList(char * pszTableName, char * pszDriverType, BOOL bPhyTypes, Bde::hDBICur 
		&hCur);
	void __fastcall OpenIndexList(char * pszTableName, char * pszDriverType, Bde::hDBICur &hCur);
	void __fastcall EmptyTable(Bde::hDBICur hCursor, char * pszTableName);
	__property int Handle = {read=FHandle, write=FHandle, nodefault};
};


class PASCALIMPLEMENTATION EmSQLException : public Sysutils::EAbort 
{
	typedef Sysutils::EAbort inherited;
	
private:
	TNativeConnect* FmSQL;
	Word FBDEErrorCode;
	bool FBDE;
	AnsiString FmSQLErrorMsg;
	AnsiString __fastcall GetNativeErrorMsg(void);
	
public:
	__fastcall EmSQLException(Word ECode);
	__fastcall EmSQLException(Word ECode, const System::ShortString &EMessage);
	__fastcall EmSQLException(TNativeConnect* mSQL);
	__fastcall EmSQLException(TNativeConnect* mSQL, const AnsiString ErrorMsg);
	__property AnsiString mSQLErrorMsg = {read=GetNativeErrorMsg};
	__property Word BDEErrorCode = {read=FBDEErrorCode, nodefault};
	__property bool BDEErrors = {read=FBDE, nodefault};
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EmSQLException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::EAbort(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EmSQLException(int Ident)/* overload */ : Sysutils::EAbort(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EmSQLException(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::EAbort(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EmSQLException(const AnsiString Msg, int AHelpContext)
		 : Sysutils::EAbort(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EmSQLException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::EAbort(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EmSQLException(int Ident, int AHelpContext)/* overload */
		 : Sysutils::EAbort(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EmSQLException(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::EAbort(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EmSQLException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmSQLEngine;
class PASCALIMPLEMENTATION TmSQLEngine : public Msqltypes::TBaseObject 
{
	typedef Msqltypes::TBaseObject inherited;
	
private:
	Bde::_hDBIObj *FCursor;
	Bde::_hDBIObj *FDatabase;
	AnsiString FNativeMsg;
	Bde::_hDBIObj *FStatement;
	Bde::hDBICur __fastcall GetCursor(void);
	void __fastcall SetCursor(Bde::hDBICur H);
	Bde::hDBIDb __fastcall GetDatabase(void);
	void __fastcall SetDatabase(Bde::hDBIDb H);
	Bde::hDBIStmt __fastcall GetStatement(void);
	void __fastcall SetStatement(Bde::hDBIStmt H);
	
public:
	__fastcall TmSQLEngine(System::TObject* P, Msqltypes::TContainer* Container);
	__fastcall virtual ~TmSQLEngine(void);
	__property AnsiString MessageStatus = {read=FNativeMsg};
	__property Bde::hDBIDb Database = {read=GetDatabase, write=SetDatabase};
	__property Bde::hDBICur Cursor = {read=GetCursor, write=SetCursor};
	__property Bde::hDBIStmt Statement = {read=GetStatement, write=SetStatement};
	bool __fastcall IsSqlBased(Bde::hDBIDb hDb);
	Word __fastcall OpenDatabase(Classes::TStrings* Params, Bde::hDBIDb &hDb);
	Word __fastcall CloseDatabase(Bde::hDBIDb &hDb);
	Word __fastcall OpenTable(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, char * pszIndexName
		, char * pszIndexTagName, Word iIndexId, Bde::DBIOpenMode eOpenMode, Bde::DBIShareMode eShareMode, 
		Bde::XLTMode exltMode, BOOL bUniDirectional, void * pOptParams, Bde::hDBICur &hCursor);
	Word __fastcall OpenTableList(Bde::hDBIDb hDb, Classes::TStrings* List);
	Word __fastcall SetToBookMark(Bde::hDBICur hCur, void * pBookMark);
	Word __fastcall CompareBookMarks(Bde::hDBICur hCur, void * pBookMark1, void * pBookMark2, int &CmpBkmkResult
		);
	Word __fastcall GetNextRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * pRecBuff, Bde::pRECProps 
		pRecProps);
	Word __fastcall CloseCursor(Bde::hDBICur hCursor);
	Word __fastcall PutField(Bde::hDBICur hCursor, Word FieldNo, void * PRecord, void * pSrc);
	Word __fastcall OpenBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, Bde::DBIOpenMode eOpenMode
		);
	Word __fastcall GetBlobSize(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int &iSize);
	Word __fastcall GetBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iOffSet, int iLen, 
		void * pDest, int &iRead);
	Word __fastcall PutBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iOffSet, int iLen, 
		void * pSrc);
	Word __fastcall TruncateBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iLen);
	Word __fastcall FreeBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo);
	Word __fastcall GetEngProp(Bde::hDBIObj hObj, int iProp, void * PropValue, Word iMaxLen, Word &iLen
		);
	Word __fastcall SetEngProp(Bde::hDBIObj hObj, int iProp, int PropValue);
	Word __fastcall GetVchkDesc(Bde::hDBICur hCursor, Word iValSeqNo, Bde::pVCHKDesc pvalDesc);
	Word __fastcall GetCursorProps(Bde::hDBICur hCursor, Bde::CURProps &curProps);
	Word __fastcall GetObjFromObj(Bde::hDBIObj Source, Bde::DBIOBJType eObjType, Bde::hDBIObj &hObj);
	Word __fastcall GetFieldDescs(Bde::hDBICur hCursor, Bde::pFLDDesc pfldDesc);
	Word __fastcall SetToBegin(Bde::hDBICur hCursor);
	Word __fastcall SetToEnd(Bde::hDBICur hCursor);
	Word __fastcall RelRecordLock(Bde::hDBICur hCursor, BOOL bAll);
	Word __fastcall InitRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall InsertRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord);
	Word __fastcall AppendRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall ModifyRecord(Bde::hDBICur hCursor, void * OldRecord, void * PRecord, BOOL bFreeLock
		);
	Word __fastcall DeleteRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall SettoSeqNo(Bde::hDBICur hCursor, int iSeqNo);
	Word __fastcall GetPriorRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord, Bde::pRECProps 
		pRecProps);
	Word __fastcall GetRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord, Bde::pRECProps 
		pRecProps);
	Word __fastcall GetBookMark(Bde::hDBICur hCur, void * pBookMark);
	Word __fastcall GetRecordCount(Bde::hDBICur hCursor, int &iRecCount);
	Word __fastcall ForceReread(Bde::hDBICur hCursor);
	Word __fastcall GetField(Bde::hDBICur hCursor, Word FieldNo, void * PRecord, void * pDest, BOOL &bBlank
		);
	Word __fastcall AnsiToNative(char * pNativeStr, char * pAnsiStr, int iLen, BOOL &bDataLoss);
	Word __fastcall NativeToAnsi(char * pAnsiStr, char * pNativeStr, int iLen, BOOL &bDataLoss);
	Word __fastcall AddFilter(Bde::hDBICur hCursor, int iClientData, Word iPriority, BOOL bCanAbort, Bde::pCANExpr 
		pcanExpr, Bde::pfGENFilter pfFilter, Bde::hDBIFilter &hFilter);
	Word __fastcall DropFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall ActivateFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall DeactivateFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall GetErrorEntry(Word uEntry, int &ulNativeError, char * pszError);
	Word __fastcall GetErrorString(Word rslt, AnsiString ErrorMsg);
	Word __fastcall QExecDirect(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, char * pszQuery, Bde::phDBICur 
		phCur);
	Word __fastcall QAlloc(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, Bde::hDBIStmt &hStmt);
	Word __fastcall QPrepare(Bde::hDBIStmt hStmt, char * pszQuery);
	Word __fastcall QExec(Bde::hDBIStmt hStmt, Bde::phDBICur phCur);
	Word __fastcall QPrepareExt(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, char * pszQuery, Word propBits
		, Bde::hDBIStmt &hStmt);
	Word __fastcall QFree(Bde::hDBIStmt &hStmt);
	Word __fastcall QuerySetParams(Bde::hDBIStmt hStmt, Db::TParams* Params, AnsiString SQLText);
	Word __fastcall CheckError(void);
	Word __fastcall GetServerStat(Bde::hDBIDb hDb, int &ServerStat);
	Word __fastcall GetHostInfo(Bde::hDBIDb hDb, AnsiString &HostInfo);
	Word __fastcall GetServerInfo(Bde::hDBIDb hDb, AnsiString &ServerInfo);
	Word __fastcall GetDatabases(Bde::hDBIDb hDb, Classes::TStrings* List);
	Word __fastcall SelectDb(Bde::hDBIDb hDb, char * pszDbName);
	Word __fastcall OpenFieldList(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, BOOL bPhyTypes
		, Bde::hDBICur &hCur);
	Word __fastcall OpenIndexList(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, Bde::hDBICur 
		&hCur);
	Word __fastcall VerifyField(Bde::hDBICur hCursor, Word FieldNo, void * pSrc, BOOL &bBlank);
	Word __fastcall ReadBlock(Bde::hDBICur hCursor, int &iRecords, void * pBuf);
	Word __fastcall EmptyTable(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		);
	Word __fastcall SetRange(Bde::hDBICur hCursor, BOOL bKeyItself, Word iFields1, Word iLen1, void * pKey1
		, BOOL bKey1Incl, Word iFields2, Word iLen2, void * pKey2, BOOL bKey2Incl);
	Word __fastcall ResetRange(Bde::hDBICur hCursor);
	Word __fastcall SwitchToIndex(Bde::hDBICur hCursor, char * pszIndexName, char * pszTagName, Word iIndexId
		, BOOL bCurrRec);
	Word __fastcall ExtractKey(Bde::hDBICur hCursor, void * PRecord, void * pKeyBuf);
	Word __fastcall AddIndex(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		, Bde::IDXDesc &IdxDesc, char * pszKeyviolName);
	Word __fastcall DeleteIndex(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		, char * pszIndexName, char * pszIndexTagName, Word iIndexId);
	Word __fastcall GetIndexDesc(Bde::hDBICur hCursor, Word iIndexSeqNo, Bde::IDXDesc &idxDesc);
	Word __fastcall GetIndexDescs(Bde::hDBICur hCursor, Bde::pIDXDesc idxDesc);
};


#pragma option push -b-
enum TmSQLOpenMode { omUse, omStore };
#pragma option pop

class DELPHICLASS TmSQLField;
class PASCALIMPLEMENTATION TmSQLField : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	#pragma pack(push, 1)
	Bde::FLDDesc FDesc;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Bde::VCHKDesc FValCheck;
	#pragma pack(pop)
	
	void *FBuffer;
	void *FData;
	Msqltypes::TFieldStatus *FStatus;
	Word __fastcall GetLocalSize(void);
	void __fastcall SetLocalSize(Word S);
	Word __fastcall GetLocalType(void);
	void __fastcall SetLocalType(Word S);
	AnsiString __fastcall GetFieldName(void);
	void __fastcall SetFieldName(const AnsiString Value);
	void __fastcall SetBuffer(void * PRecord);
	bool __fastcall GetChanged(void);
	void __fastcall SetChanged(bool Flag);
	bool __fastcall GetNull(void);
	void __fastcall SetNull(bool Flag);
	
public:
	__fastcall TmSQLField(Classes::TCollection* Owner, Bde::pFLDDesc P, Bde::pVCHKDesc P1, Word FNum, Word 
		LType, Word LSize);
	char * __fastcall FieldValue(void);
	__property void * Buffer = {read=FBuffer, write=SetBuffer};
	__property void * Data = {read=FData};
	__property Word DataOffset = {read=FDesc.iOffset, write=FDesc.iOffset, nodefault};
	__property Bde::FLDDesc Description = {read=FDesc, write=FDesc};
	__property Bde::VCHKDesc ValCheck = {read=FValCheck, write=FValCheck};
	__property bool FieldChanged = {read=GetChanged, write=SetChanged, nodefault};
	__property bool FieldNull = {read=GetNull, write=SetNull, nodefault};
	__property Msqltypes::PFieldStatus FieldStatus = {read=FStatus};
	__property Word NullOffset = {read=FDesc.iNullOffset, write=FDesc.iNullOffset, nodefault};
	
__published:
	__property Word FieldNumber = {read=FDesc.iFldNum, write=FDesc.iFldNum, nodefault};
	__property AnsiString FieldName = {read=GetFieldName, write=SetFieldName};
	__property Word FieldType = {read=FDesc.iFldType, write=FDesc.iFldType, nodefault};
	__property Word FieldSubType = {read=FDesc.iSubType, write=FDesc.iSubType, nodefault};
	__property short FieldUnits1 = {read=FDesc.iUnits1, write=FDesc.iUnits1, nodefault};
	__property short FieldUnits2 = {read=FDesc.iUnits2, write=FDesc.iUnits2, nodefault};
	__property Word FieldLength = {read=FDesc.iLen, write=FDesc.iLen, nodefault};
	__property Word NativeType = {read=GetLocalType, write=SetLocalType, nodefault};
	__property Word NativeSize = {read=GetLocalSize, write=SetLocalSize, nodefault};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TmSQLField(Classes::TCollection* Collection)
		 : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TmSQLField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmSQLFields;
class DELPHICLASS TNativeDataSet;
class DELPHICLASS TmSQLIndexes;
class DELPHICLASS TmSQLIndex;
class PASCALIMPLEMENTATION TmSQLIndexes : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TNativeDataSet* FTable;
	TmSQLIndex* __fastcall GetIndex(int Index);
	TmSQLIndex* __fastcall FindByName(AnsiString Name);
	
public:
	__fastcall TmSQLIndexes(TNativeDataSet* Table);
	__property TmSQLIndex* mIndex[int Index] = {read=GetIndex/*, default*/};
	void __fastcall SetIndex(AnsiString Name, AnsiString Fields, bool aPrimary, bool aUnique, bool aDesc
		);
	int __fastcall FieldNumberFromName(char * SearchName);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TmSQLIndexes(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TNativeDataSet : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	int FRecNo;
	TmSQLOpenMode FOpenMode;
	Bde::DBIOpenMode FOMode;
	Msqltypes::m_row *FRow;
	int FRecordCount;
	Msqltypes::m_result *FStatement;
	Msqltypes::TContainer* FFilters;
	bool FFilterActive;
	TmSQLFields* FFieldDescs;
	TmSQLIndexes* FIndexDescs;
	short FKeyNumber;
	char FIndexName[261];
	bool FGetKeyDesc;
	#pragma pack(push, 1)
	Bde::IDXDesc FKeyDesc;
	#pragma pack(pop)
	
	bool Ranges;
	int FRecSize;
	TNativeConnect* FConnect;
	bool FOpen;
	int FAffectedRows;
	int FBookOfs;
	Msqltypes::TRecordState FRecordState;
	Msqltypes::TDir FLastDir;
	void *FCurrentBuffer;
	void *FInternalBuffer;
	bool FIsLocked;
	bool FReRead;
	Classes::TStrings* OrderClause;
	Classes::TStrings* RangeClause;
	Classes::TStrings* StandartClause;
	bool AutoReExec;
	#pragma pack(push, 1)
	Bde::TBLBaseDesc FBaseDesc;
	#pragma pack(pop)
	
	void __fastcall SetInternalBuffer(void * Buffer);
	void * __fastcall GetInternalBuffer(void);
	void * __fastcall GetCurrentBuffer(void);
	void __fastcall SetCurrentBuffer(void * PRecord);
	void __fastcall SetBufferAddress(void * P);
	void __fastcall SetKeyNumber(short newValue);
	Word __fastcall FieldOffset(int iField);
	int __fastcall GetBookMarkSize(void);
	int __fastcall GetIndexCount(void);
	void __fastcall SetBufBookmark(void);
	int __fastcall GetRecordNumber(void);
	int __fastcall GetRecCount(void);
	void __fastcall InitFieldDescs(void);
	void __fastcall CheckFilter(void * PRecord);
	virtual void __fastcall FirstRecord(void);
	void __fastcall LastRecord(void);
	void __fastcall NextRecord(void);
	void __fastcall PrevRecord(void);
	void __fastcall CurrentRecord(int RecNo);
	void __fastcall GetWorkRecord(Bde::DBILockType eLock, void * PRecord);
	void __fastcall GetRecordNo(int &iRecNo);
	void __fastcall LockRecord(Bde::DBILockType eLock);
	bool __fastcall FilteredRecord(void * PRecord);
	void __fastcall UpdateFilterStatus(void);
	int __fastcall FieldCount(void);
	void __fastcall InternalReadBuffer(void);
	char * __fastcall GetTableName(void);
	void __fastcall SetTableName(char * Name);
	void __fastcall GetKeys(bool Unique, int * FieldList, int &FieldCount);
	AnsiString __fastcall GetDeleteSQL(AnsiString Table, void * PRecord);
	AnsiString __fastcall GetInsertSQL(AnsiString Table, void * PRecord);
	AnsiString __fastcall GetUpdateSQL(AnsiString Table, void * OldRecord, void * PRecord);
	System::ShortString __fastcall FieldName(int FieldNum);
	int __fastcall FieldIndex( System::ShortString &FieldName);
	int __fastcall FieldSize(int FieldNum);
	int __fastcall FieldType(int FieldNum);
	bool __fastcall FieldIsNull(int FieldNum);
	AnsiString __fastcall Field(int FieldNum);
	char * __fastcall FieldBuffer(int FieldNum);
	AnsiString __fastcall FieldByName( System::ShortString &FieldName);
	char * __fastcall GetSQLClause(void);
	virtual Word __fastcall GetBufferSize(void);
	virtual Word __fastcall GetWorkBufferSize(void);
	void __fastcall GetNativeDesc(int FieldNo, Bde::pFLDDesc P, Bde::pVCHKDesc P1, Word &LocType, Word 
		&LocSize);
	void __fastcall NativeToDelphi(TmSQLField* P, void * PRecord, void * pDest, BOOL &bBlank);
	void __fastcall DelphiToNative(TmSQLField* P, void * PRecord, void * pSrc);
	void __fastcall CheckParam(bool Exp, Word BDECODE);
	short __fastcall GetRecordSize(void);
	Msqltypes::pm_field __fastcall GetFieldInfo(int Index);
	void __fastcall ReOpenTable(void);
	void __fastcall ClearIndexInfo(void);
	
private:
	__property short KeyNumber = {read=FKeyNumber, write=SetKeyNumber, nodefault};
	__property int RecordNumber = {read=GetRecordNumber, nodefault};
	__property int RecordCount = {read=GetRecCount, nodefault};
	__property TmSQLFields* Fields = {read=FFieldDescs};
	__property short RecordSize = {read=GetRecordSize, nodefault};
	__property Msqltypes::pm_field FieldInfo[int Index] = {read=GetFieldInfo};
	__property int BookMarkSize = {read=GetBookMarkSize, nodefault};
	__property void * BufferAddress = {write=SetBufferAddress};
	__property void * CurrentBuffer = {read=GetCurrentBuffer, write=SetCurrentBuffer};
	__property void * InternalBuffer = {read=GetInternalBuffer, write=SetInternalBuffer};
	__property int IndexCount = {read=GetIndexCount, nodefault};
	
public:
	char *SQLQuery;
	__fastcall TNativeDataSet(TNativeConnect* mSQL, Msqltypes::TContainer* Container, char * Name, char * 
		IndexName, Word Index);
	__fastcall virtual ~TNativeDataSet(void);
	void __fastcall CompareBookMarks(void * pBookMark1, void * pBookMark2, int &CmpBkmkResult);
	void __fastcall GetBookMark(void * P);
	void __fastcall Execute(void);
	void __fastcall OpenTable(void);
	void __fastcall GetField(Word FieldNo, void * PRecord, void * pDest, BOOL &bBlank);
	void __fastcall PutField(Word FieldNo, void * PRecord, void * PSrc);
	void __fastcall CloseTable(void);
	void __fastcall GetVchkDesc(Word iValSeqNo, Bde::pVCHKDesc pvalDesc);
	void __fastcall GetCursorProps(Bde::CURProps &curProps);
	void __fastcall GetFieldDescs(Bde::pFLDDesc pFDesc);
	virtual void __fastcall GetRecordCount(int &iRecCount);
	virtual void __fastcall GetNextRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps
		);
	virtual void __fastcall SetToBookmark(void * P);
	void __fastcall GetRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps);
	void __fastcall GetPriorRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps);
	void __fastcall AddFilter(int iClientData, Word iPriority, BOOL bCanAbort, Bde::pCANExpr pcanExpr, 
		Bde::pfGENFilter pfFilter, Bde::hDBIFilter &hFilter);
	void __fastcall DropFilter(Bde::hDBIFilter hFilter);
	void __fastcall ActivateFilter(Bde::hDBIFilter hFilter);
	void __fastcall DeactivateFilter(Bde::hDBIFilter hFilter);
	void __fastcall GetProp(int iProp, void * PropValue, Word iMaxLen, Word &iLen);
	void __fastcall SetProp(int iProp, int PropValue);
	virtual void __fastcall SetToBegin(void);
	void __fastcall SetToEnd(void);
	void __fastcall ForceReread(void);
	void __fastcall InitRecord(void * PRecord);
	void __fastcall InsertRecord(Bde::DBILockType eLock, void * PRecord);
	void __fastcall AppendRecord(void * PRecord);
	void __fastcall ModifyRecord(void * OldRecord, void * PRecord, BOOL bFreeLock);
	void __fastcall DeleteRecord(void * PRecord);
	void __fastcall SetToRecord(int RecNo);
	void __fastcall OpenBlob(void * PRecord, Word FieldNo, Bde::DBIOpenMode eOpenMode);
	void __fastcall FreeBlob(void * PRecord, Word FieldNo);
	void __fastcall GetBlobSize(void * PRecord, Word FieldNo, int &iSize);
	void __fastcall GetBlob(void * PRecord, Word FieldNo, int iOffSet, int iLen, void * pDest, int &iRead
		);
	void __fastcall PutBlob(void * PRecord, Word FieldNo, int iOffSet, int iLen, void * pSrc);
	void __fastcall TruncateBlob(void * PRecord, Word FieldNo, int iLen);
	void __fastcall QuerySetParams(Db::TParams* Params, AnsiString SQLText);
	void __fastcall RelRecordLock(BOOL bAll);
	void __fastcall ExtractKey(void * PRecord, void * pKeyBuf);
	void __fastcall GetIndexDesc(Word iIndexSeqNo, Bde::IDXDesc &idxDesc);
	void __fastcall GetIndexDescs(Bde::pIDXDesc Desc);
	void __fastcall SetRange(BOOL bKeyItself, Word iFields1, Word iLen1, void * pKey1, BOOL bKey1Incl, 
		Word iFields2, Word iLen2, void * pKey2, BOOL bKey2Incl);
	void __fastcall ResetRange(void);
	void __fastcall SwitchToIndex(char * pszIndexName, char * pszTagName, Word iIndexId, BOOL bCurrRec)
		;
	void __fastcall SettoSeqNo(int iSeqNo);
	__property TmSQLOpenMode OpenMode = {read=FOpenMode, write=FOpenMode, nodefault};
	__property Msqltypes::TRecordState RecordState = {read=FRecordState, write=FRecordState, nodefault}
		;
	__property char * TableName = {read=GetTableName, write=SetTableName};
};


class PASCALIMPLEMENTATION TmSQLFields : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TNativeDataSet* FTable;
	TmSQLField* __fastcall GetField(int Index);
	
public:
	__fastcall TmSQLFields(TNativeDataSet* Table);
	__property TmSQLField* Field[int Index] = {read=GetField/*, default*/};
	void __fastcall SetFields(void * PRecord);
	int __fastcall FieldNumberFromName(char * SearchName);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TmSQLFields(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TmSQLIndex : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	#pragma pack(push, 1)
	Bde::IDXDesc FDesc;
	#pragma pack(pop)
	
	AnsiString __fastcall GetIndexName(void);
	void __fastcall SetIndexName(const AnsiString Value);
	
public:
	__fastcall TmSQLIndex(Classes::TCollection* Owner, Bde::pIDXDesc P);
	__property Bde::IDXDesc Description = {read=FDesc, write=FDesc};
	
__published:
	__property Word IndexNumber = {read=FDesc.iIndexId, write=FDesc.iIndexId, nodefault};
	__property AnsiString IndexName = {read=GetIndexName, write=SetIndexName};
	__property Word Primary = {read=FDesc.bPrimary, write=FDesc.bPrimary, nodefault};
	__property Word Unique = {read=FDesc.bUnique, write=FDesc.bUnique, nodefault};
	__property Word Descending = {read=FDesc.bDescending, write=FDesc.bDescending, nodefault};
	__property Word FldsInKey = {read=FDesc.iFldsInKey, write=FDesc.iFldsInKey, nodefault};
	__property Word KeyLen = {read=FDesc.iKeyLen, write=FDesc.iKeyLen, nodefault};
	__property Word BlockSize = {read=FDesc.iBlockSize, write=FDesc.iBlockSize, nodefault};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TmSQLIndex(Classes::TCollection* Collection)
		 : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TmSQLIndex(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmSQLFilter;
class PASCALIMPLEMENTATION TmSQLFilter : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Variant __fastcall PerformCANOp(Bde::CANOp AOperator, const Variant &AOp1, const Variant &AOp2);
	Variant __fastcall PerformCanConst(Bde::pCANConst ANode, void * ValuesStart, Msqltypes::TFldType &FldType
		);
	System::TDateTime __fastcall TimeOf(const System::TDateTime ADateTime);
	int __fastcall GetPos(const AnsiString SubStr, const AnsiString S, int FromChar);
	
private:
	TNativeDataSet* FDataSet;
	Bde::CANExpr *FExpression;
	BOOL FActive;
	Word FExprSize;
	void *FRecBuff;
	int __fastcall GetLiteralStart(void);
	int __fastcall GetNodeStart(void);
	Bde::pCANNode __fastcall GetNodeByOffset(int AOffSet);
	Variant __fastcall UnaryNode(Bde::pCANUnary ANode);
	Variant __fastcall BinaryNode(Bde::pCANBinary ANode);
	Variant __fastcall CompareNode(Bde::pCANCompare ANode);
	Variant __fastcall FieldNode(Bde::pCANField ANode);
	Variant __fastcall GetNodeValue(int AOffSet);
	Variant __fastcall CalcExpression(Bde::pCANNode ANode);
	__property int LiteralStart = {read=GetLiteralStart, nodefault};
	__property int NodeStart = {read=GetNodeStart, nodefault};
	
public:
	__fastcall TmSQLFilter(TNativeDataSet* Owner, Bde::pCANExpr Exp);
	__fastcall virtual ~TmSQLFilter(void);
	Variant __fastcall GetFilterResult(void * PRecord);
	__property BOOL Active = {read=FActive, write=FActive, nodefault};
};


class DELPHICLASS TIndexList;
class PASCALIMPLEMENTATION TIndexList : public TNativeDataSet 
{
	typedef TNativeDataSet inherited;
	
private:
	void *Descs;
	Word Items;
	Word Position;
	
public:
	__fastcall TIndexList(TNativeConnect* mSQL, void * D, Word TotalCount);
	__fastcall virtual ~TIndexList(void);
	virtual void __fastcall SetToBegin(void);
	virtual void __fastcall GetNextRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps
		);
	virtual Word __fastcall GetBufferSize(void);
	virtual Word __fastcall GetworkBufferSize(void);
	virtual void __fastcall SetToBookmark(void * P);
	virtual void __fastcall GetRecordCount(int &iRecCount);
};


class DELPHICLASS TFieldList;
class PASCALIMPLEMENTATION TFieldList : public TIndexList 
{
	typedef TIndexList inherited;
	
public:
	virtual Word __fastcall GetBufferSize(void);
public:
	#pragma option push -w-inl
	/* TIndexList.Create */ inline __fastcall TFieldList(TNativeConnect* mSQL, void * D, Word TotalCount
		) : TIndexList(mSQL, D, TotalCount) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TIndexList.Destroy */ inline __fastcall virtual ~TFieldList(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Word __fastcall AdjustNativeField(TmSQLField* iField, void * Src, void * Dest, BOOL &
	Blank);
extern PACKAGE Word __fastcall AdjustDelphiField(TmSQLField* iField, void * Src, void * Dest);
extern PACKAGE void __fastcall mSQLException(TNativeConnect* mSQL);
extern PACKAGE void __fastcall mSQLExceptionMsg(TNativeConnect* mSQL, const AnsiString ErrorMsg);

}	/* namespace Msqlaccess */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Msqlaccess;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// mSQLAccess
