/*
 * Decompiled with CFR 0.152.
 */
package com.sciapp.demo;

import com.sciapp.demo.DataFeeder;
import com.sciapp.demo.PersonDetails;
import com.sciapp.demo.PersonTableModel;
import com.sciapp.filter.FilterTablePanel;
import com.sciapp.filter.TableFilterListener;
import com.sciapp.renderers.DateRenderer;
import com.sciapp.renderers.DefaultRenderer;
import com.sciapp.table.AdvancedJScrollPane;
import com.sciapp.table.AdvancedJTable;
import com.sciapp.table.FilterTableModel;
import com.sciapp.table.ListTableModel;
import com.sciapp.table.SortTableModel;
import com.sciapp.tree.TreeTable;
import com.sciapp.tree.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class TreeTableDemoPanel
extends JPanel {
    private JButton addButton;
    private JTextField rowField;
    private JButton removeButton;
    private JButton groupByButton;
    private JCheckBox showLastColumn;
    private JCheckBox singleMode;
    private DataFeeder dataFeeder = new DataFeeder();
    private JTextField rowCompField;
    private AdvancedJTable table;
    private SortTableModel sortTableModel;
    private ListTableModel model;
    private TreeTableModel.RowComparator rowComp;
    private ActionHandler actionHandler = new ActionHandler();
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Float;

    public TreeTableDemoPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = this.createTablePanel();
        JPanel jPanel2 = this.createTableFeaturePanel();
        this.add(jPanel);
        this.add(jPanel2);
    }

    private void action(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.addRows();
        } else if (object == this.removeButton) {
            int[] nArray = this.table.getSelectedRows();
            this.model.removeRows(nArray);
        } else if (object == this.showLastColumn) {
            boolean bl = this.showLastColumn.isSelected();
            this.table.setShowDummyColumn(bl);
        } else if (object == this.singleMode) {
            boolean bl = this.singleMode.isSelected();
            this.sortTableModel.setSortMode(bl ? 1 : 0);
        } else if (object == this.groupByButton) {
            // empty if block
        }
    }

    private void addRows() {
        String string = this.rowField.getText();
        if (string == null) {
            return;
        }
        int n = TreeTableDemoPanel.parseStringToInt(string);
        this.addRows(n);
    }

    private void addRows(int n) {
        if (n == 1) {
            PersonDetails personDetails = this.dataFeeder.nextRow();
            this.model.addRow((Object)personDetails);
        } else if (n > 1) {
            ArrayList arrayList = this.dataFeeder.nextRows(n);
            this.model.addRows((List)arrayList);
        }
    }

    private JPanel createTableFeaturePanel() {
        JPanel jPanel = new JPanel();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new TitledBorder(" Features "), BorderFactory.createEmptyBorder(5, 10, 0, 20));
        jPanel.setBorder(compoundBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addButton = new JButton("Add row(s)");
        this.addButton.addActionListener(this.actionHandler);
        this.rowField = new JTextField(6);
        this.rowField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    TreeTableDemoPanel.this.addRows();
                }
            }
        });
        Dimension dimension = this.rowField.getMaximumSize();
        dimension.height = this.rowField.getPreferredSize().height;
        this.rowField.setMaximumSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.addButton);
        jPanel2.add(this.rowField);
        jPanel2.add(new JLabel("Enter the number of rows you want to add to the table."));
        jPanel.add(jPanel2);
        this.removeButton = new JButton("Remove row(s)");
        this.removeButton.addActionListener(this.actionHandler);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.removeButton);
        jPanel3.add(new JLabel("Remove the selected row(s)."));
        jPanel.add(jPanel3);
        this.showLastColumn = new JCheckBox("Show Last Column", true);
        this.showLastColumn.addActionListener(this.actionHandler);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.showLastColumn);
        jPanel.add(jPanel4);
        this.singleMode = new JCheckBox("Multiple Column Sort Mode", true);
        this.singleMode.addActionListener(this.actionHandler);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.singleMode);
        jPanel.add(jPanel5);
        this.groupByButton = new JButton("Group by column");
        this.groupByButton.addActionListener(this.actionHandler);
        this.rowCompField = new JTextField(6);
        this.rowCompField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    int n = TreeTableDemoPanel.parseStringToInt(TreeTableDemoPanel.this.rowCompField.getText());
                    if (n < 0) {
                        TreeTableDemoPanel.this.rowComp.setColumn(-1);
                    } else if (n < TreeTableDemoPanel.this.model.getColumnCount()) {
                        TreeTableDemoPanel.this.rowComp.setColumn(n);
                    }
                }
            }
        });
        dimension = this.rowCompField.getMaximumSize();
        dimension.height = this.rowCompField.getPreferredSize().height;
        this.rowCompField.setMaximumSize(dimension);
        this.rowCompField.setText("0");
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(this.groupByButton);
        jPanel6.add(this.rowCompField);
        jPanel6.add(new JLabel("Enter the grouping column."));
        jPanel.add(jPanel6);
        return jPanel;
    }

    private JPanel createTablePanel() {
        PersonTableModel personTableModel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new TitledBorder(" Table "), BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setBorder(compoundBorder);
        PersonTableModel personTableModel2 = personTableModel = new PersonTableModel();
        FilterTableModel filterTableModel = new FilterTableModel((ListTableModel)personTableModel2);
        SortTableModel sortTableModel = new SortTableModel((ListTableModel)filterTableModel);
        this.table = new TreeTable((ListTableModel)sortTableModel);
        AdvancedJScrollPane advancedJScrollPane = new AdvancedJScrollPane(22, 32);
        advancedJScrollPane.setViewportView((Component)this.table);
        sortTableModel.setHeader(this.table.getTableHeader());
        this.model = (ListTableModel)this.table.getModel();
        this.sortTableModel = sortTableModel;
        this.rowComp = (TreeTableModel.RowComparator)((TreeTableModel)this.model).getRowComparator();
        DateRenderer dateRenderer = (DateRenderer)this.table.getDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = TreeTableDemoPanel.class$("java.util.Date")) : class$java$util$Date);
        dateRenderer.setDateFormat(DateFormat.getDateInstance());
        this.addRows(2);
        Color color = new Color(194, 194, 194);
        DefaultRenderer defaultRenderer = (DefaultRenderer)this.table.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = TreeTableDemoPanel.class$("java.lang.Object")) : class$java$lang$Object);
        defaultRenderer.setOddColor(color);
        defaultRenderer = (DefaultRenderer)this.table.getDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TreeTableDemoPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        defaultRenderer.setOddColor(color);
        defaultRenderer = (DefaultRenderer)this.table.getDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = TreeTableDemoPanel.class$("java.lang.Number")) : class$java$lang$Number);
        defaultRenderer.setOddColor(color);
        defaultRenderer = (DefaultRenderer)this.table.getDefaultRenderer(class$java$lang$Float == null ? (class$java$lang$Float = TreeTableDemoPanel.class$("java.lang.Float")) : class$java$lang$Float);
        defaultRenderer.setOddColor(color);
        defaultRenderer = (DefaultRenderer)this.table.getDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = TreeTableDemoPanel.class$("java.util.Date")) : class$java$util$Date);
        defaultRenderer.setOddColor(color);
        FilterTablePanel filterTablePanel = new FilterTablePanel((TableModel)filterTableModel);
        filterTablePanel.addTableFilterListener((TableFilterListener)filterTableModel);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(new TitledBorder(" Filter "), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        filterTablePanel.setBorder((Border)compoundBorder2);
        jPanel.add((Component)advancedJScrollPane, "Center");
        jPanel.add((Component)filterTablePanel, "North");
        return jPanel;
    }

    private static int parseStringToInt(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeTableDemoPanel.this.action(actionEvent);
        }
    }
}

