unit SelGrMemb;

{$IFDEF CONDITIONALEXPRESSIONS}
{$IF RTLVersion >= 14.0}
{$DEFINE D6_UP}
{$IFEND}
{$ENDIF}

interface

uses Classes, Controls, Forms, StdCtrls, WabObj;

type
  TSelGrMembForm = class(TForm)
    AllContactsLB: TListBox;
    SelContactsLB: TListBox;
    Label1: TLabel;
    OKBtn: TButton;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure SelectBtnClick(Sender: TObject);
    procedure UnselBtnClick(Sender: TObject);
  private
    procedure UpdateSelContacts;
  public
    WAB: TWAB;
    SelContacts: TList;
  end;

var
  SelGrMembForm: TSelGrMembForm;

implementation

uses {$IFDEF D6_UP} Variants, {$ENDIF} WabTags;

{$R *.dfm}

procedure TSelGrMembForm.FormShow(Sender: TObject);
var
  I: Integer;
begin
  with AllContactsLB.Items do
  begin
   BeginUpdate;
   try
    Clear;
    for I := 0 to WAB.ContactCount - 1 do
     AddObject(WAB[I].PropByTag[PR_DISPLAY_NAME], WAB[I]);
   finally
    EndUpdate;
   end;
  end;
  UpdateSelContacts;
end;

procedure TSelGrMembForm.UpdateSelContacts;
var
  I: Integer;
begin
  with SelContactsLB.Items do
  begin
   BeginUpdate;
   try
    Clear;
    for I := 0 to SelContacts.Count - 1 do
     AddObject(TWABcontact(SelContacts[I]).PropByTag[PR_DISPLAY_NAME], SelContacts[I]);
   finally
    EndUpdate;
   end;
  end;
end;

procedure TSelGrMembForm.OKBtnClick(Sender: TObject);
var
  I: Integer;
begin
  SelContacts.Clear;
  with SelContactsLB.Items do
   for I := 0 to Count - 1 do
    if SelContacts.IndexOf(Objects[I]) < 0 then
     SelContacts.Add(Objects[I]);
end;

procedure TSelGrMembForm.SelectBtnClick(Sender: TObject);
var
  I: Integer;
begin
  with AllContactsLB do
   for I := 0 to Items.Count - 1 do
    if Selected[I] then
     SelContactsLB.Items.AddObject(Items[I], Items.Objects[I]);
end;

procedure TSelGrMembForm.UnselBtnClick(Sender: TObject);
var
  I: Integer;           
begin
  with SelContactsLB do
   for I := Items.Count - 1 downto 0 do
    if Selected[I] then
     Items.Delete(I);
end;

end.  
