#ifndef RuleStatus_Hdr
#define RuleStatus_Hdr

typedef	CArray <int, const int&> CIntArray;

/*======================================================================*/
/* RuleStatus															*/
/*	- keeps the current status info for all the Rules.					*/
/*	- it is organized like a stack of integers.							*/
/*	- the actual storage for the status values is an int array. This	*/
/*	  class has a reference to this array.								*/
/*	- in order to signal to a rule that the getNextLength call is a new	*/
/*	  one (as opposite to a call intended to generate the next possible	*/
/*	  token), the startIdx is used. This variable is used in order to 	*/
/*	  deny to a Rule to use any integer in the array that are stored at	*/
/*	  indexes lesser than startIdx (see definition of isEmpty())		*/
/*======================================================================*/

class RuleStatus
{
public:
					RuleStatus (CIntArray* _storage = NULL, int _startIdx = 0);

	bool			isEmpty (void) const;
	int				pop (void);
	void			push (int value);
	RuleStatus		beginChildSection (void);
private:
	int				startIdx;
	CIntArray*		storage;
};

/*======================================================================*/
/* RuleStatus constructor												*/
/*======================================================================*/

inline RuleStatus::RuleStatus (
	CIntArray* _storage /*= NULL*/,
	int _startIdx /*= 0*/
	)
	: startIdx (_startIdx),
	storage (_storage)
{
}

inline bool RuleStatus::isEmpty (void) const
{
	return storage->GetUpperBound() < startIdx;
}

inline int RuleStatus::pop (void)
{
	_ASSERTE (!isEmpty());

	int topIdx = storage->GetUpperBound();
	int value = storage->GetAt (topIdx);

	storage->RemoveAt (topIdx);
	return value;
}

inline void RuleStatus::push (
	int value
	)
{
	storage->Add (value);
}

inline RuleStatus RuleStatus::beginChildSection (
	void								// no argument
	)
{
	return RuleStatus (storage, storage->GetSize());
}

#endif // RuleStatus_Hdr
