// ChildFrm.cpp : implementation of the CChildFrame class
//
// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include "stdafx.h"
#include "HexEdit.h"

#include "ChildFrm.h"
#include <afxpriv.h>            // for WM_HELPHITTEST

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
        //{{AFX_MSG_MAP(CChildFrame)
        //}}AFX_MSG_MAP
        ON_WM_SYSCOMMAND()
        ON_MESSAGE(WM_HELPHITTEST, OnHelpHitTest)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
}

CChildFrame::~CChildFrame()
{
}


/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
        CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
        CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers

// Handles control menu commands and system buttons (Minimize etc)
void CChildFrame::OnSysCommand(UINT nID, LONG lParam)
{
    CMDIChildWnd::OnSysCommand(nID, lParam);

    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    nID &= 0xFFF0;
    if (nID == SC_MINIMIZE || nID == SC_RESTORE || nID == SC_MAXIMIZE ||
        nID == SC_NEXTWINDOW || nID == SC_PREVWINDOW || nID == SC_CLOSE)
    {
        if ((nID == SC_NEXTWINDOW || nID == SC_PREVWINDOW || nID == SC_CLOSE) &&
            aa->recording_ && aa->mac_.size() > 0 && (aa->mac_.back()).ktype == km_focus)
        {
            // Next win, prev. win, close win cause focus change which causes a km_focus
            // for a particular window to be stored.  On replay, we don't want to
            // change to this window before executing this command.
            aa->mac_.pop_back();
        }
        aa->SaveToMacro(km_childsys, nID);
    }
}

// Handles Shift-F1 help when clicked within the window (lParam contains
// point in high and low words).  At the moment nothing is done, so all
// help goes to the same place (HIDR_HEXEDTYPE).
LRESULT CChildFrame::OnHelpHitTest(WPARAM wParam, LPARAM lParam)
{
    // Intercept call so we can check what happens in debugger xxx
    LRESULT retval = CMDIChildWnd::OnHelpHitTest(wParam, lParam);
    return retval;
}
