// Dialog.cpp : implementation file
//
// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include "stdafx.h"
#include "HexEdit.h"
#include "Dialog.h"
#include "resource.hm"
#include "HelpID.hm"            // User defined help IDs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultiplay dialog


CMultiplay::CMultiplay(CWnd* pParent /*=NULL*/)
        : CDialog(CMultiplay::IDD, pParent)
{
        //{{AFX_DATA_INIT(CMultiplay)
        plays_ = 0;
        //}}AFX_DATA_INIT
}

void CMultiplay::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CMultiplay)
        DDX_Text(pDX, IDC_PLAYS, plays_);
        DDV_MinMaxLong(pDX, plays_, 1, 999999);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMultiplay, CDialog)
        //{{AFX_MSG_MAP(CMultiplay)
        ON_BN_CLICKED(IDC_PLAY_OPTIONS, OnPlayOptions)
        ON_WM_HELPINFO()
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultiplay message handlers
void CMultiplay::OnPlayOptions() 
{
    // Invoke the Options dlg with the macro page displayed
    ((CHexEditApp *)AfxGetApp())->OnOptions3() ;
}

BOOL CMultiplay::OnInitDialog() 
{
        CDialog::OnInitDialog();

        ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
        ((CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_PLAYS))->SetRange(1, 999999);

        return TRUE;
}

BOOL CMultiplay::OnHelpInfo(HELPINFO* pHelpInfo) 
{
    static DWORD id_pairs[] = { 
        IDC_PLAY_OPTIONS, HIDC_PLAY_OPTIONS,
        IDC_PLAYS, HIDC_PLAYS,
        IDC_SPIN_PLAYS, HIDC_PLAYS,
        IDOK, HID_MULTIPLAY_OK,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, 
                   HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
// CSaveMacro dialog


CSaveMacro::CSaveMacro(CWnd* pParent /*=NULL*/)
        : CDialog(CSaveMacro::IDD, pParent)
{
        //{{AFX_DATA_INIT(CSaveMacro)
        plays_ = 0;
        name_ = _T("");
        comment_ = _T("");
        halt_level_ = -1;
        //}}AFX_DATA_INIT
        halt_level_ = 1;
}

void CSaveMacro::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CSaveMacro)
        DDX_Text(pDX, IDC_PLAYS, plays_);
	DDV_MinMaxLong(pDX, plays_, 1, 999999);
        DDX_Text(pDX, IDC_MACRO_NAME, name_);
        DDX_Text(pDX, IDC_MACRO_COMMENT, comment_);
        DDX_Radio(pDX, IDC_HALT0, halt_level_);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSaveMacro, CDialog)
        //{{AFX_MSG_MAP(CSaveMacro)
        ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_MACRO_HELP, OnMacroHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSaveMacro message handlers

BOOL CSaveMacro::OnInitDialog() 
{
    aa_ = dynamic_cast<CHexEditApp *>(AfxGetApp());
    name_ = aa_->mac_filename_;
    plays_ = aa_->plays_;
    comment_ = aa_->mac_comment_;
//    halt_level_ = aa_->halt_level_;

    CDialog::OnInitDialog();

    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ((CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_PLAYS))->SetRange(1, 999999);

    return TRUE;
}

void CSaveMacro::OnOK() 
{
    if (!UpdateData(TRUE))
        return;                         // DDV failed

    if (name_.IsEmpty())
    {
        ::HMessageBox("Please enter a macro name");
        ASSERT(GetDlgItem(IDC_MACRO_NAME) != NULL);
        GetDlgItem(IDC_MACRO_NAME)->SetFocus();
        return;
    }

    // If the macro was saved OK end the dialog
    ASSERT(aa_->mac_dir_.Right(1) == "\\");
    if (aa_->macro_save(aa_->mac_dir_ + name_ + ".hem", NULL, comment_, halt_level_, plays_))
        CDialog::OnOK();
}

BOOL CSaveMacro::OnHelpInfo(HELPINFO* pHelpInfo) 
{
    static DWORD id_pairs[] = {
        IDC_MACRO_NAME, HIDC_MACRO_NAME,
        IDC_MACRO_COMMENT, HIDC_MACRO_COMMENT,
        IDC_PLAYS, HIDC_PLAYS,
        IDC_SPIN_PLAYS, HIDC_PLAYS,
        IDC_HALT0, HIDC_HALT0,
        IDC_HALT1, HIDC_HALT1,
        IDC_HALT2, HIDC_HALT2,
        IDOK, HID_MACRO_SAVE,
        IDC_MACRO_HELP, HIDC_HELP_BUTTON,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, 
                   HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

void CSaveMacro::OnMacroHelp() 
{
    // Display help for the dialog
    if (!::WinHelp(AfxGetMainWnd()->m_hWnd, AfxGetApp()->m_pszHelpFilePath,
                   HELP_CONTEXT, HIDD_MACRO_SAVE_HELP))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
}
