;
; [1] '
;
; [2] '
;
; [3] ' ####################
;
; [4] ' #####  PROLOG  #####
;
; [5] ' ####################
;
; [6] '
;
; [7] 'MAKEFILE "makexformat.mak"
;
; [9] PROGRAM	"xformat"
;
; [10] VERSION	"0.0002"
;
; [11] '
;
; [12] IMPORT	"xst"' Standard library : required by most programs
;
; [13] '
;
; [14] DECLARE FUNCTION  XFormat ()
;
; [15] EXPORT
;
; [16] DECLARE FUNCTION  ValidFormat (format$, validPtr)
;
; [17] DECLARE FUNCTION  XxxFormat$ (format$, argType, arg$$)
;
; [19] END EXPORT
;
; [20] '
;
; [21] '
;
; [22] ' ############################
;
; [23] ' #####  ValidFormat ()  #####
;
; [24] ' ############################
;
; [25] '
;
; [26] FUNCTION  ValidFormat (format$, validPtr)
.code
	jmp	%_StartLibrary_xformat			;;; i156
PrologCode.xformat:
	ret				;;; i158 ;;; end prolog code
;
#ifdef ValidFormat.format$
#undef ValidFormat.format$
#endif
#define ValidFormat.format$ ebp+8	; exposes function argument 'format$'
;
;
#ifdef ValidFormat.validPtr
#undef ValidFormat.validPtr
#endif
#define ValidFormat.validPtr ebp+12	; exposes function argument 'validPtr'
;
align 16
_ValidFormat@8:
;  *****
;  *****  FUNCTION  ValidFormat ()  *****
;  *****
func2.xformat:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBody2.xformat:
;
; [27] STATIC	UBYTE  fmtSeq[]
data section 'globals$statics'
align	4
%%2%%fmtSeq.xformat:	db 4 dup ?
.code
;
; [28] '
;
; [29] IFZ fmtSeq[] THEN GOSUB Initialize
	mov	eax,d[%%2%%fmtSeq.xformat]			;;; i663a
	test	eax,eax			;;; i194
	jnz	>> else.0001.xformat			;;; i195
	call	%s%Initialize%2			;;; i163
else.0001.xformat:
end.if.0001.xformat:
;
; [30] IFZ format$ THEN RETURN ($$FALSE)
	mov	eax,[ebp+8]			;;; i665
	test	eax,eax			;;; i188
	jz	> A.1			;;; i189
	mov	eax,d[eax-8]			;;; i190
	test	eax,eax			;;; i191
	jnz	>> else.0002.xformat			;;; i192
A.1:
	mov	eax,0			;;; i659
	jmp	end.func2.xformat			;;; i258
else.0002.xformat:
end.if.0002.xformat:
;
; [31] valid = $$FALSE
;
#ifdef ValidFormat.valid
#undef ValidFormat.valid
#endif
#define ValidFormat.valid ebp-24	; exposes local variable 'valid'
;
	mov	eax,0			;;; i659
	mov	d[ebp-24],eax			;;; i670
;
; [32] '
;
; [33] ' format is invalid if not part of ascending value sequence
;
; [34] ' (else) format is valid if the next format character can become a digit
;
; [35] '
;
; [36] DO
align 8
do.0003.xformat:
;
; [37] now = format${validPtr}
;
#ifdef ValidFormat.now
#undef ValidFormat.now
#endif
#define ValidFormat.now ebp-28	; exposes local variable 'now'
;
	mov	eax,d[ebp+12]			;;; i665
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-28],eax			;;; i670
;
; [38] nxt = format${validPtr+1}
;
#ifdef ValidFormat.nxt
#undef ValidFormat.nxt
#endif
#define ValidFormat.nxt ebp-32	; exposes local variable 'nxt'
;
	mov	eax,d[ebp+12]			;;; i665
	add	eax,1			;;; i775
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-32],eax			;;; i670
;
; [39] IF (fmtSeq[now] >= fmtSeq[nxt]) THEN valid = $$FALSE : EXIT DO
	mov	eax,d[ebp-28]			;;; i665
	mov	edx,d[%%2%%fmtSeq.xformat]			;;; i663a
	movzx	eax,b[edx+eax]			;;; i464
	mov	ebx,d[ebp-32]			;;; i665
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	movzx	ebx,b[ecx+ebx]			;;; i464
	cmp	eax,ebx			;;; i684a
	jl	>> else.0004.xformat			;;; i219
	mov	eax,0			;;; i659
	mov	d[ebp-24],eax			;;; i670
	jmp	end.do.0003.xformat			;;; i144
else.0004.xformat:
end.if.0004.xformat:
;
; [40] IF ((nxt = '*') OR (nxt = '#') OR (nxt = ',')) THEN valid = $$TRUE : EXIT DO
	mov	eax,d[ebp-32]			;;; i665
	cmp	eax,42			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.2			;;; i467
	not	eax			;;; i468
A.2:
;+peep
	mov	ebx,d[ebp-32]			;;; i665
	cmp	ebx,35			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.3			;;; i467
	not	ebx			;;; i468
A.3:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-32]			;;; i665
	cmp	ebx,44			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.4			;;; i467
	not	ebx			;;; i468
A.4:
;+peep
	or	eax,ebx			;;; i763
	test	eax,eax			;;; i220
	jz	>> else.0005.xformat			;;; i221
	mov	eax,-1			;;; i659
	mov	d[ebp-24],eax			;;; i670
	jmp	end.do.0003.xformat			;;; i144
else.0005.xformat:
end.if.0005.xformat:
;
; [41] INC validPtr
	inc	d[ebp+12]			;;; i84
;
; [42] LOOP
do.loop.0003.xformat:
	jmp	do.0003.xformat			;;; i222
end.do.0003.xformat:
;
; [43] RETURN (valid)
	mov	eax,d[ebp-24]			;;; i665
	jmp	end.func2.xformat			;;; i258
;
; [44] '
;
; [45] ' *****  Initialize  *****
;
; [46] '
;
; [47] SUB Initialize
	jmp	out.sub2.0.xformat			;;; i262
align 16
%s%Initialize%2:
;
; .sub2.0000 = ebp-36	; internal variable
;
; [48] DIM fmtSeq[255]
	sub	esp,64			;;; i430
	mov	eax,255			;;; i659
	mov	d[esp+16],eax			;;; i432
	mov	esi,d[%%2%%fmtSeq.xformat]			;;; i663a
	mov	d[esp],esi			;;; i433
	mov	d[esp+4],1			;;; i434
	mov	d[esp+8],-1073545215			;;; i435
	mov	d[esp+12],0			;;; i436
	call	%_DimArray			;;; i437
	add	esp,64			;;; i438
	mov	d[%%2%%fmtSeq.xformat],eax			;;; i668
;
; [49] fmtSeq['+'] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+43]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [50] fmtSeq['-'] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+45]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [51] fmtSeq['('] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+40]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [52] fmtSeq['*'] =  50
	mov	eax,50			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+42]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [53] fmtSeq['$'] =  60
	mov	eax,60			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+36]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [54] fmtSeq[','] =  80
	mov	eax,80			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+44]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [55] fmtSeq['.'] =  90
	mov	eax,90			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+46]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [56] fmtSeq['#'] = 100
	mov	eax,100			;;; i659
	mov	ecx,d[%%2%%fmtSeq.xformat]			;;; i663a
	lea	ebx,[ecx+35]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [57] END SUB
end.sub2.0.xformat:
	ret				;;; i127
out.sub2.0.xformat:
;
; [59] END FUNCTION
	xor	eax,eax			;;; i862
align 8
end.ValidFormat.xformat:  ;;; Function end label for Assembly Programmers.
end.func2.xformat:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  ValidFormat ()  *****
;  *****
;
; [60] '
;
; [61] '
;
; [62] ' ###########################
;
; [63] ' #####  XxxFormat$ ()  #####
;
; [64] ' ###########################
;
; [65] '
;
; [66] FUNCTION  XxxFormat$ (format$, argType, arg$$)
.code
;
#ifdef XxxFormat$.format$
#undef XxxFormat$.format$
#endif
#define XxxFormat$.format$ ebp+8	; exposes function argument 'format$'
;
;
#ifdef XxxFormat$.argType
#undef XxxFormat$.argType
#endif
#define XxxFormat$.argType ebp+12	; exposes function argument 'argType'
;
;
#ifdef XxxFormat$.arg$$
#undef XxxFormat$.arg$$
#endif
#define XxxFormat$.arg$$ ebp+16	; exposes function argument 'arg$$'
;
align 16
_XxxFormat$@16:
;  *****
;  *****  FUNCTION  XxxFormat$ ()  *****
;  *****
func3.xformat:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	mov	ecx,8				;;; ..
	xor	eax,eax			;;; ...
A.54:
	push	eax, eax, eax, eax
	push	eax, eax, eax, eax
	dec	ecx					;;; ....
	jnz	< A.54			;;; .....
	push	eax				;;; ......
	push	eax				;;; ......
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,268
	sub	esp,4			;;; i114a
;
funcBody3.xformat:
;
; [68] STATIC	UBYTE  fmtLevel[]
data section 'globals$statics'
align	4
%%3%%fmtLevel.xformat:	db 4 dup ?
.code
;
; [69] STATIC	UBYTE  fmtBegin[]
data section 'globals$statics'
align	4
%%3%%fmtBegin.xformat:	db 4 dup ?
.code
;
; [70] '
;
; [71] '	PRINT "FORMAT$() : <"; format$; "> <"; STRING$(argType); "> <"; STRING$(arg$$); ">"
;
; [72] '
;
; [73] IFZ fmtLevel[] THEN GOSUB Initialize
	mov	eax,d[%%3%%fmtLevel.xformat]			;;; i663a
	test	eax,eax			;;; i194
	jnz	>> else.0006.xformat			;;; i195
	call	%s%Initialize%3			;;; i163
else.0006.xformat:
end.if.0006.xformat:
;
; [74] IFZ format$ THEN RETURN' empty format string
	mov	eax,[ebp+8]			;;; i665
	test	eax,eax			;;; i188
	jz	> A.8			;;; i189
	mov	eax,d[eax-8]			;;; i190
	test	eax,eax			;;; i191
	jnz	>> else.0007.xformat			;;; i192
A.8:
	xor	eax,eax			;;; i862
	jmp	end.func3.xformat			;;; i258
else.0007.xformat:
end.if.0007.xformat:
;
; [75] '
;
; [76] IF (argType = $$STRING) THEN arg$ = CSTRING$(GLOW(arg$$))
	mov	eax,d[ebp+12]			;;; i665
	cmp	eax,19			;;; i684a
	jne	>> else.0008.xformat			;;; i219
;
#ifdef XxxFormat$.arg$
#undef XxxFormat$.arg$
#endif
#define XxxFormat$.arg$ ebp-24	; exposes local variable 'arg$'
;
	sub	esp,64			;;; i487
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	add	esp,64			;;; i600
	mov	d[esp],eax			;;; i887
	call	%_cstring.d			;;; i573
	add	esp,64			;;; i600
	lea	ebx,[ebp-24]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
else.0008.xformat:
end.if.0008.xformat:
;
; [77] '
;
; [78] fmtStrPtr = 1
;
#ifdef XxxFormat$.fmtStrPtr
#undef XxxFormat$.fmtStrPtr
#endif
#define XxxFormat$.fmtStrPtr ebp-28	; exposes local variable 'fmtStrPtr'
;
	mov	eax,1			;;; i659
	mov	d[ebp-28],eax			;;; i670
;
; [79] lenFmtStr = LEN (format$)
;
#ifdef XxxFormat$.lenFmtStr
#undef XxxFormat$.lenFmtStr
#endif
#define XxxFormat$.lenFmtStr ebp-32	; exposes local variable 'lenFmtStr'
;
	mov	eax,d[ebp+8]			;;; i665
	test	eax,eax			;;; i593
	jz	> A.9			;;; i594
	mov	eax,d[eax-8]			;;; i595
A.9:
	mov	d[ebp-32],eax			;;; i670
;
; [80] GOSUB StringString'	top StringString call
	call	%s%StringString%3			;;; i163
;
; [81] '
;
; [82] IFZ fmtStrPtr THEN
	mov	eax,d[ebp-28]			;;; i665
	test	eax,eax			;;; i194
	jnz	>> else.0009.xformat			;;; i195
;
; [83] '		PRINT "a<" + resultString$ + "> " + STRING$(LEN(resultString$))
;
; [84] RETURN (resultString$)
;
#ifdef XxxFormat$.resultString$
#undef XxxFormat$.resultString$
#endif
#define XxxFormat$.resultString$ ebp-36	; exposes local variable 'resultString$'
;
	mov	eax,[ebp-36]			;;; i665
	call	%_clone.a0			;;; i870
	jmp	end.func3.xformat			;;; i258
;
; [85] END IF
else.0009.xformat:
end.if.0009.xformat:
;
; [86] '
;
; [87] ' initialize argument counters, flags, etc.
;
; [88] '
;
; [89] argH	= 0
;
#ifdef XxxFormat$.argH
#undef XxxFormat$.argH
#endif
#define XxxFormat$.argH ebp-40	; exposes local variable 'argH'
;
	mov	eax,0			;;; i659
	mov	d[ebp-40],eax			;;; i670
;
; [90] argL	= 0
;
#ifdef XxxFormat$.argL
#undef XxxFormat$.argL
#endif
#define XxxFormat$.argL ebp-44	; exposes local variable 'argL'
;
	mov	eax,0			;;; i659
	mov	d[ebp-44],eax			;;; i670
;
; [91] arg&&	= 0
;
#ifdef XxxFormat$.arg
#undef XxxFormat$.arg
#endif
#define XxxFormat$.arg ebp-48	; exposes local variable 'arg&&'
;
	mov	eax,0			;;; i659
	or	eax,eax			;;; i366
	jns	> A.10			;;; i367
	call	%_eeeOverflow			;;; i368
A.10:
	mov	d[ebp-48],eax			;;; i670
;
; [92] lenArg = 0
;
#ifdef XxxFormat$.lenArg
#undef XxxFormat$.lenArg
#endif
#define XxxFormat$.lenArg ebp-52	; exposes local variable 'lenArg'
;
	mov	eax,0			;;; i659
	mov	d[ebp-52],eax			;;; i670
;
; [93] negArg = 0
;
#ifdef XxxFormat$.negArg
#undef XxxFormat$.negArg
#endif
#define XxxFormat$.negArg ebp-56	; exposes local variable 'negArg'
;
	mov	eax,0			;;; i659
	mov	d[ebp-56],eax			;;; i670
;
; [94] argStr$	= ""
;
#ifdef XxxFormat$.argStr$
#undef XxxFormat$.argStr$
#endif
#define XxxFormat$.argStr$ ebp-60	; exposes local variable 'argStr$'
;
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [95] argDPLoc = 0
;
#ifdef XxxFormat$.argDPLoc
#undef XxxFormat$.argDPLoc
#endif
#define XxxFormat$.argDPLoc ebp-64	; exposes local variable 'argDPLoc'
;
	mov	eax,0			;;; i659
	mov	d[ebp-64],eax			;;; i670
;
; [96] numShift = 0
;
#ifdef XxxFormat$.numShift
#undef XxxFormat$.numShift
#endif
#define XxxFormat$.numShift ebp-68	; exposes local variable 'numShift'
;
	mov	eax,0			;;; i659
	mov	d[ebp-68],eax			;;; i670
;
; [97] argExpIx = 0
;
#ifdef XxxFormat$.argExpIx
#undef XxxFormat$.argExpIx
#endif
#define XxxFormat$.argExpIx ebp-72	; exposes local variable 'argExpIx'
;
	mov	eax,0			;;; i659
	mov	d[ebp-72],eax			;;; i670
;
; [98] argExpVal = 0
;
#ifdef XxxFormat$.argExpVal
#undef XxxFormat$.argExpVal
#endif
#define XxxFormat$.argExpVal ebp-76	; exposes local variable 'argExpVal'
;
	mov	eax,0			;;; i659
	mov	d[ebp-76],eax			;;; i670
;
; [99] argMSDOrder	= 0
;
#ifdef XxxFormat$.argMSDOrder
#undef XxxFormat$.argMSDOrder
#endif
#define XxxFormat$.argMSDOrder ebp-80	; exposes local variable 'argMSDOrder'
;
	mov	eax,0			;;; i659
	mov	d[ebp-80],eax			;;; i670
;
; [100] '
;
; [101] ' initialize format counters, flags, etc.
;
; [102] '
;
; [103] fmtChar = 0
;
#ifdef XxxFormat$.fmtChar
#undef XxxFormat$.fmtChar
#endif
#define XxxFormat$.fmtChar ebp-84	; exposes local variable 'fmtChar'
;
	mov	eax,0			;;; i659
	mov	d[ebp-84],eax			;;; i670
;
; [104] lastChar = 0
;
#ifdef XxxFormat$.lastChar
#undef XxxFormat$.lastChar
#endif
#define XxxFormat$.lastChar ebp-88	; exposes local variable 'lastChar'
;
	mov	eax,0			;;; i659
	mov	d[ebp-88],eax			;;; i670
;
; [105] nextChar = 0
;
#ifdef XxxFormat$.nextChar
#undef XxxFormat$.nextChar
#endif
#define XxxFormat$.nextChar ebp-92	; exposes local variable 'nextChar'
;
	mov	eax,0			;;; i659
	mov	d[ebp-92],eax			;;; i670
;
; [106] levelNow = 0
;
#ifdef XxxFormat$.levelNow
#undef XxxFormat$.levelNow
#endif
#define XxxFormat$.levelNow ebp-96	; exposes local variable 'levelNow'
;
	mov	eax,0			;;; i659
	mov	d[ebp-96],eax			;;; i670
;
; [107] levelNext = 0
;
#ifdef XxxFormat$.levelNext
#undef XxxFormat$.levelNext
#endif
#define XxxFormat$.levelNext ebp-100	; exposes local variable 'levelNext'
;
	mov	eax,0			;;; i659
	mov	d[ebp-100],eax			;;; i670
;
; [108] nPlaces = 0
;
#ifdef XxxFormat$.nPlaces
#undef XxxFormat$.nPlaces
#endif
#define XxxFormat$.nPlaces ebp-104	; exposes local variable 'nPlaces'
;
	mov	eax,0			;;; i659
	mov	d[ebp-104],eax			;;; i670
;
; [109] preDec = 0
;
#ifdef XxxFormat$.preDec
#undef XxxFormat$.preDec
#endif
#define XxxFormat$.preDec ebp-108	; exposes local variable 'preDec'
;
	mov	eax,0			;;; i659
	mov	d[ebp-108],eax			;;; i670
;
; [110] postDec = 0
;
#ifdef XxxFormat$.postDec
#undef XxxFormat$.postDec
#endif
#define XxxFormat$.postDec ebp-112	; exposes local variable 'postDec'
;
	mov	eax,0			;;; i659
	mov	d[ebp-112],eax			;;; i670
;
; [111] expCtr = 0
;
#ifdef XxxFormat$.expCtr
#undef XxxFormat$.expCtr
#endif
#define XxxFormat$.expCtr ebp-116	; exposes local variable 'expCtr'
;
	mov	eax,0			;;; i659
	mov	d[ebp-116],eax			;;; i670
;
; [112] hasDec = 0
;
#ifdef XxxFormat$.hasDec
#undef XxxFormat$.hasDec
#endif
#define XxxFormat$.hasDec ebp-120	; exposes local variable 'hasDec'
;
	mov	eax,0			;;; i659
	mov	d[ebp-120],eax			;;; i670
;
; [113] commaFlag = 0
;
#ifdef XxxFormat$.commaFlag
#undef XxxFormat$.commaFlag
#endif
#define XxxFormat$.commaFlag ebp-124	; exposes local variable 'commaFlag'
;
	mov	eax,0			;;; i659
	mov	d[ebp-124],eax			;;; i670
;
; [114] padFlag = 0
;
#ifdef XxxFormat$.padFlag
#undef XxxFormat$.padFlag
#endif
#define XxxFormat$.padFlag ebp-128	; exposes local variable 'padFlag'
;
	mov	eax,0			;;; i659
	mov	d[ebp-128],eax			;;; i670
;
; [115] dollarSign$ = ""
;
#ifdef XxxFormat$.dollarSign$
#undef XxxFormat$.dollarSign$
#endif
#define XxxFormat$.dollarSign$ ebp-132	; exposes local variable 'dollarSign$'
;
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-132]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [116] leadSign$ = ""
;
#ifdef XxxFormat$.leadSign$
#undef XxxFormat$.leadSign$
#endif
#define XxxFormat$.leadSign$ ebp-136	; exposes local variable 'leadSign$'
;
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [117] trailSign$ = ""
;
#ifdef XxxFormat$.trailSign$
#undef XxxFormat$.trailSign$
#endif
#define XxxFormat$.trailSign$ ebp-140	; exposes local variable 'trailSign$'
;
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [118] errSign$ = ""
;
#ifdef XxxFormat$.errSign$
#undef XxxFormat$.errSign$
#endif
#define XxxFormat$.errSign$ ebp-144	; exposes local variable 'errSign$'
;
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-144]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [119] '
;
; [120] ' Format argument and add it to the result loop
;
; [121] '
;
; [122] DO
align 8
do.000A.xformat:
;
; [123] lastChar = fmtChar
	mov	eax,d[ebp-84]			;;; i665
	mov	d[ebp-88],eax			;;; i670
;
; [124] fmtChar = format${fmtStrPtr-1}
	mov	eax,d[ebp-28]			;;; i665
	sub	eax,1			;;; i791
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-84],eax			;;; i670
;
; [125] '
;
; [126] IFZ ((fmtChar = '#') AND ((lastChar = ',') OR (lastChar = '.') OR (lastChar = '#'))) THEN
	mov	eax,d[ebp-84]			;;; i665
	cmp	eax,35			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.11			;;; i467
	not	eax			;;; i468
A.11:
;+peep
	mov	ebx,d[ebp-88]			;;; i665
	cmp	ebx,44			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.12			;;; i467
	not	ebx			;;; i468
A.12:
;+peep
;
; .xstk3.0000 = ebp-152	; internal variable
	mov	d[ebp-152],eax			;;; i670
	mov	eax,d[ebp-88]			;;; i665
	cmp	eax,46			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.13			;;; i467
	not	eax			;;; i468
A.13:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-88]			;;; i665
	cmp	ebx,35			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.14			;;; i467
	not	ebx			;;; i468
A.14:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i194
	jnz	>> else.000B.xformat			;;; i195
;
; [127] levelNow  = fmtLevel[fmtChar]
	mov	eax,d[ebp-84]			;;; i665
	mov	edx,d[%%3%%fmtLevel.xformat]			;;; i663a
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-96],eax			;;; i670
;
; [128] END IF
else.000B.xformat:
end.if.000B.xformat:
;
; [129] '
;
; [130] IF (fmtStrPtr = lenFmtStr) THEN' check for end of fmt string
	mov	eax,d[ebp-28]			;;; i665
	mov	ebx,d[ebp-32]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> else.000C.xformat			;;; i219
;
; [131] nextChar = 'A''   set bogus next char
	mov	eax,65			;;; i659
	mov	d[ebp-92],eax			;;; i670
;
; [132] ELSE
	jmp	end.if.000C.xformat			;;; i107
else.000C.xformat:
;
; [133] nextChar  = format${fmtStrPtr}'   get real next char
	mov	eax,d[ebp-28]			;;; i665
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-92],eax			;;; i670
;
; [134] END IF
end.if.000C.xformat:
;
; [135] '
;
; [136] IF ((nextChar = '#') AND ((fmtChar = ',') OR (fmtChar = '.') OR (fmtChar = '#'))) THEN
	mov	eax,d[ebp-92]			;;; i665
	cmp	eax,35			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.15			;;; i467
	not	eax			;;; i468
A.15:
;+peep
	mov	ebx,d[ebp-84]			;;; i665
	cmp	ebx,44			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.16			;;; i467
	not	ebx			;;; i468
A.16:
;+peep
	mov	d[ebp-152],eax			;;; i670
	mov	eax,d[ebp-84]			;;; i665
	cmp	eax,46			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.17			;;; i467
	not	eax			;;; i468
A.17:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-84]			;;; i665
	cmp	ebx,35			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.18			;;; i467
	not	ebx			;;; i468
A.18:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.000D.xformat			;;; i221
;
; [137] levelNext = levelNow
	mov	eax,d[ebp-96]			;;; i665
	mov	d[ebp-100],eax			;;; i670
;
; [138] ELSE
	jmp	end.if.000D.xformat			;;; i107
else.000D.xformat:
;
; [139] levelNext = fmtLevel[nextChar]
	mov	eax,d[ebp-92]			;;; i665
	mov	edx,d[%%3%%fmtLevel.xformat]			;;; i663a
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-100],eax			;;; i670
;
; [140] END IF
end.if.000D.xformat:
;
; [141] '
;
; [142] ' Unformatted string "format"
;
; [143] '
;
; [144] IF (fmtChar = '&') THEN
	mov	eax,d[ebp-84]			;;; i665
	cmp	eax,38			;;; i684a
	jne	>> else.000E.xformat			;;; i219
;
; [145] IF (argType != $$STRING) THEN
	mov	eax,d[ebp+12]			;;; i665
	cmp	eax,19			;;; i684a
	je	>> else.000F.xformat			;;; i219
;
; [146] PRINT "FORMAT$() : error : (numeric data with '&')"
;
; .filenumber = ebp-156	; internal variable
	push	1			;;; i844
	sub	esp,64			;;; i845
	mov	eax,addr @_string.006E.xformat			;;; i663
	call	%_clone.a0			;;; i429
	add	esp,64
	call	%_PrintWithNewlineThenFree			;;; i859
	add	esp,4
;
; [147] GOTO eeeQuitFormat
	jmp	%g%eeeQuitFormat%3			;;; i163
;
; [148] END IF
else.000F.xformat:
end.if.000F.xformat:
;
; [149] resultString$ = resultString$ + arg$
	mov	eax,[ebp-36]			;;; i665
	mov	ebx,[ebp-24]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [150] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [151] EXIT DO
	jmp	end.do.000A.xformat			;;; i144
;
; [152] END IF
else.000E.xformat:
end.if.000E.xformat:
;
; [153] INC nPlaces
	inc	d[ebp-104]			;;; i84
;
; [154] '
;
; [155] SELECT CASE fmtChar
	mov	eax,d[ebp-84]			;;; i665
;
; .select3.0010 = ebp-160	; internal variable
	mov	d[ebp-160],eax			;;; i670
;
; [156] CASE '$': dollarSign$ = "$"
	mov	eax,36			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0001.xformat			;;; i71
	mov	eax,addr @_string.006F.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-132]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [157] CASE ',':	commaFlag = $$TRUE
	jmp	end.select.0010.xformat			;;; i69
case.0010.0001.xformat:
	mov	eax,44			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0002.xformat			;;; i71
	mov	eax,-1			;;; i659
	mov	d[ebp-124],eax			;;; i670
;
; [158] INC preDec
	inc	d[ebp-108]			;;; i84
;
; [159] CASE '*': padFlag = $$TRUE
	jmp	end.select.0010.xformat			;;; i69
case.0010.0002.xformat:
	mov	eax,42			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0003.xformat			;;; i71
	mov	eax,-1			;;; i659
	mov	d[ebp-128],eax			;;; i670
;
; [160] INC preDec
	inc	d[ebp-108]			;;; i84
;
; [161] CASE '.': hasDec = 1
	jmp	end.select.0010.xformat			;;; i69
case.0010.0003.xformat:
	mov	eax,46			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0004.xformat			;;; i71
	mov	eax,1			;;; i659
	mov	d[ebp-120],eax			;;; i670
;
; [162] CASE '#': IF hasDec THEN
	jmp	end.select.0010.xformat			;;; i69
case.0010.0004.xformat:
	mov	eax,35			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0005.xformat			;;; i71
	mov	eax,d[ebp-120]			;;; i665
	test	eax,eax			;;; i220
	jz	>> else.0011.xformat			;;; i221
;
; [163] INC postDec
	inc	d[ebp-112]			;;; i84
;
; [164] ELSE
	jmp	end.if.0011.xformat			;;; i107
else.0011.xformat:
;
; [165] INC preDec
	inc	d[ebp-108]			;;; i84
;
; [166] END IF
end.if.0011.xformat:
;
; [167] CASE '-': INC preDec' sign can only be leading here.
	jmp	end.select.0010.xformat			;;; i69
case.0010.0005.xformat:
	mov	eax,45			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0006.xformat			;;; i71
	inc	d[ebp-108]			;;; i84
;
; [168] CASE '+', '('
	jmp	end.select.0010.xformat			;;; i69
case.0010.0006.xformat:
	mov	eax,43			;;; i659
	mov	ebx,d[ebp-160]			;;; i665
	cmp	eax,ebx			;;; i684a
	je	>> caser.0010.0006.xformat			;;; i70
	mov	eax,40			;;; i659
	cmp	eax,ebx			;;; i684a
	jne	>> case.0010.0007.xformat			;;; i71
caser.0010.0006.xformat:
;
; [169] IFZ leadSign$ THEN
	mov	eax,[ebp-136]			;;; i665
	test	eax,eax			;;; i188
	jz	> A.19			;;; i189
	mov	eax,d[eax-8]			;;; i190
	test	eax,eax			;;; i191
	jnz	>> else.0012.xformat			;;; i192
A.19:
;
; [170] leadSign$ = CHR$ (fmtChar)
	sub	esp,64			;;; i487
	mov	eax,d[ebp-84]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [171] ELSE
	jmp	end.if.0012.xformat			;;; i107
else.0012.xformat:
;
; [172] PRINT "FORMAT$() : error : (leading"; leadSign$; "excludes"; CHR$ (fmtChar); ")"
	push	1			;;; i844
	sub	esp,64			;;; i845
	mov	eax,addr @_string.0070.xformat			;;; i663
	call	%_clone.a0			;;; i429
	mov	ebx,[ebp-136]			;;; i665
	call	%_clone.a1			;;; i429
	push eax
	push ebx
	push 6
	call main.concat	;;; i291a
	add esp,12
	mov	ebx,addr @_string.0071.xformat			;;; i663
	call	%_clone.a1			;;; i429
	push eax
	push ebx
	push 6
	call main.concat	;;; i291a
	add esp,12
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,d[ebp-84]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push ebx
	push eax
	push 6
	call main.concat	;;; i291
	add esp,12
	mov	ebx,addr @_string.0072.xformat			;;; i663
	call	%_clone.a1			;;; i429
	push eax
	push ebx
	push 6
	call main.concat	;;; i291a
	add esp,12
	add	esp,64
	call	%_PrintWithNewlineThenFree			;;; i859
	add	esp,4
;
; [173] GOTO eeeQuitFormat
	jmp	%g%eeeQuitFormat%3			;;; i163
;
; [174] END IF
end.if.0012.xformat:
;
; [175] END SELECT
case.0010.0007.xformat:
end.select.0010.xformat:
;
; [176] '
;
; [177] ' case < or | or >:		all we needed to do is count them
;
; [178] ' End of char fmt:		add to resultString$, and exit loop
;
; [179] '
;
; [180] IF (((fmtChar = '<') OR (fmtChar = '|') OR (fmtChar = '>')) AND (nextChar != fmtChar)) THEN
	mov	eax,d[ebp-84]			;;; i665
	cmp	eax,60			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.20			;;; i467
	not	eax			;;; i468
A.20:
;+peep
	mov	ebx,d[ebp-84]			;;; i665
	cmp	ebx,124			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.21			;;; i467
	not	ebx			;;; i468
A.21:
;+peep
	or	eax,ebx			;;; i763
	mov	ebx,d[ebp-84]			;;; i665
	cmp	ebx,62			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.22			;;; i467
	not	ebx			;;; i468
A.22:
;+peep
	or	eax,ebx			;;; i763
	mov	d[ebp-152],eax			;;; i670
	mov	eax,d[ebp-92]			;;; i665
	mov	ebx,d[ebp-84]			;;; i665
	cmp	eax,ebx			;;; i684a
;>peep
	mov	eax,0			;;; i466
	je	> A.23			;;; i467
	not	eax			;;; i468
A.23:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.0013.xformat			;;; i221
;
; [181] IF (argType != $$STRING) THEN
	mov	eax,d[ebp+12]			;;; i665
	cmp	eax,19			;;; i684a
	je	>> else.0014.xformat			;;; i219
;
; [182] PRINT "FORMAT$() : error : (can't print number with string format)"
	push	1			;;; i844
	sub	esp,64			;;; i845
	mov	eax,addr @_string.0076.xformat			;;; i663
	call	%_clone.a0			;;; i429
	add	esp,64
	call	%_PrintWithNewlineThenFree			;;; i859
	add	esp,4
;
; [183] GOTO eeeQuitFormat
	jmp	%g%eeeQuitFormat%3			;;; i163
;
; [184] END IF
else.0014.xformat:
end.if.0014.xformat:
;
; [185] SELECT CASE fmtChar
	mov	eax,d[ebp-84]			;;; i665
;
; .select3.0015 = ebp-164	; internal variable
	mov	d[ebp-164],eax			;;; i670
;
; [186] CASE '<': resultString$ = resultString$ + LJUST$(arg$, nPlaces)
	mov	eax,60			;;; i659
	mov	ebx,d[ebp-164]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0015.0001.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,[ebp-24]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-104]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_ljust.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,[ebp-36]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	2			;;; i781e
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [187] CASE '|': resultString$ = resultString$ + CJUST$(arg$, nPlaces)
	jmp	end.select.0015.xformat			;;; i69
case.0015.0001.xformat:
	mov	eax,124			;;; i659
	mov	ebx,d[ebp-164]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0015.0002.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,[ebp-24]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-104]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_cjust.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,[ebp-36]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	2			;;; i781e
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [188] CASE '>': resultString$ = resultString$ + RJUST$(arg$, nPlaces)
	jmp	end.select.0015.xformat			;;; i69
case.0015.0002.xformat:
	mov	eax,62			;;; i659
	mov	ebx,d[ebp-164]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0015.0003.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,[ebp-24]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-104]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_rjust.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,[ebp-36]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	2			;;; i781e
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [189] END SELECT
case.0015.0003.xformat:
end.select.0015.xformat:
;
; [190] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [191] EXIT DO
	jmp	end.do.000A.xformat			;;; i144
;
; [192] END IF
else.0013.xformat:
end.if.0013.xformat:
;
; [193] '
;
; [194] ' SPECIAL TRAILING NUMERIC FMT INFO
;
; [195] '
;
; [196] ' get exponent: !! new nextChar$ if legit exponent !!
;
; [197] '
;
; [198] IF (nextChar = '^') THEN
	mov	eax,d[ebp-92]			;;; i665
	cmp	eax,94			;;; i684a
	jne	>> else.0016.xformat			;;; i219
;
; [199] DO' count ^s
align 8
do.0017.xformat:
;
; [200] INC expCtr
	inc	d[ebp-116]			;;; i84
;
; [201] IF (format${fmtStrPtr + expCtr} != '^') THEN EXIT DO
	mov	eax,d[ebp-28]			;;; i665
	mov	ebx,d[ebp-116]			;;; i665
	add	eax,ebx			;;; i775
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	cmp	eax,94			;;; i684a
	je	>> else.0018.xformat			;;; i219
	jmp	end.do.0017.xformat			;;; i144
else.0018.xformat:
end.if.0018.xformat:
;
; [202] LOOP UNTIL (expCtr = 5)
do.loop.0017.xformat:
	mov	eax,d[ebp-116]			;;; i665
	cmp	eax,5			;;; i684a
	jne	< do.0017.xformat			;;; i219
end.do.0017.xformat:
;
; [203] '
;
; [204] IF (expCtr >= 4) THEN' legitimate exponent
	mov	eax,d[ebp-116]			;;; i665
	cmp	eax,4			;;; i684a
	jl	>> else.0019.xformat			;;; i219
;
; [205] nPlaces    = nPlaces    + expCtr
	mov	eax,d[ebp-104]			;;; i665
	mov	ebx,d[ebp-116]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-104],eax			;;; i670
;
; [206] fmtStrPtr  = fmtStrPtr  + expCtr
	mov	eax,d[ebp-28]			;;; i665
	mov	ebx,d[ebp-116]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-28],eax			;;; i670
;
; [207] nextChar   = format${fmtStrPtr}' to look for trailing +, -, )
	mov	eax,d[ebp-28]			;;; i665
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-92],eax			;;; i670
;
; [208] ELSE
	jmp	end.if.0019.xformat			;;; i107
else.0019.xformat:
;
; [209] expCtr = 0' reset if not valid exponent
	mov	eax,0			;;; i659
	mov	d[ebp-116],eax			;;; i670
;
; [210] END IF
end.if.0019.xformat:
;
; [211] END IF
else.0016.xformat:
end.if.0016.xformat:
;
; [212] '
;
; [213] ' look for trailing + or - in nextChar here. add flags
;
; [214] '
;
; [215] IF (((nextChar = '-') OR (nextChar = '+')) AND (leadSign$ = "")) THEN
	mov	eax,d[ebp-92]			;;; i665
	cmp	eax,45			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.24			;;; i467
	not	eax			;;; i468
A.24:
;+peep
	mov	ebx,d[ebp-92]			;;; i665
	cmp	ebx,43			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.25			;;; i467
	not	ebx			;;; i468
A.25:
;+peep
	or	eax,ebx			;;; i763
	mov	d[ebp-152],eax			;;; i670
	mov	eax,[ebp-136]			;;; i665
	xor	ebx,ebx			;;; i658
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.26			;;; i467
	not	eax			;;; i468
A.26:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.001A.xformat			;;; i221
;
; [216] trailSign$ = CHR$ (nextChar)
	sub	esp,64			;;; i487
	mov	eax,d[ebp-92]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [217] '
;
; [218] ' incr ptrs: trailing sign picked up (but don't leave loop yet).
;
; [219] '
;
; [220] levelNext = 0
	mov	eax,0			;;; i659
	mov	d[ebp-100],eax			;;; i670
;
; [221] INC nPlaces
	inc	d[ebp-104]			;;; i84
;
; [222] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [223] END IF
else.001A.xformat:
end.if.001A.xformat:
;
; [224] '
;
; [225] ' get closing parenthesis; legit only if opening parenthesis has been set.
;
; [226] '
;
; [227] IF ((nextChar = ')') AND (leadSign$ = "(")) THEN
	mov	eax,d[ebp-92]			;;; i665
	cmp	eax,41			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.27			;;; i467
	not	eax			;;; i468
A.27:
;+peep
	mov	d[ebp-152],eax			;;; i670
	mov	eax,[ebp-136]			;;; i665
	mov	ebx,addr @_string.007B.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.28			;;; i467
	not	eax			;;; i468
A.28:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.001B.xformat			;;; i221
;
; [228] trailSign$ = CHR$ (nextChar)
	sub	esp,64			;;; i487
	mov	eax,d[ebp-92]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [229] INC nPlaces
	inc	d[ebp-104]			;;; i84
;
; [230] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [231] END IF
else.001B.xformat:
end.if.001B.xformat:
;
; [232] '
;
; [233] ' a second '.' means the beginning of a new fmt.
;
; [234] '
;
; [235] IF (hasDec AND (nextChar = '.')) THEN levelNext = 0
	mov	eax,d[ebp-92]			;;; i665
	cmp	eax,46			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.29			;;; i467
	not	eax			;;; i468
A.29:
;+peep
	mov	ebx,d[ebp-120]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.001C.xformat			;;; i221
	mov	eax,0			;;; i659
	mov	d[ebp-100],eax			;;; i670
else.001C.xformat:
end.if.001C.xformat:
;
; [236] '
;
; [237] ' End of num fmt: validate fmt, add to resultString$ and exit loop.
;
; [238] '
;
; [239] IF (levelNext < levelNow) THEN
	mov	eax,d[ebp-100]			;;; i665
	mov	ebx,d[ebp-96]			;;; i665
	cmp	eax,ebx			;;; i684a
	jge	>> else.001D.xformat			;;; i219
;
; [240] IFZ (preDec + postDec) THEN
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-112]			;;; i665
	add	eax,ebx			;;; i775
	test	eax,eax			;;; i194
	jnz	>> else.001E.xformat			;;; i195
;
; [241] PRINT "FORMAT$() : error : (no printable digits)"
	push	1			;;; i844
	sub	esp,64			;;; i845
	mov	eax,addr @_string.007C.xformat			;;; i663
	call	%_clone.a0			;;; i429
	add	esp,64
	call	%_PrintWithNewlineThenFree			;;; i859
	add	esp,4
;
; [242] GOTO eeeQuitFormat
	jmp	%g%eeeQuitFormat%3			;;; i163
;
; [243] END IF
else.001E.xformat:
end.if.001E.xformat:
;
; [244] '
;
; [245] ' missing close parenthesis: treat open paren as fixed.
;
; [246] '
;
; [247] IF ((leadSign$ = "(") AND (trailSign$ != ")")) THEN
	mov	eax,[ebp-136]			;;; i665
	mov	ebx,addr @_string.007B.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.30			;;; i467
	not	eax			;;; i468
A.30:
;+peep
	mov	d[ebp-152],eax			;;; i670
	mov	eax,[ebp-140]			;;; i665
	mov	ebx,addr @_string.0072.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	je	> A.31			;;; i467
	not	eax			;;; i468
A.31:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.001F.xformat			;;; i221
;
; [248] resultString$ = resultString$ + "("
	mov	eax,[ebp-36]			;;; i665
	mov	ebx,addr @_string.007B.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [249] leadSign$ = ""
	xor	eax,eax			;;; i3
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [250] DEC nPlaces
	dec	d[ebp-104]			;;; i84
;
; [251] END IF
else.001F.xformat:
end.if.001F.xformat:
;
; [252] '
;
; [253] ' Get argument
;
; [254] '
;
; [255] IF (argType = $$STRING) THEN
	mov	eax,d[ebp+12]			;;; i665
	cmp	eax,19			;;; i684a
	jne	>> else.0020.xformat			;;; i219
;
; [256] PRINT "FORMAT$() : error : (string argument)"
	push	1			;;; i844
	sub	esp,64			;;; i845
	mov	eax,addr @_string.007D.xformat			;;; i663
	call	%_clone.a0			;;; i429
	add	esp,64
	call	%_PrintWithNewlineThenFree			;;; i859
	add	esp,4
;
; [257] GOTO eeeQuitFormat
	jmp	%g%eeeQuitFormat%3			;;; i163
;
; [258] END IF
else.0020.xformat:
end.if.0020.xformat:
;
; [259] '
;
; [260] argH  = GHIGH(arg$$)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	mov	eax,edx			;;; i508
	add	esp,64			;;; i600
	mov	d[ebp-40],eax			;;; i670
;
; [261] argL  = GLOW (arg$$)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	add	esp,64			;;; i600
	mov	d[ebp-44],eax			;;; i670
;
; [262] arg&& = GLOW (arg$$)' type casts XLONG as ULONG
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	add	esp,64			;;; i600
	mov	d[ebp-48],eax			;;; i670
;
; [263] arg		= GLOW (arg$$)
;
#ifdef XxxFormat$.arg
#undef XxxFormat$.arg
#endif
#define XxxFormat$.arg ebp-168	; exposes local variable 'arg'
;
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	add	esp,64			;;; i600
	mov	d[ebp-168],eax			;;; i670
;
; [264] '
;
; [265] SELECT CASE argType
	mov	eax,d[ebp+12]			;;; i665
;
; .select3.0021 = ebp-172	; internal variable
	mov	d[ebp-172],eax			;;; i670
;
; [266] CASE $$DOUBLE	: argStr$ = STR$ (DMAKE(argH, argL))
	mov	eax,14			;;; i659
	mov	ebx,d[ebp-172]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0021.0001.xformat			;;; i71
	sub	esp,64			;;; i487
	sub	esp,64			;;; i487
	mov	eax,d[ebp-40]			;;; i665
	mov	ebx,d[ebp-44]			;;; i665
	mov	d[ebp-8],ebx			;;; i505
	mov	d[ebp-4],eax			;;; i506
	fld	q[ebp-8]			;;; i507
	add	esp,64			;;; i600
	fstp	q[esp]
	call	%_str.d.double			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [267] CASE $$SINGLE	: argStr$ = STR$ (SMAKE(argL))
	jmp	end.select.0021.xformat			;;; i69
case.0021.0001.xformat:
	mov	eax,13			;;; i659
	mov	ebx,d[ebp-172]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0021.0002.xformat			;;; i71
	sub	esp,64			;;; i487
	sub	esp,64			;;; i487
	mov	eax,d[ebp-44]			;;; i665
	mov	d[ebp-8],eax
	fld	d[ebp-8]
	add	esp,64			;;; i600
	fstp	d[esp]
	call	%_str.d.single			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [268] CASE $$GIANT	: argStr$ = STR$ (arg$$)
	jmp	end.select.0021.xformat			;;; i69
case.0021.0002.xformat:
	mov	eax,12			;;; i659
	mov	ebx,d[ebp-172]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0021.0003.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,d[ebp+16]			;;; i665
	mov	edx,d[ebp+20]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_str.d.giant			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [269] CASE $$ULONG	: argStr$ = STR$ (arg&&)
	jmp	end.select.0021.xformat			;;; i69
case.0021.0003.xformat:
	mov	eax,7			;;; i659
	mov	ebx,d[ebp-172]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0021.0004.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,d[ebp-48]			;;; i665
	mov	d[esp],eax			;;; i887
	call	%_str.d.ulong			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [270] CASE ELSE			: argStr$ = STR$ (arg)
	jmp	end.select.0021.xformat			;;; i69
case.0021.0004.xformat:
	sub	esp,64			;;; i487
	mov	eax,d[ebp-168]			;;; i665
	mov	d[esp],eax			;;; i887
	call	%_str.d.xlong			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [271] END SELECT
end.select.0021.xformat:
;
; [272] '
;
; [273] ' decompose argument string: sign, exponent, length and DP location
;
; [274] '
;
; [275] ' get sign: the 1st column of argStr$ will always be '-' or ' '.
;
; [276] '
;
; [277] negArg = argStr${0}
	mov	edx,d[ebp-60]			;;; i665
	movzx	eax,b[edx]			;;; i464
	mov	d[ebp-56],eax			;;; i670
;
; [278] argStr$ = MID$(argStr$, 2)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],2
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [279] '
;
; [280] ' remove any exponent from argStr$. argExpVal is its numeric value.
;
; [281] '
;
; [282] argExpIx = INCHR(argStr$, "de")
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,addr @_string.0084.xformat			;;; i663
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],0			;;; i571
	call	%_inchr.vv			;;; i572
	add	esp,64			;;; i600
	mov	d[ebp-72],eax			;;; i670
;
; [283] argExpVal = 0
	mov	eax,0			;;; i659
	mov	d[ebp-76],eax			;;; i670
;
; [284] IF (argExpIx > 0) THEN
	mov	eax,d[ebp-72]			;;; i665
	cmp	eax,0			;;; i684a
	jle	>> else.0022.xformat			;;; i219
;
; [286] '				argExpVal = XLONG (MID$(argStr$, argExpIx + 1))
;
; [288] ' ok, trying to eliminate the use of above XLONG intrinsic in Xst library
;
; [289] expVal$ = MID$(argStr$, argExpIx + 1)
;
#ifdef XxxFormat$.expVal$
#undef XxxFormat$.expVal$
#endif
#define XxxFormat$.expVal$ ebp-176	; exposes local variable 'expVal$'
;
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-72]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	lea	ebx,[ebp-176]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [290] specType = XstStringToNumber (@expVal$, 0, @after, @rtype, @value$$)
;
#ifdef XxxFormat$.specType
#undef XxxFormat$.specType
#endif
#define XxxFormat$.specType ebp-180	; exposes local variable 'specType'
;
;
; [0] EXTERNAL FUNCTION  XstStringToNumber             (s$, startOff, afterOff, rtype, value$$)
;
#ifdef XxxFormat$.after
#undef XxxFormat$.after
#endif
#define XxxFormat$.after ebp-184	; exposes local variable 'after'
;
;
#ifdef XxxFormat$.rtype
#undef XxxFormat$.rtype
#endif
#define XxxFormat$.rtype ebp-188	; exposes local variable 'rtype'
;
;
#ifdef XxxFormat$.value$$
#undef XxxFormat$.value$$
#endif
#define XxxFormat$.value$$ ebp-196	; exposes local variable 'value$$'
;
	push	[ebp-192]
	push	[ebp-196]			;;; i674a
	push	[ebp-188]			;;; i674a
	push	[ebp-184]			;;; i674a
	push	0			;;; i656a
	push	[ebp-176]			;;; i674a
	call	_XstStringToNumber@24			;;; i619
	mov	ecx,d[esp-24]			;;; i877a
	mov	ebx,d[esp-16]			;;; i877b
	mov	edi,d[esp-12]			;;; i877c
	mov	[ebp-176],ecx			;;; i670
	mov	d[ebp-184],ebx			;;; i670
	mov	d[ebp-188],edi			;;; i670
	mov	esi,d[esp-8]			;;; i875
	mov	edi,d[esp-4]			;;; i876
	mov	d[ebp-196],esi			;;; i670
	mov	d[ebp-192],edi
	mov	d[ebp-180],eax			;;; i670
;
; [291] SELECT CASE rtype
	mov	eax,d[ebp-188]			;;; i665
;
; .select3.0023 = ebp-200	; internal variable
	mov	d[ebp-200],eax			;;; i670
;
; [292] CASE $$SLONG : argExpVal = GLOW(value$$)
	mov	eax,6			;;; i659
	mov	ebx,d[ebp-200]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0023.0001.xformat			;;; i71
	sub	esp,64			;;; i487
	mov	eax,d[ebp-196]			;;; i665
	mov	edx,d[ebp-192]
	add	esp,64			;;; i600
	mov	d[ebp-76],eax			;;; i670
;
; [293] CASE $$XLONG : argExpVal = value$$
	jmp	end.select.0023.xformat			;;; i69
case.0023.0001.xformat:
	mov	eax,8			;;; i659
	mov	ebx,d[ebp-200]			;;; i665
	cmp	eax,ebx			;;; i684a
	jne	>> case.0023.0002.xformat			;;; i71
	mov	eax,d[ebp-196]			;;; i665
	mov	edx,d[ebp-192]
	or	eax,eax			;;; i417
	jns	> A.32			;;; i418
	not	edx			;;; i419
A.32:
	test	edx,edx			;;; i420
	jz	> A.33			;;; i421a
	call	%_eeeOverflow			;;; i421b
A.33:
	mov	d[ebp-76],eax			;;; i670
;
; [294] END SELECT
case.0023.0002.xformat:
end.select.0023.xformat:
;
; [295] ' end of substitution
;
; [297] argStr$ = LEFT$ (argStr$, argExpIx - 1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-72]			;;; i665
	sub	eax,1			;;; i791
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [298] END IF
else.0022.xformat:
end.if.0022.xformat:
;
; [299] '
;
; [300] ' length of argument string after sign, exponent and DP are removed
;
; [301] '
;
; [302] lenArg = LEN (argStr$)
	mov	eax,d[ebp-60]			;;; i665
	test	eax,eax			;;; i593
	jz	> A.34			;;; i594
	mov	eax,d[eax-8]			;;; i595
A.34:
	mov	d[ebp-52],eax			;;; i670
;
; [303] '
;
; [304] ' get argument decimal point location. Remove it from argStr and
;
; [305] '		deincrement lenArg if needed.
;
; [306] '
;
; [307] argDPLoc = INSTR (argStr$, ".")
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,addr @_string.008C.xformat			;;; i663
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],0			;;; i571
	call	%_instr.vv			;;; i572
	add	esp,64			;;; i600
	mov	d[ebp-64],eax			;;; i670
;
; [308] IFZ argDPLoc THEN
	mov	eax,d[ebp-64]			;;; i665
	test	eax,eax			;;; i194
	jnz	>> else.0024.xformat			;;; i195
;
; [309] argDPLoc = lenArg + 1
	mov	eax,d[ebp-52]			;;; i665
	add	eax,1			;;; i775
	mov	d[ebp-64],eax			;;; i670
;
; [310] ELSE
	jmp	end.if.0024.xformat			;;; i107
else.0024.xformat:
;
; [311] argStr$ = LEFT$(argStr$, argDPLoc -1) + MID$(argStr$, argDPLoc +1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-64]			;;; i665
	sub	eax,1			;;; i791
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-64]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [312] DEC lenArg
	dec	d[ebp-52]			;;; i84
;
; [313] END IF
end.if.0024.xformat:
;
; [314] '
;
; [315] k = 0
;
#ifdef XxxFormat$.k
#undef XxxFormat$.k
#endif
#define XxxFormat$.k ebp-204	; exposes local variable 'k'
;
	mov	eax,0			;;; i659
	mov	d[ebp-204],eax			;;; i670
;
; [316] DO WHILE argStr${k} = '0'
align 8
do.0025.xformat:
	mov	eax,d[ebp-204]			;;; i665
	mov	edx,d[ebp-60]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	cmp	eax,48			;;; i684a
	jne	>> end.do.0025.xformat			;;; i219
;
; [317] DEC argExpVal
	dec	d[ebp-76]			;;; i84
;
; [318] INC k
	inc	d[ebp-204]			;;; i84
;
; [319] LOOP
do.loop.0025.xformat:
	jmp	do.0025.xformat			;;; i222
end.do.0025.xformat:
;
; [320] argStr$ = MID$(argStr$, k+1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-204]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [321] lenArg = lenArg - k
	mov	eax,d[ebp-52]			;;; i665
	mov	ebx,d[ebp-204]			;;; i665
	sub	eax,ebx			;;; i791
	mov	d[ebp-52],eax			;;; i670
;
; [322] '
;
; [323] ' argMSDOrder, if pos, is the exponent of the most significant digit.
;
; [324] '		if neg, it is one less than the exponent.
;
; [325] '
;
; [326] argMSDOrder = argDPLoc - 1 + argExpVal
	mov	eax,d[ebp-64]			;;; i665
	sub	eax,1			;;; i791
	mov	ebx,d[ebp-76]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-80],eax			;;; i670
;
; [327] '
;
; [328] ' numShift is the power of 10 difference between the MSD of the format
;
; [329] '		and the MSD of the argument
;
; [330] '
;
; [331] numShift = preDec - argMSDOrder
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-80]			;;; i665
	sub	eax,ebx			;;; i791
	mov	d[ebp-68],eax			;;; i670
;
; [332] '
;
; [333] ' put numeric argument string and format together
;
; [334] '
;
; [335] IFZ expCtr THEN' formats without an exponent
	mov	eax,d[ebp-116]			;;; i665
	test	eax,eax			;;; i194
	jnz	>> else.0026.xformat			;;; i195
;
; [336] IF (numShift > 0) THEN
	mov	eax,d[ebp-68]			;;; i665
	cmp	eax,0			;;; i684a
	jle	>> else.0027.xformat			;;; i219
;
; [337] argStr$ = CHR$ ('0', numShift) + argStr$
	sub	esp,64			;;; i487
	mov	eax,48			;;; i659
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-68]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [338] lenArg = lenArg + numShift
	mov	eax,d[ebp-52]			;;; i665
	mov	ebx,d[ebp-68]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-52],eax			;;; i670
;
; [339] END IF
else.0027.xformat:
end.if.0027.xformat:
;
; [340] GOSUB Rounder
	call	%s%Rounder%3			;;; i163
;
; [341] '
;
; [342] ' restore DP and add commas
;
; [343] '
;
; [344] IF hasDec THEN
	mov	eax,d[ebp-120]			;;; i665
	test	eax,eax			;;; i220
	jz	>> else.0028.xformat			;;; i221
;
; [345] IF (preDec > argMSDOrder) THEN
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-80]			;;; i665
	cmp	eax,ebx			;;; i684a
	jle	>> else.0029.xformat			;;; i219
;
; [346] argStr$ = LEFT$(argStr$, preDec) + "." + MID$(argStr$, preDec +1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,addr @_string.008C.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [347] comIx = preDec
;
#ifdef XxxFormat$.comIx
#undef XxxFormat$.comIx
#endif
#define XxxFormat$.comIx ebp-208	; exposes local variable 'comIx'
;
	mov	eax,d[ebp-108]			;;; i665
	mov	d[ebp-208],eax			;;; i670
;
; [348] ELSE
	jmp	end.if.0029.xformat			;;; i107
else.0029.xformat:
;
; [349] argStr$ = LEFT$(argStr$, argMSDOrder) + "." + MID$(argStr$, argMSDOrder +1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-80]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,addr @_string.008C.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-80]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [350] comIx = argMSDOrder
	mov	eax,d[ebp-80]			;;; i665
	mov	d[ebp-208],eax			;;; i670
;
; [351] END IF
end.if.0029.xformat:
;
; [352] ELSE' no decimal place
	jmp	end.if.0028.xformat			;;; i107
else.0028.xformat:
;
; [353] IF (preDec > argMSDOrder) THEN
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-80]			;;; i665
	cmp	eax,ebx			;;; i684a
	jle	>> else.002A.xformat			;;; i219
;
; [354] comIx = preDec
	mov	eax,d[ebp-108]			;;; i665
	mov	d[ebp-208],eax			;;; i670
;
; [355] ELSE
	jmp	end.if.002A.xformat			;;; i107
else.002A.xformat:
;
; [356] comIx = argMSDOrder
	mov	eax,d[ebp-80]			;;; i665
	mov	d[ebp-208],eax			;;; i670
;
; [357] END IF
end.if.002A.xformat:
;
; [358] END IF
end.if.0028.xformat:
;
; [359] '
;
; [360] IF (commaFlag AND (argMSDOrder > 3)) THEN GOSUB AddCommas
	mov	eax,d[ebp-80]			;;; i665
	cmp	eax,3			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jle	> A.35			;;; i467
	not	eax			;;; i468
A.35:
;+peep
	mov	ebx,d[ebp-124]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.002B.xformat			;;; i221
	call	%s%AddCommas%3			;;; i163
else.002B.xformat:
end.if.002B.xformat:
;
; [361] '
;
; [362] ' strip off any leading 0s before DP
;
; [363] '
;
; [364] IF ((argMSDOrder < preDec) AND (preDec > 0)) THEN
	mov	eax,d[ebp-80]			;;; i665
	mov	ebx,d[ebp-108]			;;; i665
	cmp	eax,ebx			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jge	> A.36			;;; i467
	not	eax			;;; i468
A.36:
;+peep
	mov	ebx,d[ebp-108]			;;; i665
	cmp	ebx,0			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jle	> A.37			;;; i467
	not	ebx			;;; i468
A.37:
;+peep
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.002C.xformat			;;; i221
;
; [365] IF (argMSDOrder <= 1) THEN
	mov	eax,d[ebp-80]			;;; i665
	cmp	eax,1			;;; i684a
	jg	>> else.002D.xformat			;;; i219
;
; [366] argStr$ = MID$(argStr$, preDec)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [367] ELSE
	jmp	end.if.002D.xformat			;;; i107
else.002D.xformat:
;
; [368] argStr$ = MID$(argStr$, preDec - argMSDOrder + 1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-80]			;;; i665
	sub	eax,ebx			;;; i791
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [369] END IF
end.if.002D.xformat:
;
; [370] END IF
else.002C.xformat:
end.if.002C.xformat:
;
; [371] '
;
; [372] ' if not enough digits in format then set mess up formatting flag
;
; [373] '
;
; [374] IF (LEN(argStr$) > (preDec + postDec + hasDec)) THEN errSign$ = "%"
	mov	eax,d[ebp-60]			;;; i665
	test	eax,eax			;;; i593
	jz	> A.38			;;; i594
	mov	eax,d[eax-8]			;;; i595
A.38:
	mov	d[ebp-152],eax			;;; i670
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-112]			;;; i665
	add	eax,ebx			;;; i775
	mov	ebx,d[ebp-120]			;;; i665
	add	eax,ebx			;;; i775
	mov	ebx,d[ebp-152]			;;; i665
	cmp	eax,ebx			;;; i684a
	jge	>> else.002E.xformat			;;; i219
	mov	eax,addr @_string.0091.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-144]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
else.002E.xformat:
end.if.002E.xformat:
;
; [375] ELSE' formats with exponent
	jmp	end.if.0026.xformat			;;; i107
else.0026.xformat:
;
; [376] GOSUB Rounder' round off significant digits
	call	%s%Rounder%3			;;; i163
;
; [377] '
;
; [378] ' restore DP
;
; [379] '
;
; [380] IF hasDec THEN argStr$ = LEFT$(argStr$, preDec) + "." + MID$(argStr$, preDec +1)
	mov	eax,d[ebp-120]			;;; i665
	test	eax,eax			;;; i220
	jz	>> else.002F.xformat			;;; i221
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,addr @_string.008C.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-108]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
else.002F.xformat:
end.if.002F.xformat:
;
; [381] '
;
; [382] ' get exponent in usable form
;
; [383] '
;
; [384] expString$ = STR$ (numShift * -1)
;
#ifdef XxxFormat$.expString$
#undef XxxFormat$.expString$
#endif
#define XxxFormat$.expString$ ebp-212	; exposes local variable 'expString$'
;
	sub	esp,64			;;; i487
	mov	eax,1			;;; i659
	neg	eax			;;; i916
	mov	ebx,d[ebp-68]			;;; i665
	imul	eax,ebx			;;; i805
	mov	d[esp],eax			;;; i887
	call	%_str.d.xlong			;;; i576
	add	esp,64			;;; i600
	lea	ebx,[ebp-212]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [385] IF (expString${0} = ' ') THEN expString${0} = '+'
	mov	edx,d[ebp-212]			;;; i665
	movzx	eax,b[edx]			;;; i464
	cmp	eax,32			;;; i684a
	jne	>> else.0030.xformat			;;; i219
	mov	eax,43			;;; i659
	mov	ecx,d[ebp-212]			;;; i665
	lea	ebx,[ecx]			;;; i464
	mov	b[ebx],al			;;; i29
else.0030.xformat:
end.if.0030.xformat:
;
; [386] expLen = LEN (expString$)
;
#ifdef XxxFormat$.expLen
#undef XxxFormat$.expLen
#endif
#define XxxFormat$.expLen ebp-216	; exposes local variable 'expLen'
;
	mov	eax,d[ebp-212]			;;; i665
	test	eax,eax			;;; i593
	jz	> A.39			;;; i594
	mov	eax,d[eax-8]			;;; i595
A.39:
	mov	d[ebp-216],eax			;;; i670
;
; [387] DEC expCtr
	dec	d[ebp-116]			;;; i84
;
; [388] '
;
; [389] SELECT CASE TRUE
;
; [390] CASE (expLen < expCtr)
	mov	eax,d[ebp-216]			;;; i665
	mov	ebx,d[ebp-116]			;;; i665
	cmp	eax,ebx			;;; i684a
	jge	>> case.0031.0001.xformat			;;; i219
;
; [391] expString$ = LEFT$ (expString$, 1) + CHR$ ('0', expCtr - expLen) + MID$ (expString$, 2)
	sub	esp,64			;;; i487
	mov	eax,[ebp-212]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,48			;;; i659
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-116]			;;; i665
	mov	ebx,d[ebp-216]			;;; i665
	sub	eax,ebx			;;; i791
	mov	d[esp+4],eax			;;; i887
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-212]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],2
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-212]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [392] CASE (expLen > expCtr)
	jmp	end.select.0031.xformat			;;; i69
case.0031.0001.xformat:
	mov	eax,d[ebp-216]			;;; i665
	mov	ebx,d[ebp-116]			;;; i665
	cmp	eax,ebx			;;; i684a
	jle	>> case.0031.0002.xformat			;;; i219
;
; [393] errSign$ = "%"
	mov	eax,addr @_string.0091.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-144]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [394] END SELECT
case.0031.0002.xformat:
end.select.0031.xformat:
;
; [395] '				argStr$ = argStr$ + "E" + expString$
;
; [396] argStr$ = argStr$ + "e" + expString$
	mov	eax,[ebp-60]			;;; i665
	mov	ebx,addr @_string.0095.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	ebx,[ebp-212]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [397] END IF
end.if.0026.xformat:
;
; [398] '
;
; [399] ' take care of leading and trailing sign stuff
;
; [400] '
;
; [401] IF (negArg = '-') THEN
	mov	eax,d[ebp-56]			;;; i665
	cmp	eax,45			;;; i684a
	jne	>> else.0032.xformat			;;; i219
;
; [402] SELECT CASE TRUE
;
; [403] CASE (leadSign$ = "") AND (trailSign$ = ""):	leadSign$  = "-"
	mov	eax,[ebp-136]			;;; i665
	xor	ebx,ebx			;;; i658
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.40			;;; i467
	not	eax			;;; i468
A.40:
;+peep
	mov	d[ebp-152],eax			;;; i670
	mov	eax,[ebp-140]			;;; i665
	xor	ebx,ebx			;;; i658
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.41			;;; i467
	not	eax			;;; i468
A.41:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> case.0033.0001.xformat			;;; i221
	mov	eax,addr @_string.0096.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [404] CASE (leadSign$ = "+"):												leadSign$  = "-"
	jmp	end.select.0033.xformat			;;; i69
case.0033.0001.xformat:
	mov	eax,[ebp-136]			;;; i665
	mov	ebx,addr @_string.0097.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
	jne	>> case.0033.0002.xformat			;;; i219
	mov	eax,addr @_string.0096.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [405] CASE (trailSign$ = "+"):											trailSign$ = "-"
	jmp	end.select.0033.xformat			;;; i69
case.0033.0002.xformat:
	mov	eax,[ebp-140]			;;; i665
	mov	ebx,addr @_string.0097.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
	jne	>> case.0033.0003.xformat			;;; i219
	mov	eax,addr @_string.0096.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [406] END SELECT
case.0033.0003.xformat:
end.select.0033.xformat:
;
; [407] ELSE
	jmp	end.if.0032.xformat			;;; i107
else.0032.xformat:
;
; [408] SELECT CASE TRUE
;
; [409] CASE (leadSign$ = "(") AND (trailSign$ = ")")
	mov	eax,[ebp-136]			;;; i665
	mov	ebx,addr @_string.007B.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.42			;;; i467
	not	eax			;;; i468
A.42:
;+peep
	mov	d[ebp-152],eax			;;; i670
	mov	eax,[ebp-140]			;;; i665
	mov	ebx,addr @_string.0072.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
;>peep
	mov	eax,0			;;; i466
	jne	> A.43			;;; i467
	not	eax			;;; i468
A.43:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> case.0034.0001.xformat			;;; i221
;
; [410] leadSign$ = " "
	mov	eax,addr @_string.0098.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-136]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [411] trailSign$ = " "
	mov	eax,addr @_string.0098.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [412] CASE trailSign$ = "-"
	jmp	end.select.0034.xformat			;;; i69
case.0034.0001.xformat:
	mov	eax,[ebp-140]			;;; i665
	mov	ebx,addr @_string.0096.xformat			;;; i663
	call	%_string.compare.vv			;;; i690
	jne	>> case.0034.0002.xformat			;;; i219
;
; [413] trailSign$ = " "
	mov	eax,addr @_string.0098.xformat			;;; i663
	call	%_clone.a0			;;; i3a
	lea	ebx,[ebp-140]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [414] END SELECT
case.0034.0002.xformat:
end.select.0034.xformat:
;
; [415] END IF
end.if.0032.xformat:
;
; [416] '
;
; [417] ' add signs and padding as necessary
;
; [418] '
;
; [419] argStr$ = leadSign$ + dollarSign$ + argStr$ + trailSign$
	mov	eax,[ebp-136]			;;; i665
	mov	ebx,[ebp-132]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	ebx,[ebp-140]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [420] padLen  = nPlaces - LEN(argStr$)
;
#ifdef XxxFormat$.padLen
#undef XxxFormat$.padLen
#endif
#define XxxFormat$.padLen ebp-220	; exposes local variable 'padLen'
;
	mov	eax,d[ebp-60]			;;; i665
	test	eax,eax			;;; i593
	jz	> A.44			;;; i594
	mov	eax,d[eax-8]			;;; i595
A.44:
	mov	ebx,d[ebp-104]			;;; i665
	xchg	eax,ebx			;;; i790
	sub	eax,ebx			;;; i791
	mov	d[ebp-220],eax			;;; i670
;
; [421] IF (padLen > 0) THEN
	mov	eax,d[ebp-220]			;;; i665
	cmp	eax,0			;;; i684a
	jle	>> else.0035.xformat			;;; i219
;
; [422] IF padFlag THEN
	mov	eax,d[ebp-128]			;;; i665
	test	eax,eax			;;; i220
	jz	>> else.0036.xformat			;;; i221
;
; [423] argStr$ = CHR$ ('*', padLen) + argStr$
	sub	esp,64			;;; i487
	mov	eax,42			;;; i659
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-220]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [424] ELSE
	jmp	end.if.0036.xformat			;;; i107
else.0036.xformat:
;
; [425] argStr$ = CHR$ (' ', padLen) + argStr$
	sub	esp,64			;;; i487
	mov	eax,32			;;; i659
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-220]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [426] END IF
end.if.0036.xformat:
;
; [427] END IF
else.0035.xformat:
end.if.0035.xformat:
;
; [428] resultString$ = resultString$ + errSign$ + argStr$
	mov	eax,[ebp-36]			;;; i665
	mov	ebx,[ebp-144]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [429] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [430] EXIT DO
	jmp	end.do.000A.xformat			;;; i144
;
; [431] END IF
else.001D.xformat:
end.if.001D.xformat:
;
; [432] INC fmtStrPtr' incremented when looping through fmt chars
	inc	d[ebp-28]			;;; i84
;
; [433] LOOP
do.loop.000A.xformat:
	jmp	do.000A.xformat			;;; i222
end.do.000A.xformat:
;
; [434] GOSUB StringString' get trailing constant string, if any
	call	%s%StringString%3			;;; i163
;
; [435] '
;
; [436] ' reset fmt string ptrs to cycle through again as necessary
;
; [437] '
;
; [438] IF ((fmtStrPtr = 0) AND (argIx < nArg-1)) THEN
	mov	eax,d[ebp-28]			;;; i665
	cmp	eax,0			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.45			;;; i467
	not	eax			;;; i468
A.45:
;+peep
;
#ifdef XxxFormat$.argIx
#undef XxxFormat$.argIx
#endif
#define XxxFormat$.argIx ebp-224	; exposes local variable 'argIx'
;
;
#ifdef XxxFormat$.nArg
#undef XxxFormat$.nArg
#endif
#define XxxFormat$.nArg ebp-228	; exposes local variable 'nArg'
;
	mov	ebx,d[ebp-228]			;;; i665
	sub	ebx,1			;;; i791
	mov	d[ebp-152],eax			;;; i670
	mov	eax,d[ebp-224]			;;; i665
	cmp	eax,ebx			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jge	> A.46			;;; i467
	not	eax			;;; i468
A.46:
;+peep
	mov	ebx,d[ebp-152]			;;; i665
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.0037.xformat			;;; i221
;
; [439] fmtStrPtr = 1
	mov	eax,1			;;; i659
	mov	d[ebp-28],eax			;;; i670
;
; [440] GOSUB StringString
	call	%s%StringString%3			;;; i163
;
; [441] END IF
else.0037.xformat:
end.if.0037.xformat:
;
; [442] '	PRINT "b<" + resultString$ + "> " + STRING$(LEN(resultString$))
;
; [443] RETURN (resultString$)
	mov	eax,[ebp-36]			;;; i665
	call	%_clone.a0			;;; i870
	jmp	end.func3.xformat			;;; i258
;
; [444] '
;
; [445] '
;
; [446] ' *****  Initialize  *****
;
; [447] '
;
; [448] SUB Initialize
	jmp	out.sub3.0.xformat			;;; i262
align 16
%s%Initialize%3:
;
; .sub3.0000 = ebp-232	; internal variable
;
; [449] DIM fmtLevel[255]' initialize format character priority level arrays
	sub	esp,64			;;; i430
	mov	eax,255			;;; i659
	mov	d[esp+16],eax			;;; i432
	mov	esi,d[%%3%%fmtLevel.xformat]			;;; i663a
	mov	d[esp],esi			;;; i433
	mov	d[esp+4],1			;;; i434
	mov	d[esp+8],-1073545215			;;; i435
	mov	d[esp+12],0			;;; i436
	call	%_DimArray			;;; i437
	add	esp,64			;;; i438
	mov	d[%%3%%fmtLevel.xformat],eax			;;; i668
;
; [450] DIM fmtBegin[255]
	sub	esp,64			;;; i430
	mov	eax,255			;;; i659
	mov	d[esp+16],eax			;;; i432
	mov	esi,d[%%3%%fmtBegin.xformat]			;;; i663a
	mov	d[esp],esi			;;; i433
	mov	d[esp+4],1			;;; i434
	mov	d[esp+8],-1073545215			;;; i435
	mov	d[esp+12],0			;;; i436
	call	%_DimArray			;;; i437
	add	esp,64			;;; i438
	mov	d[%%3%%fmtBegin.xformat],eax			;;; i668
;
; [451] '
;
; [452] ' All format characters are listed in fmtLevel.
;
; [453] ' The fmtBegin array is used to determine the legitimacy of formats
;
; [454] ' that cannot stand alone. These formats require a sequence of characters
;
; [455] ' to establish their legitimacy.
;
; [456] ' The lower the format level value, the higher the priority, so the
;
; [457] ' characters not given a priority level here default to fmtlevel[] = 0,
;
; [458] ' and therefore the highest priority. The lowest priority = 255.
;
; [459] '
;
; [460] fmtLevel['&'] =  20
	mov	eax,20			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+38]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [461] fmtLevel['<'] =  30
	mov	eax,30			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+60]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [462] fmtLevel['|'] =  30
	mov	eax,30			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+124]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [463] fmtLevel['>'] =  30
	mov	eax,30			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+62]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [464] fmtLevel['+'] =  40:	fmtBegin['+'] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+43]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+43]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [465] fmtLevel['-'] =  40:	fmtBegin['-'] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+45]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+45]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [466] fmtLevel['('] =  40:	fmtBegin['('] =  40
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+40]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,40			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+40]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [467] fmtLevel['*'] =  50:	fmtBegin['*'] =  50
	mov	eax,50			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+42]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,50			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+42]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [468] fmtLevel['$'] =  60:	fmtBegin['$'] =  60
	mov	eax,60			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+36]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,60			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+36]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [469] fmtLevel['#'] =  70
	mov	eax,70			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+35]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [470] fmtLevel[','] =  80:	fmtBegin[','] =  80
	mov	eax,80			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+44]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,80			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+44]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [471] fmtLevel['.'] =  90:	fmtBegin['.'] =  90
	mov	eax,90			;;; i659
	mov	ecx,d[%%3%%fmtLevel.xformat]			;;; i663a
	lea	ebx,[ecx+46]			;;; i464
	mov	b[ebx],al			;;; i30
	mov	eax,90			;;; i659
	mov	ecx,d[%%3%%fmtBegin.xformat]			;;; i663a
	lea	ebx,[ecx+46]			;;; i464
	mov	b[ebx],al			;;; i30
;
; [472] '
;
; [473] '	fmtLevel['^'] =   0		' When these two are format characters, they will be
;
; [474] '	fmtLevel[')'] =   0		' picked up by checking nextChar (just like trailing
;
; [475] '													' signs).
;
; [476] END SUB
end.sub3.0.xformat:
	ret				;;; i127
out.sub3.0.xformat:
;
; [477] '
;
; [478] ' *****  StringString  *****
;
; [479] '
;
; [480] SUB StringString
	jmp	out.sub3.1.xformat			;;; i262
align 16
%s%StringString%3:
;
; .sub3.0001 = ebp-236	; internal variable
;
; [481] DO
align 8
do.0038.xformat:
;
; [482] fmtThisPtr = fmtStrPtr - 1
;
#ifdef XxxFormat$.fmtThisPtr
#undef XxxFormat$.fmtThisPtr
#endif
#define XxxFormat$.fmtThisPtr ebp-240	; exposes local variable 'fmtThisPtr'
;
	mov	eax,d[ebp-28]			;;; i665
	sub	eax,1			;;; i791
	mov	d[ebp-240],eax			;;; i670
;
; [483] q = format${fmtThisPtr}
;
#ifdef XxxFormat$.q
#undef XxxFormat$.q
#endif
#define XxxFormat$.q ebp-244	; exposes local variable 'q'
;
	mov	eax,d[ebp-240]			;;; i665
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-244],eax			;;; i670
;
; [484] qq = fmtBegin[q]
;
#ifdef XxxFormat$.qq
#undef XxxFormat$.qq
#endif
#define XxxFormat$.qq ebp-248	; exposes local variable 'qq'
;
	mov	eax,d[ebp-244]			;;; i665
	mov	edx,d[%%3%%fmtBegin.xformat]			;;; i663a
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-248],eax			;;; i670
;
; [485] qqq = fmtLevel[q]
;
#ifdef XxxFormat$.qqq
#undef XxxFormat$.qqq
#endif
#define XxxFormat$.qqq ebp-252	; exposes local variable 'qqq'
;
	mov	eax,d[ebp-244]			;;; i665
	mov	edx,d[%%3%%fmtLevel.xformat]			;;; i663a
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-252],eax			;;; i670
;
; [486] IFZ q THEN EXIT DO
	mov	eax,d[ebp-244]			;;; i665
	test	eax,eax			;;; i194
	jnz	>> else.0039.xformat			;;; i195
	jmp	end.do.0038.xformat			;;; i144
else.0039.xformat:
end.if.0039.xformat:
;
; [487] r = format${fmtStrPtr}
;
#ifdef XxxFormat$.r
#undef XxxFormat$.r
#endif
#define XxxFormat$.r ebp-256	; exposes local variable 'r'
;
	mov	eax,d[ebp-28]			;;; i665
	mov	edx,d[ebp+8]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-256],eax			;;; i670
;
; [488] SELECT CASE TRUE
;
; [489] CASE (q = '_')	: INC fmtStrPtr: q = r
	mov	eax,d[ebp-244]			;;; i665
	cmp	eax,95			;;; i684a
	jne	>> case.003A.0001.xformat			;;; i219
	inc	d[ebp-28]			;;; i84
	mov	eax,d[ebp-256]			;;; i665
	mov	d[ebp-244],eax			;;; i670
;
; [490] CASE qq					: IF ValidFormat (format$, fmtThisPtr) THEN EXIT DO
	jmp	end.select.003A.xformat			;;; i69
case.003A.0001.xformat:
	mov	eax,d[ebp-248]			;;; i665
	test	eax,eax			;;; i220
	jz	>> case.003A.0002.xformat			;;; i221
	mov	eax,d[ebp+8]			;;; i665
	call	%_clone.a0			;;; i634
	mov	d[ebp-152],eax			;;; i670
	push	[ebp-240]			;;; i674a
	push	[ebp-152]			;;; i674a
	call	func2.xformat			;;; i619
	sub	esp,8			;;; xnt1i
	mov	esi,d[esp]			;;; i871
	call	%____free			;;; i872
	add	esp,8			;;; i633
	test	eax,eax			;;; i220
	jz	>> else.003B.xformat			;;; i221
	jmp	end.do.0038.xformat			;;; i144
else.003B.xformat:
end.if.003B.xformat:
;
; [491] CASE qqq				: EXIT DO
	jmp	end.select.003A.xformat			;;; i69
case.003A.0002.xformat:
	mov	eax,d[ebp-252]			;;; i665
	test	eax,eax			;;; i220
	jz	>> case.003A.0003.xformat			;;; i221
	jmp	end.do.0038.xformat			;;; i144
;
; [492] END SELECT
case.003A.0003.xformat:
end.select.003A.xformat:
;
; [493] resultString$ = resultString$ + CHR$ (q)
	sub	esp,64			;;; i487
	mov	eax,d[ebp-244]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	d[esp+4],1
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-36]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	2			;;; i781e
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-36]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [494] INC fmtStrPtr
	inc	d[ebp-28]			;;; i84
;
; [495] LOOP
do.loop.0038.xformat:
	jmp	do.0038.xformat			;;; i222
end.do.0038.xformat:
;
; [496] IF (fmtStrPtr > lenFmtStr) THEN fmtStrPtr = 0
	mov	eax,d[ebp-28]			;;; i665
	mov	ebx,d[ebp-32]			;;; i665
	cmp	eax,ebx			;;; i684a
	jle	>> else.003C.xformat			;;; i219
	mov	eax,0			;;; i659
	mov	d[ebp-28],eax			;;; i670
else.003C.xformat:
end.if.003C.xformat:
;
; [497] END SUB
end.sub3.1.xformat:
	ret				;;; i127
out.sub3.1.xformat:
;
; [498] '
;
; [499] ' *****  AddCommas  *****
;
; [500] '
;
; [501] SUB AddCommas
	jmp	out.sub3.2.xformat			;;; i262
align 16
%s%AddCommas%3:
;
; .sub3.0002 = ebp-260	; internal variable
;
; [502] DO WHILE comIx > (preDec - argMSDOrder + 3)
align 8
do.003D.xformat:
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-80]			;;; i665
	sub	eax,ebx			;;; i791
	add	eax,3			;;; i775
	mov	ebx,d[ebp-208]			;;; i665
	cmp	eax,ebx			;;; i684a
	jge	>> end.do.003D.xformat			;;; i219
;
; [503] comIx = comIx - 3
	mov	eax,d[ebp-208]			;;; i665
	sub	eax,3			;;; i791
	mov	d[ebp-208],eax			;;; i670
;
; [504] argStr$ = LEFT$(argStr$, comIx) + "," + MID$(argStr$, comIx+1)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-208]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	mov	ebx,addr @_string.00A5.xformat			;;; i663
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	4			;;; i781f
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	mov	[ebp-152],eax			;;; i670
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-208]			;;; i665
	add	eax,1			;;; i775
	mov	d[esp+4],eax			;;; i887
	mov	d[esp+8],2147483647			;;; i579
	call	%_mid.d.v			;;; i580
	add	esp,64			;;; i600
	mov	ebx,[ebp-152]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	6			;;; i781g
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [505] INC lenArg
	inc	d[ebp-52]			;;; i84
;
; [506] LOOP
do.loop.003D.xformat:
	jmp	do.003D.xformat			;;; i222
end.do.003D.xformat:
;
; [507] END SUB
end.sub3.2.xformat:
	ret				;;; i127
out.sub3.2.xformat:
;
; [508] '
;
; [509] ' *****  Rounder  *****
;
; [510] '
;
; [511] SUB Rounder
	jmp	out.sub3.3.xformat			;;; i262
align 16
%s%Rounder%3:
;
; .sub3.0003 = ebp-264	; internal variable
;
; [512] IF ((expCtr = 0) AND (numShift < 0)) THEN' no fmt exp & int(arg) > int(fmt)
	mov	eax,d[ebp-116]			;;; i665
	cmp	eax,0			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.47			;;; i467
	not	eax			;;; i468
A.47:
;+peep
	mov	ebx,d[ebp-68]			;;; i665
	cmp	ebx,0			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jge	> A.48			;;; i467
	not	ebx			;;; i468
A.48:
;+peep
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.003E.xformat			;;; i221
;
; [513] fmtDigCtr = argMSDOrder + postDec
;
#ifdef XxxFormat$.fmtDigCtr
#undef XxxFormat$.fmtDigCtr
#endif
#define XxxFormat$.fmtDigCtr ebp-268	; exposes local variable 'fmtDigCtr'
;
	mov	eax,d[ebp-80]			;;; i665
	mov	ebx,d[ebp-112]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-268],eax			;;; i670
;
; [514] ELSE
	jmp	end.if.003E.xformat			;;; i107
else.003E.xformat:
;
; [515] fmtDigCtr = preDec + postDec
	mov	eax,d[ebp-108]			;;; i665
	mov	ebx,d[ebp-112]			;;; i665
	add	eax,ebx			;;; i775
	mov	d[ebp-268],eax			;;; i670
;
; [516] END IF
end.if.003E.xformat:
;
; [517] '
;
; [518] IF (lenArg > fmtDigCtr) THEN
	mov	eax,d[ebp-52]			;;; i665
	mov	ebx,d[ebp-268]			;;; i665
	cmp	eax,ebx			;;; i684a
	jle	>> else.003F.xformat			;;; i219
;
; [519] rndDig  = argStr${fmtDigCtr}
;
#ifdef XxxFormat$.rndDig
#undef XxxFormat$.rndDig
#endif
#define XxxFormat$.rndDig ebp-272	; exposes local variable 'rndDig'
;
	mov	eax,d[ebp-268]			;;; i665
	mov	edx,d[ebp-60]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-272],eax			;;; i670
;
; [520] argStr$ = LEFT$(argStr$, fmtDigCtr)
	sub	esp,64			;;; i487
	mov	eax,[ebp-60]			;;; i665
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-268]			;;; i665
	mov	d[esp+4],eax			;;; i887
	call	%_left.d.v			;;; i578
	add	esp,64			;;; i600
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [521] '
;
; [522] IF (rndDig >= '5') THEN
	mov	eax,d[ebp-272]			;;; i665
	cmp	eax,53			;;; i684a
	jl	>> else.0040.xformat			;;; i219
;
; [523] stopIt = $$FALSE
;
#ifdef XxxFormat$.stopIt
#undef XxxFormat$.stopIt
#endif
#define XxxFormat$.stopIt ebp-276	; exposes local variable 'stopIt'
;
	mov	eax,0			;;; i659
	mov	d[ebp-276],eax			;;; i670
;
; [524] DO UNTIL stopIt OR (fmtDigCtr = 0)' DO WHILE (fmtDigCtr) in using9.x
align 8
do.0041.xformat:
	mov	eax,d[ebp-268]			;;; i665
	cmp	eax,0			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jne	> A.49			;;; i467
	not	eax			;;; i468
A.49:
;+peep
	mov	ebx,d[ebp-276]			;;; i665
	or	eax,ebx			;;; i763
	test	eax,eax			;;; i194
	jnz	>> end.do.0041.xformat			;;; i195
;
; [525] DEC fmtDigCtr
	dec	d[ebp-268]			;;; i84
;
; [526] lastDig = argStr${fmtDigCtr}
;
#ifdef XxxFormat$.lastDig
#undef XxxFormat$.lastDig
#endif
#define XxxFormat$.lastDig ebp-280	; exposes local variable 'lastDig'
;
	mov	eax,d[ebp-268]			;;; i665
	mov	edx,d[ebp-60]			;;; i665
	movzx	eax,b[edx+eax]			;;; i464
	mov	d[ebp-280],eax			;;; i670
;
; [527] INC lastDig
	inc	d[ebp-280]			;;; i84
;
; [528] IF (lastDig = 0x3a) THEN
	mov	eax,d[ebp-280]			;;; i665
	cmp	eax,58			;;; i684a
	jne	>> else.0042.xformat			;;; i219
;
; [529] lastDig = '0'' 9 -> 0: keep rounding
	mov	eax,48			;;; i659
	mov	d[ebp-280],eax			;;; i670
;
; [530] ELSE
	jmp	end.if.0042.xformat			;;; i107
else.0042.xformat:
;
; [531] stopIt = $$TRUE' no more rounding
	mov	eax,-1			;;; i659
	mov	d[ebp-276],eax			;;; i670
;
; [532] END IF
end.if.0042.xformat:
;
; [533] argStr${fmtDigCtr} = lastDig
	mov	eax,d[ebp-280]			;;; i665
	mov	ebx,d[ebp-268]			;;; i665
	mov	ecx,d[ebp-60]			;;; i665
	lea	ebx,[ecx+ebx]			;;; i464
	mov	b[ebx],al			;;; i29
;
; [534] LOOP' LOOP UNTIL (stopIt) in using9.x
do.loop.0041.xformat:
	jmp	do.0041.xformat			;;; i222
end.do.0041.xformat:
;
; [535] '
;
; [536] IF stopIt AND (fmtDigCtr < numShift) AND (expCtr == 0) THEN' added significant digit
	mov	eax,d[ebp-268]			;;; i665
	mov	ebx,d[ebp-68]			;;; i665
	cmp	eax,ebx			;;; i684a
;>peep
	mov	eax,0			;;; i466
	jge	> A.50			;;; i467
	not	eax			;;; i468
A.50:
;+peep
	mov	ebx,d[ebp-276]			;;; i665
	and	eax,ebx			;;; i769
	mov	ebx,d[ebp-116]			;;; i665
	cmp	ebx,0			;;; i684a
;>peep
	mov	ebx,0			;;; i466
	jne	> A.51			;;; i467
	not	ebx			;;; i468
A.51:
;+peep
	and	eax,ebx			;;; i769
	test	eax,eax			;;; i220
	jz	>> else.0043.xformat			;;; i221
;
; [537] INC argMSDOrder
	inc	d[ebp-80]			;;; i84
;
; [538] DEC numShift
	dec	d[ebp-68]			;;; i84
;
; [539] END IF
else.0043.xformat:
end.if.0043.xformat:
;
; [540] '
;
; [541] IF !stopIt THEN' ran out of format digits
	mov	eax,d[ebp-276]			;;; i665
	neg	eax			;;; i888
	cmc				;;; i889
	rcr	eax,1			;;; i890
	sar	eax,31			;;; i891
	test	eax,eax			;;; i220
	jz	>> else.0044.xformat			;;; i221
;
; [542] IFZ expCtr THEN
	mov	eax,d[ebp-116]			;;; i665
	test	eax,eax			;;; i194
	jnz	>> else.0045.xformat			;;; i195
;
; [543] argStr$ = "1" + argStr$
	mov	eax,addr @_string.00AC.xformat			;;; i663
	mov	ebx,[ebp-60]			;;; i665
	push	eax			;;; i781b
	push	ebx			;;; i781c
	push	0			;;; i781d
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [544] ELSE
	jmp	end.if.0045.xformat			;;; i107
else.0045.xformat:
;
; [545] argStr${0} = '1'
	mov	eax,49			;;; i659
	mov	ecx,d[ebp-60]			;;; i665
	lea	ebx,[ecx]			;;; i464
	mov	b[ebx],al			;;; i29
;
; [546] END IF
end.if.0045.xformat:
;
; [547] INC argMSDOrder
	inc	d[ebp-80]			;;; i84
;
; [548] DEC numShift
	dec	d[ebp-68]			;;; i84
;
; [549] END IF
else.0044.xformat:
end.if.0044.xformat:
;
; [550] END IF' rndDig >= '5'
else.0040.xformat:
end.if.0040.xformat:
;
; [551] ELSE' lenArg <= fmtDigCtr
	jmp	end.if.003F.xformat			;;; i107
else.003F.xformat:
;
; [552] argStr$ = argStr$ + CHR$ ('0', fmtDigCtr - lenArg)
	sub	esp,64			;;; i487
	mov	eax,48			;;; i659
	mov	d[esp],eax			;;; i887
	mov	eax,d[ebp-268]			;;; i665
	mov	ebx,d[ebp-52]			;;; i665
	sub	eax,ebx			;;; i791
	mov	d[esp+4],eax			;;; i887
	call	%_chr.d			;;; i575
	add	esp,64			;;; i600
	mov	ebx,[ebp-60]			;;; i665
	push	ebx			;;; i781
	push	eax			;;; i781a
	push	2			;;; i781e
	call	main.concat			;;; i782
	add	esp,12			;;; i782a
	lea	ebx,[ebp-60]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [553] END IF
end.if.003F.xformat:
;
; [554] END SUB
end.sub3.3.xformat:
	ret				;;; i127
out.sub3.3.xformat:
;
; [555] '
;
; [556] eeeQuitFormat:
%g%eeeQuitFormat%3:
;
; [557] lastErr = ERROR ($$ErrorNatureInvalidArgument)
;
#ifdef XxxFormat$.lastErr
#undef XxxFormat$.lastErr
#endif
#define XxxFormat$.lastErr ebp-284	; exposes local variable 'lastErr'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-284],eax			;;; i670
;
; [558] '	PRINT "e<" + resultString$ + "> " + STRING$(LEN(resultString$))
;
; [559] RETURN (resultString$)
	mov	eax,[ebp-36]			;;; i665
	call	%_clone.a0			;;; i870
	jmp	end.func3.xformat			;;; i258
;
; [562] END FUNCTION
	xor	eax,eax			;;; i862
align 8
end.XxxFormat$.xformat:  ;;; Function end label for Assembly Programmers.
end.func3.xformat:
	mov	esi,[ebp-36]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-136]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-212]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-24]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-60]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-132]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-176]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-140]			;;; i665
	call	%____free			;;; i423
	mov	esi,[ebp-144]			;;; i665
	call	%____free			;;; i423
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	16			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  XxxFormat$ ()  *****
;  *****
;
; [563] '
;
; [564] '
;
; [565] ' ######################
;
; [566] ' #####  Entry ()  #####
;
; [567] ' ######################
;
; [568] '
;
; [569] FUNCTION  XFormat ()
.code
%_StartLibrary_xformat:
	call	func1.xformat			;;; i162c
	ret	0			;;; i162d
align 16
_XFormat.xformat@0:
;  *****
;  *****  FUNCTION  XFormat ()  *****
;  *****
func1.xformat:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	call	%%%%initOnce.xformat
	sub	esp,236			;;; i114a
;
funcBody1.xformat:
;
; [571] END FUNCTION
	xor	eax,eax			;;; i862
align 8
end.XFormat.xformat:  ;;; Function end label for Assembly Programmers.
end.func1.xformat:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret						;;; i111d
;-peep
;  *****
;  *****  END FUNCTION  XFormat ()  *****
;  *****
%%%%initOnce.xformat:
	cmp d[%%%entered.xformat],-1		;;; i117
	jne > A.57	;;; i117a
	ret			;;; i117b
A.57:
	call	PrologCode.xformat			;;; i118a
	mov esi,addr %_begin_external_data_xformat
	mov edi,addr %_end_external_data_xformat
	call %_ZeroMemory
	call	InitSharedComposites.xformat			;;; i119
	mov	d[%%%entered.xformat],-1
	ret				;;; i120
data section 'xformat$internals'
align 4
%%%entered.xformat:
db 4 dup ?
.code
;
; [572] END PROGRAM
end_program.xformat:
	push	ebp			;;; i128
	mov	ebp,esp			;;; i129
	sub	esp,128			;;; i130
	mov	esi,d[%%3%%fmtBegin.xformat]			;;; i663a
	call	%_FreeArray			;;; i424
	mov	esi,d[%%3%%fmtLevel.xformat]			;;; i663a
	call	%_FreeArray			;;; i424
	mov	esp,ebp			;;; i132
	pop	ebp			;;; i133
	ret				;;; i134
;
InitSharedComposites.xformat:
	ret				;;; i143
;;;  *****  DEFINE '.bss' SECTION LIMITS  *****
;
align 8
data section 'xformat$aaaaa'
%_begin_external_data_xformat dd ?
;
align 8
data section 'xformat$zzzzz'
%_end_external_data_xformat dd ?
;
;
;;;  *****  DEFINE LITERAL STRINGS  *****
.const
align 8
;
dd 24, 0, 7, 0x80130001
@_string.0029.xformat:
db	"xformat"
db	1 dup 0
;
dd 24, 0, 6, 0x80130001
@_string.002A.xformat:
db	"0.0002"
db	2 dup 0
;
dd 24, 0, 3, 0x80130001
@_string.002B.xformat:
db	"xst"
db	5 dup 0
;
dd 64, 0, 43, 0x80130001
@_string.006E.xformat:
db	"FORMAT$() : error : (numeric data with '&')"
db	5 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.006F.xformat:
db	"$"
db	7 dup 0
;
dd 48, 0, 28, 0x80130001
@_string.0070.xformat:
db	"FORMAT$() : error : (leading"
db	4 dup 0
;
dd 32, 0, 8, 0x80130001
@_string.0071.xformat:
db	"excludes"
db	8 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0072.xformat:
db	")"
db	7 dup 0
;
dd 80, 0, 59, 0x80130001
@_string.0076.xformat:
db	"FORMAT$() : error : (can't print number with string format)"
db	5 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.007B.xformat:
db	"("
db	7 dup 0
;
dd 64, 0, 41, 0x80130001
@_string.007C.xformat:
db	"FORMAT$() : error : (no printable digits)"
db	7 dup 0
;
dd 56, 0, 37, 0x80130001
@_string.007D.xformat:
db	"FORMAT$() : error : (string argument)"
db	3 dup 0
;
dd 24, 0, 2, 0x80130001
@_string.0084.xformat:
db	"de"
db	6 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.008C.xformat:
db	"."
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0091.xformat:
db	"%"
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0095.xformat:
db	"e"
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0096.xformat:
db	"-"
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0097.xformat:
db	"+"
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.0098.xformat:
db	" "
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.00A5.xformat:
db	","
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.00AC.xformat:
db	"1"
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.00B5.xformat:
db	0x5C
db	7 dup 0
;
dd 24, 0, 1, 0x80130001
@_string.00BB.xformat:
db	";"
db	7 dup 0
;
dd 32, 0, 15, 0x80130001
@_string.StartLibrary.xformat:
db	"%_StartLibrary_"
db	1 dup 0
