/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Bevel;
import common.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;

public class DBPanel
extends Panel
implements ContainerListener,
Bevel {
    public static final int BEVEL_NONE = 0;
    public static final int BEVEL_LINE = 1;
    public static final int BEVEL_LOWERED = 2;
    public static final int BEVEL_RAISED = 3;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTERED = 1;
    public static final int ALIGN_RIGHT = 2;
    Dimension oldSize = new Dimension();
    protected static final int labelpadx = 10;
    protected static final int labelipadx = 4;
    protected Color borderColor = Color.black;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color labelColor = Color.black;
    protected int padtop = 2;
    protected int padbottom = 2;
    protected int padleft = 2;
    protected int padright = 2;
    protected int ixPadLeft = 2;
    protected int ixPadRight = 2;
    protected int iyPadTop = 2;
    protected int iyPadBottom = 2;
    protected int style;
    protected String label;
    protected int labelAlignment;
    protected Insets internalInsets;
    protected Panel panel;
    private Vector cListeners = null;

    public DBPanel() {
        this(null, 1, 1);
    }

    public DBPanel(int n) {
        this(null, 1, n);
    }

    public DBPanel(String string) {
        this(string, 0, 1);
    }

    public DBPanel(String string, int n) {
        this(string, n, 1);
    }

    public DBPanel(String string, int n, int n2) {
        this.label = string != null && string.length() == 0 ? null : string;
        this.labelAlignment = n;
        this.internalInsets = new Insets(2, 2, 2, 2);
        this.style = n2;
        super.setLayout(null);
        this.panel = new Panel();
        super.add(this.panel);
        this.sizepanel(true);
        this.cListeners = new Vector();
        this.setLayout(null);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.padtop = n;
        this.padbottom = n2;
        this.padleft = n3;
        this.padright = n4;
        this.sizepanel(true);
        this.invalidate();
    }

    public void setIPadding(int n, int n2, int n3, int n4) {
        this.ixPadLeft = n;
        this.ixPadRight = n3;
        this.iyPadTop = n2;
        this.iyPadBottom = n4;
        this.sizepanel(true);
        this.invalidate();
    }

    public void setInternalInsets(Insets insets) {
        this.internalInsets = insets;
        this.sizepanel(true);
        this.invalidate();
    }

    public Insets getInternalInsets() {
        return this.internalInsets;
    }

    public void setLabel(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.label = string;
        this.sizepanel(true);
        this.repaint();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.repaint();
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.repaint();
    }

    public void setAlignStyle(int n) {
        this.labelAlignment = n;
        this.sizepanel(true);
        this.repaint();
    }

    public void setBevelStyle(int n) {
        this.style = n;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.panel != null) {
            this.panel.setLayout(layoutManager);
        }
    }

    public Component getComponent(int n) {
        return this.panel.getComponent(n);
    }

    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    public int getComponentCount() {
        return this.panel.getComponentCount();
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.sizepanel(true);
        if (this.panel != null) {
            this.panel.addContainerListener(this);
        }
    }

    public synchronized void removeNotify() {
        if (this.panel != null) {
            this.panel.removeContainerListener(this);
        }
        super.removeNotify();
    }

    public void doLayout() {
        this.sizepanel(false);
        this.panel.doLayout();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == this.panel) {
            super.addImpl(component, object, n);
        } else {
            this.panel.add(component, object, n);
        }
    }

    public void remove(int n) {
        this.panel.remove(n);
    }

    public void remove(Component component) {
        this.panel.remove(component);
    }

    public void removeAll() {
        this.panel.removeAll();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.sizepanel(false);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        graphics.setColor(this.getBackground());
        if (insets.left > 0) {
            graphics.fillRect(0, 0, insets.left, dimension.height);
        }
        if (insets.top > 0) {
            graphics.fillRect(0, 0, dimension.width, insets.top);
        }
        if (insets.bottom > 0) {
            graphics.fillRect(0, dimension.height - insets.bottom, dimension.width, insets.bottom);
        }
        if (insets.right > 0) {
            graphics.fillRect(dimension.width - insets.right, 0, insets.right, dimension.height);
        }
        this.paint(graphics);
        this.panel.repaint();
    }

    public int getComponentsCount() {
        return this.panel.getComponentCount();
    }

    public Insets getInsets() {
        int n = this.getLabelTopMargin();
        Insets insets = this.getInternalInsets();
        return new Insets(n + insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setInnerBackground(Color color) {
        this.panel.setBackground(color);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getSource() == this.panel) {
            for (int i = 0; i < this.cListeners.size(); ++i) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentAdded(new ContainerEvent(this, 300, containerEvent.getChild()));
            }
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getSource() == this.panel) {
            for (int i = 0; i < this.cListeners.size(); ++i) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentRemoved(new ContainerEvent(this, 301, containerEvent.getChild()));
            }
        }
    }

    public void addContainerListener(ContainerListener containerListener) {
        if (this.panel != null) {
            this.panel.addContainerListener(containerListener);
            this.cListeners.addElement(containerListener);
        }
    }

    public void removeContainerListener(ContainerListener containerListener) {
        if (this.panel != null) {
            this.panel.removeContainerListener(containerListener);
            this.cListeners.removeElement(containerListener);
        }
    }

    protected void sizepanel(boolean bl) {
        Dimension dimension = this.getSize();
        if (bl || this.oldSize.width != dimension.width || this.oldSize.height != dimension.height) {
            this.oldSize = dimension;
            this.panel.setBounds(this.padleft + this.ixPadLeft, this.getLabelTopMargin() + this.iyPadTop, dimension.width - this.padright - this.padleft - this.ixPadLeft - this.ixPadRight - 1, dimension.height - this.padbottom - this.getLabelTopMargin() - this.iyPadBottom - this.iyPadTop - 1);
        }
    }

    protected void draw(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.padtop;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.label != null && fontMetrics != null) {
            n = (fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop) / 2;
        }
        int n2 = this.padleft;
        int n3 = n;
        int n4 = dimension.width - this.padleft - this.padright - 1;
        int n5 = dimension.height - 1 - n - this.padbottom;
        this.drawBorder(graphics, n2, n3, n4, n5);
        this.drawLabel(graphics, fontMetrics);
    }

    protected void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.style) {
            case 3: {
                graphics.setColor(this.bevelLighterColor);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 2: {
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.bevelLighterColor);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 1: {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n, n2, n3, n4);
                break;
            }
        }
    }

    protected void drawLabel(Graphics graphics, FontMetrics fontMetrics) {
        if (this.label != null && fontMetrics != null) {
            int n;
            int n2 = 10;
            Dimension dimension = this.getSize();
            if (this.getFont().getSize() > n2) {
                n2 += this.getFont().getSize() / 2;
            }
            int n3 = fontMetrics.stringWidth(this.label);
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.getDescent();
            switch (this.labelAlignment) {
                case 1: {
                    n = (dimension.width - n3) / 2;
                    break;
                }
                case 2: {
                    n = dimension.width - n2 - (n3 + 7);
                    break;
                }
                default: {
                    n = n2 + 7;
                }
            }
            int n6 = n4 + n5 + this.padtop;
            int n7 = (n2 - n6) / 2 + (this.padtop + n4);
            graphics.setColor(this.getBackground());
            graphics.fillRect(n - 2, n7 - 1 - n4 - this.padtop / 2, n3 + 4, n6);
            graphics.setColor(this.labelColor);
            graphics.drawString(this.label, n, n7 - 1);
        }
    }

    public void paint(Graphics graphics) {
        this.sizepanel(false);
        Color color = this.getBackground();
        this.calculateHilightColors(color);
        graphics.setColor(color);
        this.draw(graphics);
    }

    protected int getLabelTopMargin() {
        if (this.label == null) {
            return this.padtop;
        }
        int n = this.padtop;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop + 0;
        }
        return n;
    }

    protected int getLabelWidthMargin() {
        if (this.label == null) {
            return 0;
        }
        int n = 2 + this.internalInsets.left + this.internalInsets.right;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = Math.max(n, 2 + fontMetrics.stringWidth(this.label) + 10 + 4);
        }
        return n;
    }

    protected void calculateHilightColors(Color color) {
        this.bevelLighterColor = ColorUtils.calculateHilightColor(color);
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(color);
    }
}

