/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.SliderTick;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class Slider
extends Canvas {
    public static final int TICK_NONE = 0;
    public static final int TICK_LEFT = 1;
    public static final int TICK_RIGHT = 2;
    public static final int TICK_BOTTOM = 1;
    public static final int TICK_TOP = 2;
    public static final int TICK_BOTH = 3;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LOWERED = 1;
    public static final int BORDER_RAISED = 2;
    Color background = Color.lightGray;
    protected int width;
    protected int height;
    protected boolean forceCallDoReshape = false;
    protected int style = 0;
    protected int freq = 1;
    protected int min = 0;
    protected int max = 255;
    protected int prevPos = 0;
    protected int curPos = 0;
    protected ActionListener actionListener = null;
    protected String actionCommand = "Slider Moved";
    protected transient SliderTick[] tick = null;
    protected static final int BORDER_X = 12;
    protected static final int BORDER_Y = 8;
    public int borderStyle = 0;
    protected int tickWidth = 1;
    protected int tickStep = 5;
    String slidername;
    boolean notified = false;

    protected Slider() {
    }

    public void setTickStyle(int n) {
        this.style = n;
        this.forceCallDoReshape = true;
    }

    public int getTickStyle() {
        return this.style;
    }

    public void setBorderStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.borderStyle = n;
                break;
            }
        }
    }

    public void setMinValue(int n) {
        if (n < 0) {
            n = 0;
        }
        this.min = n;
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getMinValue() {
        return this.min;
    }

    public void setMaxValue(int n) {
        if (n < 0) {
            n = 0;
        }
        this.max = n;
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setTickFreq(int n) {
        if (this.freq != n) {
            if (n > this.max) {
                n = this.max;
            }
            if (n < this.min) {
                n = this.min;
            }
            int n2 = this.curPos * this.freq + this.min;
            this.freq = n;
            this.doMove((n2 - this.min) / this.freq, false);
            this.forceCallDoReshape = true;
            this.repaint();
        }
    }

    public int getTickFreq() {
        return this.freq;
    }

    public void setValue(int n) {
        if (n < this.getMinValue()) {
            n = this.getMinValue();
        } else if (n > this.getMaxValue()) {
            n = this.getMaxValue();
        }
        this.doMove((n - this.min) / this.freq, false);
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getValue() {
        return this.curPos * this.freq + this.min;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected abstract void do_reshape(int var1, int var2);

    protected void doMove(int n, boolean bl) {
        if (this.tick == null) {
            this.prevPos = this.curPos = n;
            return;
        }
        if (n >= this.tick.length) {
            n = this.tick.length - 1;
        }
        if (n != this.curPos || bl) {
            this.prevPos = this.curPos;
            this.curPos = n;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
            graphics = null;
            this.sourceActionEvent();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl = false;
        Dimension dimension = this.getSize();
        if (this.width != dimension.width) {
            this.width = dimension.width;
            bl = true;
        }
        if (this.height != dimension.height) {
            this.height = dimension.height;
            bl = true;
        }
        if (this.forceCallDoReshape || bl) {
            this.do_reshape(this.width, this.height);
            this.forceCallDoReshape = false;
        }
    }

    protected void moveThumb(int n, boolean bl) {
        if (this.tick.length > 1) {
            int n2 = this.tick[1].x - this.tick[0].x;
            if (n2 == 0) {
                return;
            }
            int n3 = (n - this.tick[0].x) / n2;
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n - this.tick[0].x) % n2 > n2 / 2) {
                ++n3;
            }
            this.doMove(n3, bl);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void addNotify() {
        super.addNotify();
        this.notified = true;
    }
}

