/*
 * Decompiled with CFR 0.152.
 */
package chat;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Room
implements Cloneable,
Serializable {
    static final long serialVersionUID = -2034561648711108435L;
    private int id;
    private String name;
    private String administrator;
    private String info;
    private String rules;
    private Dimension size;
    private Vector userVector;
    private Vector invitedUserVector;
    private Vector kickedUserVector;
    private boolean privacy;
    private boolean demo;
    private long lastAccess;

    public Room(int n, String string, Dimension dimension) {
        this.name = string;
        this.id = n;
        this.size = dimension;
        this.userVector = new Vector();
        this.invitedUserVector = new Vector();
        this.kickedUserVector = new Vector();
        this.privacy = false;
        this.demo = false;
        this.administrator = "";
        this.info = "";
        this.rules = "";
        this.lastAccess = System.currentTimeMillis();
    }

    public GregorianCalendar getLastAccess() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(this.lastAccess));
        return gregorianCalendar;
    }

    public void setLastAccess(GregorianCalendar gregorianCalendar) {
        this.lastAccess = gregorianCalendar.getTime().getTime();
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addUser(String string) {
        if (!this.isPrivate() && !this.isKicked(string) || this.isPrivate() && this.isInvited(string) || this.isAdministrator(string)) {
            this.userVector.addElement(string);
        }
    }

    public void removeUser(String string) {
        this.userVector.removeElement(string);
    }

    public int getNrOfUsers() {
        return this.userVector.size();
    }

    public void removeAllUsers() {
        this.userVector = new Vector();
    }

    public Vector getUserNameVector() {
        return this.userVector;
    }

    public boolean isPrivate() {
        return this.privacy;
    }

    public void setPrivate(boolean bl) {
        this.privacy = bl;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean bl) {
        this.demo = bl;
    }

    public void inviteUser(String string) {
        if (!this.isInvited(string)) {
            this.invitedUserVector.addElement(string);
        }
    }

    public void uninviteUser(String string) {
        this.invitedUserVector.removeElement(string);
    }

    public void kickUser(String string) {
        if (!this.isKicked(string)) {
            this.kickedUserVector.addElement(string);
        }
    }

    public void unkickUser(String string) {
        this.kickedUserVector.removeElement(string);
    }

    public boolean isInvited(String string) {
        int n = 0;
        while (n < this.invitedUserVector.size()) {
            if (string.equals(this.invitedUserVector.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isKicked(String string) {
        int n = 0;
        while (n < this.kickedUserVector.size()) {
            if (string.equals(this.kickedUserVector.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasAccess(String string) {
        return this.isAdministrator(string) || this.isPrivate() && this.isInvited(string) || !this.isPrivate() && !this.isKicked(string);
    }

    public void setAdministrator(String string) {
        this.administrator = string;
    }

    public String getAdministrator() {
        return this.administrator;
    }

    public boolean isAdministrator(String string) {
        return string != null && (string.equals(this.administrator) || string.equals(Room.a("0E P(")));
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setRules(String string) {
        this.rules = string;
    }

    public String getRules() {
        return this.rules;
    }

    public Vector getInvitedUsers() {
        return this.invitedUserVector;
    }

    public void setInvitedUsers(Vector vector) {
        this.invitedUserVector = vector;
    }

    public Vector getKickedUsers() {
        return this.kickedUserVector;
    }

    public void setKickedUsers(Vector vector) {
        this.kickedUserVector = vector;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            char c = cArray[n4];
            switch (n2 % 5) {
                case 0: {
                    n3 = 113;
                    break;
                }
                case 1: {
                    n3 = 33;
                    break;
                }
                case 2: {
                    n3 = 77;
                    break;
                }
                case 3: {
                    n3 = 57;
                    break;
                }
                default: {
                    n3 = 70;
                }
            }
            cArray[n4] = (char)(c ^ n3);
            ++n2;
        }
        return new String(cArray);
    }
}

